local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"
local Object = require "classic"
local haircolordefined = require "facecute.haircolor.haircolordefined"
local HariBoxRender = require "facecute.haircolor.hairboxrender"
local hairtarget = require "facecute.haircolor.hairrendertarget"
local cnnseg= require "videodecet.cnnseg"
local faceseg = require "videodecet.faceseg"
local videodecet = require "videodecet"
local videodefined = require "videodecet.defined"
local imageutility = require "imageutility"
--local historicalframe = require "facecute.haircolor.historicalframe"
local likeapp = require "likeapp"






--处理头发染色
local haircolor = Object:extend();

function haircolor:new()
  --self.boxnode = apollonode.ModelNode();
  faceseg:RegisterSegJudgeFunc(videodefined.faceSegType.CNNSEG_FULL_HAIR,self,self.NeedHairSegment);
  self:SetConstMask();
  hairtarget:Enable();
end


function haircolor:SetConstMask()
    self.ts = apolloengine.TextureStream();
    self.ts:SetStreamType(
    	mathfunction.vector2(32,1),
    	apolloengine.TextureEntity.PF_L8);
    for u=1, 32 do
      self.ts:SetPixel(u, 1, mathfunction.vector1(0.0));
    end    

  self.const_mask= apolloengine.TextureEntity();
  self.const_mask:PushMetadata(
  apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_WRITE,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
       self.ts));
  self.const_mask:SetKeepSource(true);
  self.const_mask:CreateResource();
  
end

--解析染色部分配置
function haircolor:ParseConfig(config,para,box)
  if config ~= nil then
    local version = config.version;
    if version ~= nil and version == 2 then
      hairtarget:CreateQuad(haircolordefined.changecolor_material_2);
    else
      hairtarget:CreateQuad(haircolordefined.changecolor_material);
    end
    local dst_color_map = config.dst_color_map;
    if dst_color_map ~= nil then
      local color_box = para[1].."/" .. dst_color_map.color_box;
	    local left_map  = para[1] .. "/" .. dst_color_map.color_face_left;
      local right_map = para[1] .. "/" .. dst_color_map.color_face_right;
      local front_map = para[1] .. "/" .. dst_color_map.color_face_front;
	    local back_map  = para[1] .. "/" .. dst_color_map.color_face_back;
      local top_map   = para[1] .. "/" .. dst_color_map.color_face_top;
      local bottom_map = para[1] .. "/" .. dst_color_map.color_face_bottom;
      local color_box_width = dst_color_map.Width;
      local color_box_height = dst_color_map.Height;
      local color_box_depth = dst_color_map.Depth;
      local depth = color_box_depth;
      local sharpen_stregth = dst_color_map.ShaprRatio or 0.6;
      local brightness = dst_color_map.Brightness or 1.0; --调整亮度
      --local brightness_range = dst_color_map.BrightnessRange or {0,1};  --默认亮度范围：全范围
      --local brightness_low = brightness_range[1] or 0;
      --local brightness_high = brightness_range[2] or 1;
      local lut = para[1] .. "/" .. dst_color_map.lut;
      local high_lights = dst_color_map.HightLights or 1.0;
      local mid_tone = dst_color_map.MidTone or 0.5;
      local shadow = dst_color_map.Shadow or 0.0;
	  
	  --获取亮度调节曲线参数
      local brightness_curve_coef1 = dst_color_map.BrightnessCurveCoef1 or 0;
      local brightness_curve_coef2 = dst_color_map.BrightnessCurveCoef2 or 0;
      local brightness_curve_coef3 = dst_color_map.BrightnessCurveCoef3 or 1;
      local brightness_curve_coef4 = dst_color_map.BrightnessCurveCoef4 or 0;
	  
	  --获取亮度调节曲线参数
      local saturation_curve_coef1 = dst_color_map.SaturationCurveCoef1 or 0;
      local saturation_curve_coef2 = dst_color_map.SaturationCurveCoef2 or 0;
      local saturation_curve_coef3 = dst_color_map.SaturationCurveCoef3 or 1;
      local saturation_curve_coef4 = dst_color_map.SaturationCurveCoef4 or 0;
	  
	    self.hair_box = HariBoxRender(box,haircolordefined.boundingbox_material,left_map,right_map,front_map,back_map,top_map,bottom_map);
      hairtarget:Queue(self.hair_box);
	   
      --直接采用模型尺寸方法
      --[[self.boxnode:CreateResource(color_box,haircolordefined.colorbox_material);
      self.center = box:GetCenter() + mathfunction.vector3(0.0,0.0,-0.08);
      self.boxnode:SetLocalPosition(self.center);
      self.boxnode:SetLocalScale(mathfunction.vector3(color_box_width,color_box_height,color_box_depth));
      self.boxnode:SetLoop(true);
      self.boxnode:Play();]]--
      hairtarget:SetLuttable(lut);
      hairtarget:SetSharpStregth(sharpen_stregth);
      hairtarget:SetBrightness(brightness);
      --hairtarget:SetBrightnessRange(brightness_low,brightness_high);
      hairtarget:SetBrightnessRange(high_lights,mid_tone,shadow);
	    hairtarget:SetBrightnessCurveCoef(brightness_curve_coef1,brightness_curve_coef2,brightness_curve_coef3,brightness_curve_coef4);
	    hairtarget:SetSaturationCurveCoef(saturation_curve_coef1,saturation_curve_coef2,saturation_curve_coef3,saturation_curve_coef4);
      hairtarget:Active();
    end
  end
  self.hair_box:SetShow(true);
  self:SetShow(true)
  self.isShow = true;
  if(likeapp.AI.ActiveCnnseg)
  then
    likeapp.AI:ActiveCnnseg(true);
  end
  faceseg:SetSegMark(videodefined.faceSegType.CNNSEG_FULL_HAIR,true);
end


function haircolor:SetRootNode(head)
  --head:AttachNode(self.boxnode);
  --self.hair_box:SetRoot(head);
  self.head = head;
end

function haircolor:SetShow(isShow)
  if self.isShow ~= isShow then
    self.isShow = isShow;
	  --self.hair_box:SetShow(isShow);
    --self.boxnode:SetShow(isShow);
  end
end

function haircolor:Update(timespan, face, position, rotation, action)
  
  local hair_mask_texture,hair_mask_box,hair_mask_texturestream = faceseg:GetSegTextureAndBox(2);
  if hair_mask_texture == nil then
    LOG("VENUS: mask is nil");
    hair_mask_texture  = self.const_mask;
    hair_mask_texturestream = nil;
  end
  --local NumOfBox = 0;
  --if hair_mask_box == nil then
  --  LOG("VENUS: box is nil");
  --else
  --  NumOfBox = #hair_mask_box;
  --end
  
  --估算盒子
  --local BoxForHead = {1,10}
  --local facerect = face:GetRect();
  --local facecenter = face:GetKeypoint(47);
  --for i=1,NumOfBox,1 do
    --LOG("get mask and box");
	  --LOG("face1"..facecenter[1].." face2"..facecenter[2]);
    --if hair_mask_box[i][1]<facecenter[1] and hair_mask_box[i][3] >facecenter[1] and hair_mask_box[i][4] > facecenter[2]then
        --BoxForHead[1] = i;
    --end
  --end
  --local i = BoxForHead[1];
  --local i = 1;
  --if hair_mask_box ~= nil then
  --  local left_bottom = mathfunction.vector2(hair_mask_box[i][1],hair_mask_box[i][2]);
  --	local left_top = mathfunction.vector2(hair_mask_box[i][1],hair_mask_box[i][4]);
	--  local right_bottom = mathfunction.vector2(hair_mask_box[i][3],hair_mask_box[i][2]);
	--  local right_top = mathfunction.vector2(hair_mask_box[i][3],hair_mask_box[i][4]);
  --  local boxw = hair_mask_box[i][3];
  --  local boxh = hair_mask_box[i][4];
    --LOG("left_bottom "..left_bottom[1].." "..left_bottom[2]);
    --LOG("left_top "..left_top[1].." "..left_top[2]);
    --LOG("right_bottom "..right_bottom[1].." "..right_bottom[2]);
    --LOG("right_top "..right_top[1].." "..right_top[2]);
	
    --self.boxnode:SetLocalScale(mathfunction.vector3(boxw,boxh,depth));
	  --local rect = mathfunction.Aabrect(mathfunction.vector2(left_bottom[1]*0.5+0.5,left_bottom[2]*0.5+0.5),mathfunction.vector2(right_top[1]*0.5+0.5,right_top[2]*0.5+0.5));
    --local mask_resolution = hair_mask_texturestream:GetSize();
    --local mask_resolution = mathfunction.vector2(128.0,128.0);
    --LOG(mask_resolution);
   -- local rectmin = mathfunction.vector2(0,0);
    --local rectmax = mathfunction.vector2(1,1);
    --self.hair_box:SetLocalPosition(self.head:GetWorldPosition());
    --self.hair_box:SetLocalRotation(self.head:GetWorldRotation());
    --self.hair_box:SetLocalScale(self.head:GetWorldScale());
    --self.hair_box:Update(left_bottom,left_top,right_bottom,right_top); --有头发rect估算box
  --end
  
  --[[local picthrollyaw = face:GetRotation();
  local yaw = picthrollyaw[3];
  local pitch = picthrollyaw[1];
  local roll = picthrollyaw[2]
  local rotation_ = mathfunction.Mathutility:YawPitchRoll(0.0,math.rad(pitch),math.rad(roll));  --只留下Y轴旋转
  rotation_:InverseSelf();
  self.boxnode:SetLocalRotation(rotation_);]]--
  
  local video_image_textue = videodecet:GetVideoTexture();
  --local video_image_textue = renderqueue:GetTexture(renderqueue:GetLink(renderqueue.CAMERA_LAYER_ZERO));
  hairtarget:Update(hair_mask_texture,video_image_textue,self.left_bottom,self.right_top);
  hairtarget:SetShow(true);
end
function haircolor:NeedHairSegment()
  return true;
end

function haircolor:FixUpdate()
  local hair_mask_texture,hair_mask_box,hair_mask_texturestream = faceseg:GetSegTextureAndBox(2);

  local NumOfBox = 0;
  if hair_mask_box == nil then
    LOG("VENUS: box is nil");
    hair_mask_texture  = self.const_mask;
    hair_mask_texturestream = nil;
  else
    NumOfBox = #hair_mask_box;
  end
  
  if hair_mask_texture == nil then
    LOG("VENUS: mask is nil");
    hair_mask_texture  = self.const_mask;
    hair_mask_texturestream = nil;
  end
  if hair_mask_box ~= nil and hair_mask_texture ~= nil and #hair_mask_box~= 0 then
    local left_bottom = mathfunction.vector2(hair_mask_box[1][1],hair_mask_box[1][2]);
  	local left_top = mathfunction.vector2(hair_mask_box[1][1],hair_mask_box[1][4]);
	  local right_bottom = mathfunction.vector2(hair_mask_box[1][3],hair_mask_box[1][2]);
	  local right_top = mathfunction.vector2(hair_mask_box[1][3],hair_mask_box[1][4]);
    local boxw = hair_mask_box[1][3];
    local boxh = hair_mask_box[1][4];
    self.hair_box:SetLocalPosition(self.head:GetWorldPosition());
    self.hair_box:SetLocalRotation(self.head:GetWorldRotation());
    self.hair_box:SetLocalScale(self.head:GetWorldScale());
    self.hair_box:Update(left_bottom,left_top,right_bottom,right_top); --有头发rect估算box
    
    local video_image_textue = videodecet:GetVideoTexture();
	--local video_image_textue = renderqueue:GetTexture(renderqueue:GetLink(renderqueue.CAMERA_LAYER_ZERO));
    hairtarget:Update(hair_mask_texture,video_image_textue,left_bottom,right_top);
    hairtarget:SetShow(true);
    
    --historicalframe:SetHairMask(hair_mask_texture);
    --historicalframe:SetVideoTexture(video_image_textue);
    --historicalframe:SetShow(true);
  else
    local video_image_textue = videodecet:GetVideoTexture();
	--local video_image_textue = renderqueue:GetTexture(renderqueue:GetLink(renderqueue.CAMERA_LAYER_ZERO));
    hairtarget:Update(hair_mask_texture,video_image_textue,mathfunction.vector2(0.0,0.0),mathfunction.vector2(1.0,1.0));
    hairtarget:SetShow(true);
    --historicalframe:SetHairMask(hair_mask_texture);
    --historicalframe:SetVideoTexture(video_image_textue);
   -- historicalframe:SetShow(true);
  end
end



return haircolor;