local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local Object = require "classic"

local HairBoxRender = Object:extend();
function HairBoxRender:new(box,material,left_texture,right_texture,front_texture,back_texture,top_texture,bottom_texture)

  self.hair_box = box;
  self.hair_box_node = apollonode.RenderNode();
  self.left_node = apollonode.RenderNode();
  self.right_node = apollonode.RenderNode();
  self.front_node = apollonode.RenderNode();
  self.back_node = apollonode.RenderNode();
  self.top_node = apollonode.RenderNode();
  self.bottom_node = apollonode.RenderNode();
  self.hair_box_node:AttachNode(self.left_node);
  self.hair_box_node:AttachNode(self.right_node);
  self.hair_box_node:AttachNode(self.front_node);
  self.hair_box_node:AttachNode(self.back_node);
  self.hair_box_node:AttachNode(self.top_node);
  self.hair_box_node:AttachNode(self.bottom_node);
  
  self:InitStream(box);
  self:InitTexture(left_texture,right_texture,front_texture,back_texture,top_texture,bottom_texture);
  self:InitRender(material);
end

function HairBoxRender:InitTexture(left_texture,right_texture,front_texture,back_texture,top_texture,bottoom_texture)
  --left
  self.left_map = apolloengine.TextureEntity();
  self.left_map:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      left_texture));
  self.left_map:CreateResource();
  
  --right
  self.right_map = apolloengine.TextureEntity();
  self.right_map:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      right_texture));
  self.right_map:CreateResource();
  
  --front
  self.front_map = apolloengine.TextureEntity();
  self.front_map:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      front_texture));
  self.front_map:CreateResource();
  
  --back
  self.back_map = apolloengine.TextureEntity();
  self.back_map:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      back_texture));
  self.back_map:CreateResource();
  
  --top
  self.top_map = apolloengine.TextureEntity();
  self.top_map:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      top_texture));
  self.top_map:CreateResource();
  
  --bottom
  self.bottom_map = apolloengine.TextureEntity();
  self.bottom_map:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      bottoom_texture));
  self.bottom_map:CreateResource();
end


function HairBoxRender:InitStream(box)

  local min = box:GetMin() - mathfunction.vector3(0.02,0.1,0.03);
  local max = box:GetMax() + mathfunction.vector3(0.02,0.05,0.0);
    
  local front_left_bottom = mathfunction.vector4(min:x(),min:y(),max:z(),1.0);
  local front_right_bottom = mathfunction.vector4(max:x(),min:y(),max:z(),1.0);
  local front_right_top = mathfunction.vector4(max:x(),max:y(),max:z(),1.0);
  local front_left_top = mathfunction.vector4(min:x(),max:y(),max:z(),1.0);
  local back_left_top = mathfunction.vector4(min:x(),max:y(),min:z(),1.0);
  local back_left_bottom = mathfunction.vector4(min:x(),min:y(),min:z(),1.0);
  local back_right_top = mathfunction.vector4(max:x(),max:y(),min:z(),1.0);
  local back_right_bottom = mathfunction.vector4(max:x(),min:y(),min:z(),1.0);
  
  self.left_vertexstream = apolloengine.VertexStream();--创建顶点流
  self.left_vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
  self.left_vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  self.left_vertexstream:ReserveBuffer(4); --把每一个面拆开渲染
  self.left_indexstream = apolloengine.IndicesStream(); 
  self.left_indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  self.left_indexstream:ReserveBuffer(6);
  
  self.right_vertexstream = apolloengine.VertexStream();--创建顶点流
  self.right_vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
  self.right_vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  self.right_vertexstream:ReserveBuffer(4); --把每一个面拆开渲染
  self.right_indexstream = apolloengine.IndicesStream(); 
  self.right_indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  self.right_indexstream:ReserveBuffer(6);
  
  self.front_vertexstream = apolloengine.VertexStream();--创建顶点流
  self.front_vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
  self.front_vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  self.front_vertexstream:ReserveBuffer(4); --把每一个面拆开渲染
  self.front_indexstream = apolloengine.IndicesStream(); 
  self.front_indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  self.front_indexstream:ReserveBuffer(6);
  
  self.back_vertexstream = apolloengine.VertexStream();--创建顶点流
  self.back_vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
  self.back_vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  self.back_vertexstream:ReserveBuffer(4); --把每一个面拆开渲染
  self.back_indexstream = apolloengine.IndicesStream(); 
  self.back_indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  self.back_indexstream:ReserveBuffer(6);
  
  self.top_vertexstream = apolloengine.VertexStream();--创建顶点流
  self.top_vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
  self.top_vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  self.top_vertexstream:ReserveBuffer(4); --把每一个面拆开渲染
  self.top_indexstream = apolloengine.IndicesStream(); 
  self.top_indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  self.top_indexstream:ReserveBuffer(6);
  
  self.bottom_vertexstream = apolloengine.VertexStream();--创建顶点流
  self.bottom_vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
  self.bottom_vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  self.bottom_vertexstream:ReserveBuffer(4); --把每一个面拆开渲染
  self.bottom_indexstream = apolloengine.IndicesStream(); 
  self.bottom_indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  self.bottom_indexstream:ReserveBuffer(6);
  
  --front
  self.front_indexstream:PushIndicesData(0);
  self.front_indexstream:PushIndicesData(1);
  self.front_indexstream:PushIndicesData(2);
  self.front_indexstream:PushIndicesData(2);
  self.front_indexstream:PushIndicesData(1);
  self.front_indexstream:PushIndicesData(3);
  self.front_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,front_left_top);
  self.front_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,front_left_bottom);
  self.front_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,front_right_top);
  self.front_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,front_right_bottom);
  self.front_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 0));
  self.front_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 1));
  self.front_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 0));
  self.front_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 1));
  
  --back
  self.back_indexstream:PushIndicesData(0);
  self.back_indexstream:PushIndicesData(1);
  self.back_indexstream:PushIndicesData(2);
  self.back_indexstream:PushIndicesData(2);
  self.back_indexstream:PushIndicesData(1);
  self.back_indexstream:PushIndicesData(3);
  self.back_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,back_right_top);
  self.back_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,back_right_bottom);
  self.back_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,back_left_top);
  self.back_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,back_left_bottom);
  self.back_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 0));
  self.back_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 1));
  self.back_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 0));
  self.back_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 1));
  
  --top
  self.top_indexstream:PushIndicesData(0);
  self.top_indexstream:PushIndicesData(1);
  self.top_indexstream:PushIndicesData(2);
  self.top_indexstream:PushIndicesData(2);
  self.top_indexstream:PushIndicesData(1);
  self.top_indexstream:PushIndicesData(3);
  self.top_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,back_left_top);
  self.top_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,front_left_top);
  self.top_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,back_right_top);
  self.top_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,front_right_top);
  self.top_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 0));
  self.top_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 1));
  self.top_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 0));
  self.top_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 1));
  
  --bottom
  self.bottom_indexstream:PushIndicesData(0);
  self.bottom_indexstream:PushIndicesData(1);
  self.bottom_indexstream:PushIndicesData(2);
  self.bottom_indexstream:PushIndicesData(2);
  self.bottom_indexstream:PushIndicesData(1);
  self.bottom_indexstream:PushIndicesData(3);
  self.bottom_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,front_left_bottom);
  self.bottom_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,back_left_bottom);
  self.bottom_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,front_right_bottom);
  self.bottom_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,back_right_bottom);
  self.bottom_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 0));
  self.bottom_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 1));
  self.bottom_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 0));
  self.bottom_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 1));
  

  self.left_indexstream:PushIndicesData(0);
  self.left_indexstream:PushIndicesData(1);
  self.left_indexstream:PushIndicesData(2);
  self.left_indexstream:PushIndicesData(2);
  self.left_indexstream:PushIndicesData(1);
  self.left_indexstream:PushIndicesData(3);
  self.left_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,back_left_top);
  self.left_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,back_left_bottom);
  self.left_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,front_left_top);
  self.left_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,front_left_bottom);
  self.left_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 0));
  self.left_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 1));
  self.left_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 0));
  self.left_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 1));
  
  --right
  self.right_indexstream:PushIndicesData(0);
  self.right_indexstream:PushIndicesData(1);
  self.right_indexstream:PushIndicesData(2);
  self.right_indexstream:PushIndicesData(2);
  self.right_indexstream:PushIndicesData(1);
  self.right_indexstream:PushIndicesData(3);
  self.right_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,front_right_top);
  self.right_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,front_right_bottom);
  self.right_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,back_right_top);
  self.right_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,back_right_bottom);
  self.right_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 0));
  self.right_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 1));
  self.right_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 0));
  self.right_vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 1));
  
end

function HairBoxRender:InitRender(material)
  self.left_node:CreateResource(material, apolloengine.RenderObjectEntity.RM_TRIANGLES, self.left_vertexstream, self.left_indexstream);
  self.right_node:CreateResource(material, apolloengine.RenderObjectEntity.RM_TRIANGLES, self.right_vertexstream, self.right_indexstream);
  self.front_node:CreateResource(material, apolloengine.RenderObjectEntity.RM_TRIANGLES, self.front_vertexstream, self.front_indexstream);
  self.back_node:CreateResource(material, apolloengine.RenderObjectEntity.RM_TRIANGLES, self.back_vertexstream, self.back_indexstream);
  self.top_node:CreateResource(material, apolloengine.RenderObjectEntity.RM_TRIANGLES, self.top_vertexstream, self.top_indexstream);
  self.bottom_node:CreateResource(material, apolloengine.RenderObjectEntity.RM_TRIANGLES, self.bottom_vertexstream, self.bottom_indexstream);
 
  self.left_node:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.left_map);
  self.right_node:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.right_map);
  self.front_node:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.front_map);
  self.back_node:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.back_map);
  self.top_node:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.top_map);
  self.bottom_node:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.bottom_map);
end

function HairBoxRender:SetRoot(parent)
  parent:AttachNode(self.hair_box_node);
end

function HairBoxRender:SetShow(isShow)
  self.hair_box_node:SetShow(isShow);
  self.left_node:SetShow(isShow);
  self.right_node:SetShow(isShow);
  self.front_node:SetShow(isShow);
  self.back_node:SetShow(isShow);
  self.top_node:SetShow(isShow);
  self.bottom_node:SetShow(isShow);
end

function HairBoxRender:Queue(layer)
  renderqueue:Queue(layer,self.left_node);
  renderqueue:Queue(layer,self.right_node);
  renderqueue:Queue(layer,self.front_node);
  renderqueue:Queue(layer,self.back_node);
  renderqueue:Queue(layer,self.top_node);
  renderqueue:Queue(layer,self.bottom_node);
  self.camera = renderqueue:GetCamera(layer); --得到渲染相机
end

function HairBoxRender:SetSequence(layer)
  self.left_node:SetSequence(layer);
  self.right_node:SetSequence(layer);
  self.front_node:SetSequence(layer);
  self.back_node:SetSequence(layer);
  self.top_node:SetSequence(layer);
  self.bottom_node:SetSequence(layer);
end

function HairBoxRender:SetCamera(camera)
  self.camera = camera;
end


function HairBoxRender:SetLocalPosition(pos)
  self.hair_box_node:SetLocalPosition(pos);
end

function HairBoxRender:SetLocalRotation(rot)
  self.hair_box_node:SetLocalRotation(rot);
end

function HairBoxRender:SetLocalScale(scale)
  self.hair_box_node:SetLocalScale(scale);
end





--更新顶点流
function HairBoxRender:Update(left_bottom,left_top,right_bottom,right_top)
  

  
  --下面是用头发的mask来估算box大小的，先不用
  --local targetResolution = apolloengine.Framework:GetResolution()
  --local min_pixel = mask_rect:LeftBottom() * (targetResolution / mask_resolution);
  --local max_pixel = mask_rect:RightTop() * (targetResolution / mask_resolution);
  --local min_pixel = mask_rect:LeftBottom() * (targetResolution);
  --local max_pixel = mask_rect:RightTop() * (targetResolution);
  --local left_bottom = mathfunction.vector2(min_pixel:x() / targetResolution:x() * 2.0 - 1.0, 1.0 - min_pixel:y() / targetResolution:y() * 2);
  --local right_top = mathfunction.vector2(max_pixel:x() / targetResolution:x() * 2.0 - 1.0, 1.0 - max_pixel:y() / targetResolution:y() * 2);
  --local left_top = mathfunction.vector2(left_bottom:x(),right_top:y());
  --local right_bottom = mathfunction.vector2(right_top:x(),left_bottom:y());
  --LOG("min_pixel"..min_pixel:LeftBottom());
  -- LOG("max_pixel"..max_pixel:LeftBottom());
  
  --现在直接获取区域点坐标
  --LOG("left_bottom"..left_bottom:x().." "..left_bottom:y());
  --LOG("right_top"..right_top:x().." "..right_top:y());
  local ray1 = self.camera:PickRay(left_bottom);
  local ray2 = self.camera:PickRay(right_top);
  local ray3 = self.camera:PickRay(left_top);
  local ray4 = self.camera:PickRay(right_bottom);
  
  local worldTransform = self.hair_box_node:GetWorldTransform();
  --local worldRotation = self.hair_box_node:GetWorldRotation();
  local boxCenter = self.hair_box:GetCenter();
  local worldBoxCenter = boxCenter * worldTransform;
  local normal = mathfunction.vector4(0.0,0.0,1.0,0.0);
  local normalTmp = normal * worldTransform;
  local worldNormal = mathfunction.vector3(normalTmp:x(),normalTmp:y(),normalTmp:z());
  
  
  --修改为转动超过60度就用60度的方向
  local cosV = mathfunction.vector3(0,0,1.0):Dot(worldNormal);
  if cosV < math.cos(3.1415926 / 3) then
    --LOG("The angle > 60");
    
    --计算旋转轴
    --local angle = math.acos(cosV) * (180.0 / 3.1415926);
    --LOG("The angle is " .. tostring(angle));
    local rotAxis =  mathfunction.vector3(0,0,1.0):Cross(worldNormal);
    local rotQuat = mathfunction.Quaternion();
    rotQuat:RotateAxis(rotAxis,3.1415926 / 3);
    worldNormal = mathfunction.vector3(0,0,1.0) * rotQuat;
    
    --worldNormal = mathfunction.vector3(0,0,1.0);
    --LOG("The angle > 60");
  end
  worldNormal:NormalizeSelf();
  
  local worldPlane = mathfunction.Plane(worldBoxCenter,worldNormal);
  local world_intersect_pt1 = worldPlane:IntersectPoint(ray1);
  local world_intersect_pt2 = worldPlane:IntersectPoint(ray2);
  local world_intersect_pt3 = worldPlane:IntersectPoint(ray3);
  local world_intersect_pt4 = worldPlane:IntersectPoint(ray4);
  
  
  local thickness = 0.04;
  local world_hair_box_front_left_bottom = world_intersect_pt1 + worldNormal * thickness;
  local world_hair_box_front_right_bottom = world_intersect_pt4 + worldNormal * thickness;
  local world_hair_box_front_right_top = world_intersect_pt2 + worldNormal * thickness;
  local world_hair_box_front_left_top = world_intersect_pt3 + worldNormal * thickness;
  
  local world_hair_box_back_left_top = world_intersect_pt3 + worldNormal * -thickness;
  local world_hair_box_back_left_bottom = world_intersect_pt1 + worldNormal * -thickness;
  local world_hair_box_back_right_top = world_intersect_pt2 + worldNormal * -thickness;
  local world_hair_box_back_right_bottom = world_intersect_pt4 + worldNormal * -thickness;
  self:UpdateStream(world_hair_box_front_left_bottom,world_hair_box_front_right_bottom,world_hair_box_front_right_top,world_hair_box_front_left_top,
    world_hair_box_back_left_top,world_hair_box_back_left_bottom,world_hair_box_back_right_top,world_hair_box_back_right_bottom);
  
end

function HairBoxRender:UpdateStream(pt1,pt2,pt3,pt4,pt5,pt6,pt7,pt8)
  local front_left_bottom = mathfunction.vector4(pt1:x(),pt1:y(),pt1:z(),1.0);
  local front_right_bottom = mathfunction.vector4(pt2:x(),pt2:y(),pt2:z(),1.0);
  local front_right_top = mathfunction.vector4(pt3:x(),pt3:y(),pt3:z(),1.0);
  local front_left_top = mathfunction.vector4(pt4:x(),pt4:y(),pt4:z(),1.0);
  local back_left_top = mathfunction.vector4(pt5:x(),pt5:y(),pt5:z(),1.0);
  local back_left_bottom = mathfunction.vector4(pt6:x(),pt6:y(),pt6:z(),1.0);
  local back_right_top = mathfunction.vector4(pt7:x(),pt7:y(),pt7:z(),1.0);
  local back_right_bottom = mathfunction.vector4(pt8:x(),pt8:y(),pt8:z(),1.0);
  
  --front
  local index = self.front_vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  self.front_vertexstream:ChangeVertexDataWithAttributeFast(index,1,front_left_top);
  self.front_vertexstream:ChangeVertexDataWithAttributeFast(index,2,front_left_bottom);
  self.front_vertexstream:ChangeVertexDataWithAttributeFast(index,3,front_right_top);
  self.front_vertexstream:ChangeVertexDataWithAttributeFast(index,4,front_right_bottom);
  self.front_vertexstream:SetReflushInterval(1, 4);
  self.front_node.render:ChangeVertexBuffer(self.front_vertexstream);

  --back
  index = self.back_vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  self.back_vertexstream:ChangeVertexDataWithAttributeFast(index,1,back_right_top);
  self.back_vertexstream:ChangeVertexDataWithAttributeFast(index,2,back_right_bottom);
  self.back_vertexstream:ChangeVertexDataWithAttributeFast(index,3,back_left_top);
  self.back_vertexstream:ChangeVertexDataWithAttributeFast(index,4,back_left_bottom);
  self.back_vertexstream:SetReflushInterval(1, 4);
  self.back_node.render:ChangeVertexBuffer(self.back_vertexstream);

  
  --top
  index = self.top_vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  self.top_vertexstream:ChangeVertexDataWithAttributeFast(index,1,back_left_top);
  self.top_vertexstream:ChangeVertexDataWithAttributeFast(index,2,front_left_top);
  self.top_vertexstream:ChangeVertexDataWithAttributeFast(index,3,back_right_top);
  self.top_vertexstream:ChangeVertexDataWithAttributeFast(index,4,front_right_top);
  self.top_vertexstream:SetReflushInterval(1, 4);
  self.top_node.render:ChangeVertexBuffer(self.top_vertexstream);

  
  --bottom
  index = self.bottom_vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  self.bottom_vertexstream:ChangeVertexDataWithAttributeFast(index,1,front_left_bottom);
  self.bottom_vertexstream:ChangeVertexDataWithAttributeFast(index,2,back_left_bottom);
  self.bottom_vertexstream:ChangeVertexDataWithAttributeFast(index,3,front_right_bottom);
  self.bottom_vertexstream:ChangeVertexDataWithAttributeFast(index,4,back_right_bottom);
  self.bottom_vertexstream:SetReflushInterval(1, 4);
  self.bottom_node.render:ChangeVertexBuffer(self.bottom_vertexstream);


  --left
  index = self.left_vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  self.left_vertexstream:ChangeVertexDataWithAttributeFast(index,1,back_left_top);
  self.left_vertexstream:ChangeVertexDataWithAttributeFast(index,2,back_left_bottom);
  self.left_vertexstream:ChangeVertexDataWithAttributeFast(index,3,front_left_top);
  self.left_vertexstream:ChangeVertexDataWithAttributeFast(index,4,front_left_bottom);
  self.left_vertexstream:SetReflushInterval(1, 4);
  self.left_node.render:ChangeVertexBuffer(self.left_vertexstream);


  
  --right
  index = self.right_vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  self.right_vertexstream:ChangeVertexDataWithAttributeFast(index,1,front_right_top);
  self.right_vertexstream:ChangeVertexDataWithAttributeFast(index,2,front_right_bottom);
  self.right_vertexstream:ChangeVertexDataWithAttributeFast(index,3,back_right_top);
  self.right_vertexstream:ChangeVertexDataWithAttributeFast(index,4,back_right_bottom);
  self.right_vertexstream:SetReflushInterval(1, 4);
  self.right_node.render:ChangeVertexBuffer(self.right_vertexstream);


end



return HairBoxRender;