--require "venusdebug"
local sticker2ddefine = require "facecute.facesticker2d.sticker2ddefine"
--local posture = require "facecute.estimates.headposture";
local posture = require "facecute.estimates.transposture";
--local posture = require "facecute.estimates.pnpposture";
local apollonode = require "apolloutility.apollonode"
local headtarget =  require "facecute.headtarget";
local immortal =  require "facecute.immortal";
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local defined = require "facecute.defined"
local videodecet = require "videodecet"
local venusjson = require "venusjson"
local bitop = require "bit"
local cutebehavior = require "facecute.behavior.cutebehavior"
local facedefined = require "facecute.facechange.facedefined"
local faceinfo = require "videodecet.faceinfo"
local cnnseg= require "videodecet.cnnseg"
local transition = require "facecute.transitions.transition"

local likeapp = require "likeapp"
local videodefined = require "videodecet.defined"
local transitiondefine = require "facecute.transitions.transitiondefine"
local faceseg = require "videodecet.faceseg"
local hairtarget = require "facecute.haircolor.hairrendertarget"
local renderqueue = require "apolloutility.renderqueue"
--入口文件，解析配置表，调用和组装变形、3d、2d等功能
local facecute = {}


--初始化系统，传递主摄像机
function facecute:Initialize(maincamera)
  
  
  self.maincamera = maincamera;
  --初始化人头姿态估计
  posture:Initialize(maincamera);
  --创建常驻资源
  self.immortal = immortal(self.maincamera);
  self.immortal.groupID = nil
  --人头目标数组
  self.headtargets = {}
  --每个状态机都管理一个人头与常驻资源
  self.transitionlist = {}
  for i = 1, defined.max_head_target_count do
    local ht = headtarget(self.maincamera);
    ht.headIndex = i;
    ht.groupID = i - 1
    table.insert(self.headtargets, ht);
    --创建状态机
    local ts = transition(ht,self.immortal);
    table.insert(self.transitionlist,ts);
  end
  self.maxHeadCount = defined.max_head_target_count
  cutebehavior:Initialize();
  hairtarget:Initialize(maincamera);
  faceseg:RegisterAllSeg();
  self.headtargetInfo = {
    {rect = nil,keypoint = nil},
    {rect = nil,keypoint = nil},
    {rect = nil,keypoint = nil}
  };
  self.idxlut = {nil,nil,nil};--根据action中的rect重排idxlut
end

function facecute:OnResizeView(w,h)
  posture:OnResizeView(w,h)
  --[[if(cnnseg)
  then
   cnnseg:OnResizeView(w,h);
  end]]
  faceseg:OnResizeView(w,h);
end


--加载配置表生成数据
function facecute:_LoadVersion_1(rootconfig, paramters)
  local deforamtionfile = rootconfig["deformationFileName"];
   local deformationconfig = nil;
  if(deforamtionfile~=nil)
  then
     deformationconfig= venusjson.LaodJsonFile(paramters[1].."/"..deforamtionfile);
  end
  for i = 1, self.maxHeadCount do
    local ht = self.headtargets[i]
    ht:ParseConfig(rootconfig, paramters);
    if deformationconfig ~= nil then
      ht:ParseConfig(deformationconfig, paramters);
    end
  end
end

function facecute:_LoadVersion_3(rootconfig, paramters)
  local deforamtionfile = rootconfig["deformationFileName"];
  local deformationconfig = venusjson.LaodJsonFile(paramters[1].."/"..deforamtionfile);
  local tdconfig = rootconfig["parts3d"];
  for i = 1, self.maxHeadCount do
    local ht = self.headtargets[i]
    ht:ParseConfig(rootconfig, paramters);
    ht:ParseConfig(deformationconfig, paramters);
  end
end

--分割配置表
function facecute:_SplitConfig(rootconfig)  
  local fbconfig = {};
  if nil ~= rootconfig.parts then
    for key, value in pairs(rootconfig.parts) do
      if value.positionType == sticker2ddefine.positionType.ForeGround
        or value.positionType == sticker2ddefine.positionType.Background then
          fbconfig.parts = fbconfig.parts or {};
          fbconfig.parts[key] = value;
          rootconfig.parts[key] = nil;
      end        
    end  
  end  
  if nil ~= rootconfig.soundParts then
    for key, value in pairs(rootconfig.soundParts) do
      if value.triggerType == 0 then
        fbconfig.soundParts = fbconfig.soundParts or {};        
        fbconfig.soundParts[key] = value;
        rootconfig.soundParts[key] = nil;
      end      
    end    
  end  
  fbconfig.compress_root = rootconfig.compress_root;
  fbconfig.version = rootconfig.version;
  fbconfig.stickerType = rootconfig.stickerType;
  return rootconfig, fbconfig
end

--处理trigger，得出当前动作，遇到需要背景分割的，将分割位置去掉
function facecute:_ProcesssActions(rootconfig)  
  local actions = {}
  if(videodecet.SetCnnSegMark)
  then
    videodecet:SetCnnSegMark(false);
  end
  faceseg:SetSegMark(videodefined.faceSegType.CNNSEG_FULL,false);  
  faceseg:SetSegMark(videodefined.faceSegType.CNNSEG_FULL_HAIR,false);
  if(likeapp.AI.ActiveCnnseg)
  then
    likeapp.AI:ActiveCnnseg(false);
  end

  local function _ite(config)
    for key, value in pairs(config) do
      if type(value) == "table" then
        _ite(value);
      elseif key == "triggerType" and value ~= 0 then
        if bitop.band( value, defined.background_segment_flag ) ~= 0 then
          value = value - defined.background_segment_flag;
          config[key] = value;
          if(videodecet.SetCnnSegMark)
          then
              videodecet:SetCnnSegMark(true);
          end
          faceseg:SetSegMark(videodefined.faceSegType.CNNSEG_FULL,true);
          if(likeapp.AI.ActiveCnnseg)
          then
            likeapp.AI:ActiveCnnseg(true);
          end
        end        
        actions[value] = true;
      end      
    end    
  end

  local function _ite_version3(config)
    if config.version == "3.0" and config.transitions then 
      for name , defconfig in pairs(config.transitions) do
        --解析conditions得到触发事件
        if next(defconfig["conditions"]) ~= nil then 
          for _,v in pairs(defconfig["conditions"]) do
            if v["triggers"] ~= nil then 
              local event=v["triggers"]
              local value = transitiondefine.triggerTypeList[event];
              if value ~= nil then actions[value] = true end
            end
          end
        end
      end
    end
  end

  if(rootconfig.version=="3.0")
  then
    self.version = 3;
  else
    self.version = tonumber(rootconfig.version);
  end
  _ite(rootconfig);
  _ite_version3(rootconfig);
  self.activeactions = actions;
  local actionarray = {}
  for key,_ in pairs(actions) do
    table.insert(actionarray, key)
  end
  videodecet:ActiveActions(actionarray);
end



local function stripextension(filename)
	local idx = filename:match(".+()%.%w+$")
	if(idx) then
		return filename:sub(1, idx-1)
	else
		return filename
	end
end



function facecute:LoadConfig(path)

  local res = true;

  local pathDir, configName = string.match(path, "(.+)[:/]([^/]*)%.%w+$");

  local rootconfig = venusjson.LaodJsonFile(path);

  self:_ProcesssActions(rootconfig);

  local rootconfig, fbconfig = self:_SplitConfig(rootconfig);

  local paramters = {
    pathDir,
    tonumber(rootconfig["version"])
  };

  local maxHeadCount = rootconfig["maxHeadCount"]
  if maxHeadCount ~= nil then
    self.maxHeadCount = math.min(maxHeadCount, self.maxHeadCount);
  end

  if rootconfig.deformationFileName then
    local defpath = pathDir..'/'..rootconfig.deformationFileName;
    local deformationconfig = venusjson.LaodJsonFile(defpath);
	deformationconfig["version"] = fbconfig["version"];
    for i = 1, self.maxHeadCount do
      local ht = self.headtargets[i]
      res = res and ht:ParseConfig(deformationconfig, paramters);
    end
  end
  
  res = res and self.immortal:ParseConfig(fbconfig, paramters);

  if fbconfig["version"] ~= "3.0" then 
    self.immortal:SetShow(true);
  end
  
  if rootconfig.parts3d and rootconfig.parts3d.metaScenePath then
    local metaScenePath = pathDir..'/'..rootconfig.parts3d.metaScenePath..'/'..configName..".metascene";
    local metaSceneConfig = venusjson.LaodJsonFile(metaScenePath);
    paramters["metascene"] = metaSceneConfig;
  end

  for i = 1, self.maxHeadCount do
    local ht = self.headtargets[i]
    res = res and ht:ParseConfig(rootconfig, paramters);
  end
  
  if rootconfig.soundParts then
  end

  if rootconfig.transitions then
    for _,ts in ipairs(self.transitionlist) do
      ts:ParseConfig(rootconfig);
    end
  end

  renderqueue:UpdateObjQueue()

  return res;
end

function facecute:GetNilFaceInfo()
  
    if(self.nilface)
    then
      return self.nilface;
    end
    local fo = faceinfo(facedefined.cavasSize);
    local faceTex = facedefined.faceTexPoints;
    local len =facedefined.facePointCount;
    local nilkeyPoints={};
    for i=1,len do
       table.insert( nilkeyPoints,{faceTex[2*i-1]/facedefined.cavasSize[1]-10,faceTex[2*i]/facedefined.cavasSize[2]-10});
      --table.insert( nilkeyPoints,{0,0});
    end
    fo:PushRotation(0,0,0,0);
    fo.rect={0,0,0,0};
    fo:UpdateKeypoints(nilkeyPoints);
    self.nilface = fo
    return fo;
    
end
function facecute:ReleaseResource()
  self.immortal:ReleaseResource();
  hairtarget:Clear();
  for _, ht in ipairs(self.headtargets) do
    ht:ReleaseResource();
  end
  self.maxHeadCount = defined.max_head_target_count
end

function facecute:_ActiveActionCount(actions)
  local count = 0;
  for _, pepole in ipairs(actions) do
    for _, action in ipairs(pepole) do
      local id = action:GetActionID();
      if self.activeactions[id] then
        count = count + 1;
        break;
      end      
    end    
  end  
  return count;
end

local emptyaction = {}
local defpos = mathfunction.vector3(0,0,-0.5);
local defrot = mathfunction.Quaternion();
local definfpos = mathfunction.vector3(-10000,-10000,-10000);


function facecute:Update3(timespan, maincamera)

  local faces = videodecet:GetFaces();

  local actions = videodecet:GetActions();--返回当前识别出来的动作

  if faces then

    posture:Update(faces,maincamera);

    local postures = posture:GetPostures();
    local actioncount = self:_ActiveActionCount(actions);
    local showcount = math.max(#postures, actioncount);

    showcount = math.min(showcount, self.maxHeadCount)
   
    hairtarget:SetShow(showcount ~= 0);

    --预处理识别出来的动作，将第一个人动作列表中动作码>=2^9的动作拷贝至全部人头中
    --动作码>=2^9即为手部动作，默认全部触发。
    if actions[1] then 
      for i = 1, #actions[1] do
        if actions[1][i].actionid >= 2^9 then
          for j = 2, showcount do
            if actions[j] ~= nil then
              table.insert(actions[j], actions[1][i])
            end
          end
        end
      end
    end


    --将识别的动作输出，格式为：{}{}{}，分别是第一个人，第二个人，第三个人
    --[[
    local actionlist_tmp = "";
    for i = 1,showcount do
      local actionlistsinglehead = ""
      if actions[i] then
        actionlistsinglehead = actionlistsinglehead .."{"
        for j = 1,#actions[i] do
          actionlistsinglehead = actionlistsinglehead .. actions[i][j].actionid .. " "
        end
        actionlistsinglehead = actionlistsinglehead .."}"
      end
      actionlist_tmp = actionlist_tmp..actionlistsinglehead
    end
    if #actionlist_tmp > 3 then
      print(actionlist_tmp)
      LOG(actionlist_tmp)
    end
    ]]--
    
    --将识别的人脸中心位置输出(二维空间，仅X的值)
    --local positioninfo = "***ht position:  "
    --if postures[2] then
    --  positioninfo = positioninfo .. videodecet.faces[1].Keypoint[47][1] .. videodecet.faces[2].Keypoint[47][1]
    --  LOG(positioninfo)
    --elseif postures[1] then
    --  positioninfo = positioninfo .. videodecet.faces[1].Keypoint[47][1]
    --  LOG(positioninfo)
    --end
    

    --将识别出的action.rect以及keypoint[47]输出（屏幕空间）
    --local rect_info = ""
    --local Keypoint47 = ""
    --for i = 1,showcount do
    --  if actions[i] and actions[i][1] then
    --    rect_info = rect_info .." ".. actions[i][1].rect[1] .." ".. actions[i][1].rect[2] .." ".. actions[i][1].rect[3] .." ".. actions[i][1].rect[4]
    --    Keypoint47 = Keypoint47 .." ".. videodecet.faces[i].Keypoint[47][1] .." ".. videodecet.faces[i].Keypoint[47][2]
    --    print(actions[i][1].rect[1],actions[i][1].rect[2],actions[i][1].rect[3],actions[i][1].rect[4])
    --    print(videodecet.faces[i].Keypoint[47][1],videodecet.faces[i].Keypoint[47][2])
    --  end
    --end
    --print(rect_info,Keypoint47)

    --将keypoint[47]与action.rect相互匹配，使用headtargetInfo记录前一帧中人脸中心的位置
    --根据当前帧中人脸的位置重排序当前帧中人脸的idx，然后更新headtargetInfo
    local headtargetInfo_tmp = { 
      {nil}, --人头的方框（由两个关键点组成，左上角和右下角keypoint[1],keypoint[25]），人头的中心点。
      {nil},
      {nil}
    }

    self.idxlut = {nil,nil,nil};
    
    -- 更新self.idxlut，仅更新能在储存人头信息中能找到的人头
    for i = 1, showcount do --第i个识别的人头
      local idx_tmp = -1

      if faces[i] == nil then
        break
      end

      for j = 1,showcount do -- 第j个储存的人头
        --GetTheNearest self.headtargetInfo[j] with videodecet.faces[i].Keypoint
        --if ( xxx ) then idx_tmp = j end --第i个识别的人头距离第j个储存的人头最近
        --并且第i个识别的人头在第j个储存的人头方框里面。
        if self.headtargetInfo[j] ~= nil and self.headtargetInfo[j].rect then --第j个储存的人头不为空
          local rect = self.headtargetInfo[j].rect
          local point = faces[i].Keypoint[47]
          if PointInRect(rect[1],rect[4],rect[3],rect[2],point[1],point[2]) then --若第i个识别的人头在第j个储存的人头方框里面
            idx_tmp = j
            break
          end
        end
      end

      if idx_tmp ~= -1 then --若在实际储存的人头信息中可以找到识别的人头信息，更新储存的副本信息
        self.idxlut[i] = idx_tmp;--第i个识别出来的人头，对应第idx_tmp个储存的人头
        --更新实际储存的人头信息副本，包括关键点与人脸矩形
        headtargetInfo_tmp[idx_tmp].Keypoint = faces[i].Keypoint[47]
        local face_point_tmp = faces[i].Keypoint
        headtargetInfo_tmp[idx_tmp].rect =  {
          face_point_tmp[1][1],
          face_point_tmp[1][2],
          face_point_tmp[25][1],
          face_point_tmp[25][2]
        };
        --将实际储存的人头信息副本更新完成之后复制到实际储存的人头信息中：
      end
    end

    -- 更新self.idxlut.仅更新不能在储存人头信息中能找到的人头
    for i = 1, showcount do --第i个识别的人头
      local idx_tmp = -1

      if faces[i] == nil then
        break
      end

      for j = 1, showcount do -- 第j个储存的人头
        --GetTheNearest self.headtargetInfo[j] with videodecet.faces[i].Keypoint
        --if ( xxx ) then idx_tmp = j end --第i个识别的人头距离第j个储存的人头最近
        --并且第i个识别的人头在第j个储存的人头方框里面。
        if self.headtargetInfo[j] ~= nil and self.headtargetInfo[j].rect then --第j个储存的人头不为空
          local rect = self.headtargetInfo[j].rect
          local point = faces[i].Keypoint[47]
          if PointInRect(rect[1],rect[4],rect[3],rect[2],point[1],point[2]) then --若第i个识别的人头在第j个储存的人头方框里面
            idx_tmp = j
            break
          end
        end
      end
  
      if idx_tmp == -1 then --若在实际储存的人头信息中没有找到识别的人头信息，说明识别的人头信息是新加入的，需要将识别的人头信息加入到实际储存的人头信息副本中
        for i_1 = 1, #headtargetInfo_tmp do
          if next(headtargetInfo_tmp[i_1]) == nil then
            idx_tmp = i_1
            break
          end
          --在headtargetInfo_tmp中得到第一个为空的人头的id
        end
        self.idxlut[i] = idx_tmp;--第i个识别出来的人头，对应第idx_tmp个储存的人头
        --更新实际储存的人头信息副本，包括关键点与人脸矩形
        headtargetInfo_tmp[idx_tmp].Keypoint = faces[i].Keypoint[47]
        local face_point_tmp = faces[i].Keypoint
        headtargetInfo_tmp[idx_tmp].rect = {
          face_point_tmp[1][1],
          face_point_tmp[1][2],
          face_point_tmp[25][1],
          face_point_tmp[25][2]
        };
        --将实际储存的人头信息副本更新完成之后复制到实际储存的人头信息中：
      end
      
    end

    self.headtargetInfo = headtargetInfo_tmp --能够赋值为临时变量吗？

    
    --print(self.idxlut[1],self.idxlut[2],self.idxlut[3])
    

    --[[
    --更新self.idxlut
    for i = 1,showcount do --第i个人头
      for j = 1,showcount do --第j个动作表
        if actions[j] and actions[j][1] then 
          local rect = actions[j][1].rect
          local point = videodecet.faces[i].Keypoint[47]
          if PointInRect(rect[1],rect[4],rect[2],rect[3],point[1],point[2]) then 
            self.idxlut[j] = i
          end
        end
      end
    end
    --print(self.idxlut[1],self.idxlut[2],self.idxlut[3])
    ]]--

    
    
    --判断关键点(px,py)是否在框内
    --          (x1,y1) ---(x2,y1)
    --                  | |
    --          (x1,y2) ---(x2,y2)
    function PointInRect(x1,y1,x2,y2,px,py)
      local isPointIn = GetCorssPoint(x1,y1,x2,y1,px,py)*GetCorssPoint(x2,y2,x1,y2,px,py) >=0 and GetCorssPoint(x1,y2,x1,y1,px,py)*GetCorssPoint(x2,y1,x2,y2,px,py) >=0
      return isPointIn
    end

    --return  |p1 p2| X |p1 p|
    function GetCorssPoint(p1x,p1y,p2x,p2y,px,py)
      return (p2x - p1x) * (py - p1y) - (px - p1x) * (p2y - p1y)
    end
    
    for i = 1, showcount do
      local hn = self.headtargets[i]
      local ts = self.transitionlist[i]
      hn:SetShow(true);
      ts:SetShow(true);
    end
    for i = showcount + 1, #self.headtargets do
      local hn = self.headtargets[i]
      local ts = self.transitionlist[i]
      hn:SetShow(false);
      ts:SetShow(false);
    end
    --再修改需要的
    --若没有人头
    if 0 == #postures then
      --更新公共资源
      local nilface = self:GetNilFaceInfo();
      self.immortal:Update(timespan, nilface, nil, nil, actions[1] or emptyaction);
      for i = 1, showcount do
        --更新人头资源
        local hn = self.headtargets[i];
        local ts = self.transitionlist[i];
        if hn then
          hn:Update(timespan, nilface, definfpos, defrot, actions[i]);
        end
        if ts then
          ts:Update(actions[i], i);
        end
      end
    else--若有人头
      for index, est in ipairs(postures) do
        if 1 == index then
          --按照第一个人的数据更新公共资源
          self.immortal:Update(timespan, faces[index], est.position, est.rotation, actions[index]);
        end 
        --更新人头资源以及状态机
        local hn = self.headtargets[self.idxlut[index]];
        local ts = self.transitionlist[self.idxlut[index]];

        if hn then
          hn:SetShow(true);
          hn:Update(timespan, faces[index], est.position, est.rotation, actions[index]);
        end

        if ts then 
          ts:SetShow(true)
          ts:Update(actions[index],index);
        end
      end
      
    end  
    
  end

end

function facecute:Update1(timespan,maincamera)
  local faces = videodecet:GetFaces();
  local actions = videodecet:GetActions();--返回当前识别出来的动作
  if faces then
    posture:Update(faces,maincamera);
    local postures = posture:GetPostures();
    local actioncount = self:_ActiveActionCount(actions);
    local showcount = math.max(#postures, actioncount);
   --hairtarget:SetShow(showcount ~= 0);
    
    --先隐藏不要的
    for i = showcount + 1, #self.headtargets do
      local hn = self.headtargets[i]
      hn:SetShow(false);
    end
    
    --再修改需要的
    if 0 == #postures then
      --如果没有人头我们就默认更新
      local nilface = self:GetNilFaceInfo();
      self.immortal:Update(timespan, nilface, nil,nil, actions[1] or emptyaction);
      for i = 1, showcount do
        local hn = self.headtargets[i];
        if hn then
          hn:SetShow(true);
          hn:Update(timespan, nilface, definfpos, defrot, actions[i]);
        end        
      end
    else
      for index, est in ipairs(postures) do
        if index <= showcount then
          if 1 == index then
            --如果有人头我们就按照第一个人的数据更新
            self.immortal:Update(timespan, faces[index], est.position, est.rotation, actions[index]);
          end
          local hn = self.headtargets[index];
          if hn then
            hn:SetShow(true);
            hn:Update(timespan, faces[index], est.position, est.rotation, actions[index]);
          end
        end
      end
    end
  end
  for i = 1, self.maxHeadCount do
    local ht = self.headtargets[i]
    ht:FixUpdate();
  end
end

function facecute:Update(timespan,maincamera)
  if( self.version==3)
  then
    self:Update3(timespan,maincamera);
  else
    self:Update1(timespan,maincamera);
  end
end

return facecute;
