local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local defined = require "facecute.defined"
local videodecet = require "videodecet"
local facedefined = require "facecute.facechange.facedefined"
local trianglenode = require "facecute.facechange.trianglenode"
local renderqueue = require "apolloutility.renderqueue"
local b3 = require "behavior3"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
local cutebehavior = require "facecute.behavior.cutebehavior"
local asynctexture = require "apolloutility.asynctexture.asynctexture"
local behdefined = require "facecute.behavior.behdefined"
local rendernode = require "apolloutility.apollonode.rendernode"
--facecoverpri类型
local facecovernew = rendernode:extend();

function facecovernew:new(maincamera)
  self.maincamera = maincamera;
  facecovernew.super.new(self);  
  facecovernew.super.SetShow(self, false);
  self.mOriginalFaceCoords = {}
  self.mDetailFaceCoords = {}
  self.ptAddZ = {};
  self.ptAddOrgZ = {};
  self.facePtAddPrj = {};
  self.facePtAddPrjOrg = {};
  self.ptZ = {};
  
  self.vertexstream = apolloengine.VertexStream();--创建顶点流
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  apolloengine.ShaderEntity.ATTRIBUTE_FACECOORDNATESTD =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.ATTRIBUTE,
      "ATTRIBUTE_FACECOORDNATESTD");
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_FACECOORDNATESTD,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);

  self.isMakeup = isMakeup;
  self.vertexstream:ReserveBuffer(240);--预先分配triIndexCount个索引  
  self.indicesstream = apolloengine.IndicesStream();--创建索引流 
  self.indicesstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  self.indicesstream:ReserveBuffer(table.getn(facedefined.faceTriangles2));
    
  self:InitIndexStream2();
  self:InitVertexStream2();
end


local function ModelLengthToWorldLength(le)
  --local val = 58*le/206.5/1000.0;
  --local val = 0.00028087167070217917*le;
  local val =facedefined.ModelToWorldVal*le;
  return val;
end

function facecovernew:InitIndexStream2()
  local faceTris = facedefined.faceTriangles2;
  local faceTrisLen = #faceTris/3;
  for j=1, faceTrisLen do
     self.indicesstream:PushIndicesData(faceTris[3*j-2]-1);
     self.indicesstream:PushIndicesData(faceTris[3*j-1]-1);
     self.indicesstream:PushIndicesData(faceTris[3*j]-1);
  end
end

function facecovernew:InitVertexStream2()
  local faceCenter = facedefined.faceCenter;
  local ptAdd = facedefined.facePtAddDetailXY;
  local ptAddZ = facedefined.facePtAddDetailZ;
  self.facePtAdd ={};
  self.facePtAddZ={};
  self.facePt={};
  local le = table.getn(ptAdd);
  for i=1,le/2 do
      self.facePtAdd[2*i-1]=ModelLengthToWorldLength(ptAdd[2*i-1]);
      self.facePtAdd[2*i]=ModelLengthToWorldLength(ptAdd[2*i]);
      self.facePtAddZ[i]=ptAddZ[i];
  end
  
  local facePt={};
  le = table.getn(facedefined.faceTexPointsExt2)/2;
  for i =0,le-1 do
    facePt[2*i] = facedefined.faceTexPointsExt2[2*(i+1)-1]+facedefined.faceTexPointsOffset[1];
    facePt[2*i+1] = facedefined.faceTexPointsExt2[2*(i+1)]+facedefined.faceTexPointsOffset[2];
  end
  
  self.faceTexPri={};
  local faceTexPri = self.faceTexPri;
  local faceptlen = (#facePt+1)/2;
  for i=1,faceptlen do
    faceTexPri[2*i-1] = facePt[2*(i-1)]/facedefined.cavasSize[1];
    faceTexPri[2*i] =  facePt[2*(i-1)+1]/facedefined.cavasSize[2];
  end
  
  local le2 = #ptAdd/2;
  for i=1+faceptlen, faceptlen+le2 do
    faceTexPri[2*i-1] = (ptAdd[2*(i-faceptlen)-1]+faceCenter[1])/facedefined.cavasSize[1];
    faceTexPri[2*i]= (-ptAdd[2*(i-faceptlen)]+faceCenter[2])/facedefined.cavasSize[2];
  end
  
  local facetexstd = faceTexPri;
  local texstdlen = #facetexstd/2;
  for i =1,texstdlen do
    self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_FACECOORDNATESTD,
      mathfunction.vector2(facetexstd[2*i-1],facetexstd[2*i]));
    
    self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      mathfunction.vector4(0,0,0,1)
      );
  end
  
end

function facecovernew:ParseConfig(config,pripara)
  self:SetLocalPosition(mathfunction.vector3(0,0,0.00));
  return true;
end




function facecovernew:GetFaceCoods2()
  return  self.mDetailFaceCoords,self.ptZ;
end

function facecovernew:GetAddedFaceCoods(isFullFace)
  if(isFullFace)
  then
      return   self.facePtAddPrj,self.ptAddZ;
  else
      return   self.facePtAddPrjOrg,self.ptAddOrgZ;
  end
end

function facecovernew:_CaculatePrj()
  local xS = 1.1;
  local yS = 1.1;
  local vp = self.maincamera:GetViewProj();
  local m = self:GetWorldTransform();
  local facePtAddPrj = self.facePtAddPrj;
  local facePtAddPrjOrg = self.facePtAddPrjOrg;
  local facePtAdd = self.facePtAdd;
  local facePtAddZ =self.facePtAddZ;
  local vec4 = mathfunction.vector4();
  local mvp = m*vp;
  local le=table.getn(self.facePtAdd)/2;
  local ptAddZ= self.ptAddZ;
  local ptAddOrgZ=self.ptAddOrgZ;
  
  local vec4Set = vec4.Set;
  local fx = mathfunction.vector4.x;
  local fy = mathfunction.vector4.y;
  local fz = mathfunction.vector4.z;
  local fw = mathfunction.vector4.w;
  
  if( self.isFullFace) then
    for i=1,le do
      --vec4:Set(facePtAdd[2*i-1]*xS,facePtAdd[2*i]*yS,facePtAddZ[i],1);
        vec4Set(vec4,facePtAdd[2*i-1]*xS,facePtAdd[2*i]*yS,facePtAddZ[i],1);
        local ptPrj = vec4 * mvp;
        local invw = 1 / fw(ptPrj);
        facePtAddPrj[2*i-1]= fx(ptPrj) * invw;
        facePtAddPrj[2*i]= fy(ptPrj) * invw;
        ptAddZ[i]= fz(ptPrj) * invw;
    end
  end
  
      --vec4:Set(facePtAdd[2*i-1],facePtAdd[2*i],facePtAddZ[i],1);
  if(self.isNotFullFace) then
    for i=1,le do
      vec4Set(vec4,facePtAdd[2*i-1],facePtAdd[2*i],facePtAddZ[i],1);
      local ptPrj = vec4 * mvp;
      local invw = 1 / fw(ptPrj);
      facePtAddPrjOrg[2*i-1]= fx(ptPrj) * invw;
      facePtAddPrjOrg[2*i]= fy(ptPrj) * invw;
      ptAddOrgZ[i]= fz(ptPrj) * invw;
    end
  end
  
  
  local ptZ= self.ptZ;
  if(self.isNeedZDepth) then
    le = #self.facePt/2;
    for i=1,le do
      --vec4:Set(self.facePt[2*i-1],self.facePt[2*i],0,1);
      vec4Set(vec4,self.facePt[2*i-1],self.facePt[2*i],0,1);
      local ptPrj = vec4 * mvp;
      ptZ[i]= fz(ptPrj) / fw(ptPrj);
    end
  end
  
end

function facecovernew:_CaculateCoords2()
  local face = self.face;
  local facePtCount = facedefined.facePointCount;
  local Detailpoints = face:GetDetailpointArray();
  local Keypoints = face:GetKeypointArray();
  
  local mDetailFaceCoords = self.mDetailFaceCoords;
  local mOriginalFaceCoords = self.mOriginalFaceCoords;
  for i=0,facePtCount-1 do
      local points = Keypoints[i+1];
      mOriginalFaceCoords[i * 2] =  points[1];--2 *  points[2*(i+1)-1] / vec2[1] - 1;
      mOriginalFaceCoords[i * 2 +1] = points[2];--2 * points[2*(i+1)] / vec2[2] - 1;
  end
  
  for i=0,facedefined.faceDetailPointCount-1 do
    local points = Detailpoints[i+1];
    mDetailFaceCoords[i * 2] =  points[1];--2 *  points[2*(i+1)-1] / vec2[1] - 1;
    mDetailFaceCoords[i * 2 +1] = points[2];--2 * points[2*(i+1)] / vec2[2] - 1;
  end
  facePtCount = facedefined.faceDetailPointCount;
  
  --放大眼睛
  local add = 0.004;
  for i=0,21 do
    local dis = math.sqrt((mOriginalFaceCoords[104 * 2 + 0]-mDetailFaceCoords[(i+48)*2+0])*(mOriginalFaceCoords[104 * 2 + 0]-mDetailFaceCoords[(i+48)*2+0])+(      mOriginalFaceCoords[104 * 2 + 1]-mDetailFaceCoords[(i+48)*2+1])*(mOriginalFaceCoords[104 * 2 + 1]-mDetailFaceCoords[(i+48)*2+1]));
    mDetailFaceCoords[(facePtCount+i)*2+0] = mOriginalFaceCoords[104 * 2 + 0]-(mOriginalFaceCoords[104 * 2 + 0]- mDetailFaceCoords[(i+48)*2+0])/(dis/(dis+add));
    mDetailFaceCoords[(facePtCount+i)*2+1] = mOriginalFaceCoords[104 * 2 + 1]-(mOriginalFaceCoords[104 * 2 + 1]- mDetailFaceCoords[(i+48)*2+1])/(dis/(dis+add));
  end
  for i=22,43 do
    local dis = math.sqrt((mOriginalFaceCoords[105 * 2 + 0]-mDetailFaceCoords[(i+48)*2+0])*(mOriginalFaceCoords[105 * 2 + 0]-mDetailFaceCoords[(i+48)*2+0])+(mOriginalFaceCoords[105 * 2 + 1]-mDetailFaceCoords[(i+48)*2+1])*(mOriginalFaceCoords[105 * 2 + 1]-mDetailFaceCoords[(i+48)*2+1]));
    mDetailFaceCoords[(facePtCount+i)*2+0] = mOriginalFaceCoords[105 * 2 + 0]-(mOriginalFaceCoords[105 * 2 + 0]- mDetailFaceCoords[(i+48)*2+0])/(dis/(dis+add));
    mDetailFaceCoords[(facePtCount+i)*2+1] = mOriginalFaceCoords[105 * 2 + 1]-(mOriginalFaceCoords[105 * 2 + 1]- mDetailFaceCoords[(i+48)*2+1])/(dis/(dis+add));
  end
  --放大嘴巴
  add = 0.015;
  for i = 118,134,1 do
    local dis = math.sqrt((mDetailFaceCoords[i*2+0]-mDetailFaceCoords[(i+17)*2+0])*(mDetailFaceCoords[i*2+0]-mDetailFaceCoords[(i+17)*2+0])+(mDetailFaceCoords[i*2+1]-mDetailFaceCoords[(i+17)*2+1])*(mDetailFaceCoords[i*2+1]-mDetailFaceCoords[(i+17)*2+1]));
    mDetailFaceCoords[i*2+0] = mDetailFaceCoords[(i+17)*2+0]-(mDetailFaceCoords[(i+17)*2+0]- mDetailFaceCoords[i*2+0])/(dis/(dis+add));
    mDetailFaceCoords[i*2+1] = mDetailFaceCoords[(i+17)*2+1]-(mDetailFaceCoords[(i+17)*2+1]- mDetailFaceCoords[i*2+1])/(dis/(dis+add));
 end
 for i = 167,181,1 do
    local dis = math.sqrt((mDetailFaceCoords[i*2+0]-mDetailFaceCoords[(i-15)*2+0])*(mDetailFaceCoords[i*2+0]-mDetailFaceCoords[(i-15)*2+0])+(mDetailFaceCoords[i*2+1]-mDetailFaceCoords[(i-15)*2+1])*(mDetailFaceCoords[i*2+1]-mDetailFaceCoords[(i-15)*2+1]));
    mDetailFaceCoords[i*2+0] = mDetailFaceCoords[(i-15)*2+0]-(mDetailFaceCoords[(i-15)*2+0]- mDetailFaceCoords[i*2+0])/(dis/(dis+add));
    mDetailFaceCoords[i*2+1] = mDetailFaceCoords[(i-15)*2+1]-(mDetailFaceCoords[(i-15)*2+1]- mDetailFaceCoords[i*2+1])/(dis/(dis+add));
 end 
end


function facecovernew:_ChangeVertex2()
  local OriginalFaceCoords, _ =  self:GetFaceCoods2();  
  self.vertexstream:ChangeVertexDataArray(
    apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    1,
    2,
    OriginalFaceCoords);  
  
  local addFaceCoords, _ =self:GetAddedFaceCoods(self.isFullFace);  
  self.vertexstream:ChangeVertexDataArray(
    apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    227,
    2,
    addFaceCoords);
end

function facecovernew:Process()
  local face = self.face;
  local timespan = self.timespan;
  local faceCenter = facedefined.faceCenter;
  self:_CaculatePrj();
  self:_CaculateCoords2();
  self:_ChangeVertex2();
end


function facecovernew:Update(timespan, face, position, rotation, action)
  self.timespan = timespan;
  self.face = face;
  self.action = action;
  self:Process();
end
return facecovernew;