local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"
local Object = require "classic"
local modelnode3 = require "facecute.3dsticker.modelnode3New"
local modelnodehead = require "facecute.3dsticker.modelnodehead"
local threesticker = require "facecute.3dsticker.threesticker"
local EffectAgent = require "facecute.effectagent"
local metascene = require "facecute.3dsticker.metascene"
local defined = require "facecute.defined"
require "venusdebug"


--管理一组3d模型
local threesticker3 = threesticker:extend();

function threesticker3:new()
  threesticker3.super.new(self);
  self.assetsnames = {}
end

 function threesticker3:subString(str, k)
       local ts = string.reverse(str)
       local _, i = string.find(ts, k)
       if i==nil then 
        return nil
       end
       local m = string.len(ts) - i + 2
   
       return string.sub(str, m, string.len(ts))
 end
 

--传入数据表，解析数据
function threesticker3:ParseConfig(config, para)
  --_COROUTINES_ON();
  local res = true;
  --local json = venusjson.LaodJsonFile(config);
  if (config["parts3d"]) then   --模型

    local metaSceneConfig = para["metascene"];

    local parts3DValue = config["parts3d"];
    local modellist = parts3DValue["modelList"];

    local goNameList = {};

    for key, value in pairs(modellist) do
      local fileName = value["fileName"];
      local goName = value["name"];
      goNameList[goName] = fileName;
    end

    local scene = metascene();
    
    res = scene:ParseConfig3(metaSceneConfig, para, goNameList);

    local zpostable = {};

    self.heads = {};

    for key, value in pairs(modellist) do
      local modelName = value["fileName"];
      local goName = value["name"];
      local zpos = value["zPosition"];
      local modelPath = para[1] .. "/" .. modelName;
      local model = modelnode3();

      local submeshTexTable,submeshRefTable = scene:GetSubMeshAndTex(goName);
      model:SetTexturePath(submeshTexTable,submeshRefTable);
      res = res and model:CreateResource(modelPath,"docs:facecute/commaterial/nl_simple_t.material");

      model:SetShow(false);
      model:SetLoop(true);

      if zpos~=nil then
        model:SetRenderOrder(zpos);
        renderqueue:AddObjs(model);
        if zpostable[zpos]==nil then
          zpostable[zpos] = true;
          local head = modelnodehead();
          head:CreateResource(
              defined.headtarget_human_head_mesh,
              defined.headtarget_human_head_material);
          --head:SetRenderOrder(zpos-0.2);
          head:SetRenderOrder(zpos, -0.2);
          renderqueue:AddObjs(head);
          table.insert(self.heads,head);
        end
        
      else
        renderqueue:After(model);
      end
      
      table.insert(self.assets, EffectAgent(model, value["name"]));
      table.insert(self.assetsnames,value["name"]);
    end
  
  end
  return res;
  --_COROUTINES_OFF();
end

function threesticker3:getAsset(name)
  local len = table.getn(self.assetsnames);
  for i=1,len do
    if(name==self.assetsnames[i])
    then
       return self.assets[i];
    end
  end
  return nil;
end

function threesticker3:Update(timespan)
  for _, model in ipairs(self.assets) do
    model:Update(timespan);
  end
end

function threesticker3:SetRootNode(node)
  for _, model in ipairs(self.assets) do
    model:SetRootNode(node)
  end
  for _, model in ipairs(self.heads) do
    node:AttachNode(model)
  end
 
end

return threesticker3;