local modelnodemodel = require "apolloutility.apollonode.modelnode"
local modelnode = require "apolloutility.apollonode.meshnode"
local skeletonnode = require "apolloutility.apollonode.skeletonnode"
local trasnnode = require "apolloutility.apollonode.trasnnode"
local defiend = require "facecute.3dsticker.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"
local Object = require "classic"
local vc = require "venuscore"

local modelnode3Old = modelnodemodel:extend();

local AS_ERROR = apolloengine.SkeletonComponent.AS_ERROR;
local AS_PLAYING = apolloengine.SkeletonComponent.AS_PLAYING;
local AS_DONE = apolloengine.SkeletonComponent.AS_DONE;
local AS_STOP = apolloengine.SkeletonComponent.AS_STOP;


local TextureSlot = 
{
  TS_DIFFUSE = 0,
  TS_NORMAL = 1
};

local MaterialType = 
{
  MT_OPAQUE = 0,
  MT_TRANSPARENT = 1
};


function modelnode3Old:new()
  modelnode3Old.super.new(self)
end

function modelnode3Old:GetRenderOrder()
  local offset = -2000;
  if self.zPos~=nil then
      return self.zPos + offset;
  end
  return offset;
end


function modelnode3Old:SetRenderOrder(zPos)
  local offset = -2000;
  self.zPos = zPos;
  local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,-1, offset + zPos -1),
  mathfunction.vector3(1,1,offset + zPos));
  self:SetBindBox(bindboxV);
  --self:SetCull(false);
  for key,value in pairs(self.nodes) do
    LOG("SET RENDER ORDER:"..key.."TO:"..zPos);
    value:SetBindBox(bindboxV);
    value:SetCull(false);
  end
end

function modelnode3Old:NeedSwap()
  return false;
end

function modelnode3Old:IsRenderProperty(p)
  local ret = false;
  for key,value in pairs(self.nodes) do
    if value:IsRenderProperty(p) then
      return true;
    end
  end

  return false;
end


function modelnode3Old:SetTexturePath(diffuseFullPath,refFullPath)
  self.submeshTexTable = diffuseFullPath;
  self.submeshRefTable = diffuseFullPath;
end
  
function modelnode3Old:CreateResource(rootpath, defmaterial, memoryuseage)
  local res = true;
  memoryuseage = memoryuseage or apolloengine.VertexBufferEntity.MU_STATIC;
  local configFullPath = rootpath .. "/" .. "config.json";
  local modelconfig = venusjson.LaodJsonFile(configFullPath);
  if modelconfig.version==2 then
    return self:CreateResource2(rootpath, defmaterial, memoryuseage);    
  end
  local bind = mathfunction.Aabbox3d();
  for meshesKey, meshesValue in pairs(modelconfig) do
    for meshKey,meshValue in pairs(meshesValue) do
      local meshpath = meshValue.name;
      local submeshname = string.sub(meshpath,8,string.len(meshpath)-5);
      if self.submeshTexTable==nil or self.submeshTexTable[submeshname] ~=nil then
        local meshFullPath = rootpath .. "/" .. meshpath;
        LOG(meshFullPath);
        local diffusetex;
        local normaltex;
        local pbrtex;
        
        local diffuseFullPath;
        if  self.submeshTexTable~=nil and vc.IFileSystem:isFileExist(self.submeshTexTable[submeshname]) then
          diffuseFullPath = self.submeshTexTable[submeshname];
        end
        LOG("old 1")
        local normalFullPath ;
        local pbrtextureFullPath ;
        local materialtype;
        local ispbr = false;
        local material = meshValue.material;
        if material then
          materialtype = material.alphamode;
          if material.normaltexture then
            normaltex = material.normaltexture.path;
          end
          
          if material.pbrmetallicroughness.basecolortexture then
            diffusetex = material.pbrmetallicroughness.basecolortexture.path;
          end  
        end
        
        if diffusetex and diffuseFullPath==nil then
          diffuseFullPath = rootpath .. "/" .. diffusetex;
        end
        if normaltex and normalFullPath==nil then
          normalFullPath = rootpath .. "/" .. normaltex;
        end
        
    
        local materialFullPath = defmaterial or defiend.model_simple_material_path;
        if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
          ispbr = true;
          materialFullPath = defiend.model_pbr_material_path;
          if pbrtextureFullPath==nil then
            pbrtex = material.pbrmetallicroughness.metallicroughnesstexture.path;
            pbrtextureFullPath = rootpath .. "/" .. pbrtex;
          end
        end
        
        local skeletonPath = meshValue.skeleton;
        local maxBone = meshValue.maxbonecnt;
        local animationPath = meshValue.animation;
        local frameCount = meshValue.framecount;
        local isHasScale = meshValue.hasscale;
        
        local transList = meshValue.translation;
        local rotList = meshValue.rotation;
        local scaleList = meshValue.scale;
        
        local bindmin = meshValue.boundingbox.min;
        local bindmax = meshValue.boundingbox.max;
        
        local bindboxV = mathfunction.Aabbox3d(
          mathfunction.vector3(bindmin[1],bindmin[2],bindmin[3]),
          mathfunction.vector3(bindmax[1],bindmax[2],bindmax[3]));
        
        if animationPath then
          
          local suffix = materialtype == MaterialType.MT_TRANSPARENT and "_t" or "";
    
          local materialpath = ispbr
              and (isHasScale and defiend.model_pbr_matrix_material_path or defiend.model_pbr_dual_material_path)
              or (isHasScale and defiend.model_matrix_material_path or defiend.model_dual_material_path) 
          materialFullPath = string.format(materialpath, maxBone,suffix);
          
      
          self.isSkined = true;
          animationPath = rootpath .. "/" .. animationPath;
          skeletonPath = rootpath .. "/" .. skeletonPath;
        end
        
        local modelnode = modelnode();
        if self.keepsource then
          modelnode:SetKeepSource(self.keepsource);
        end
        
        if diffuseFullPath then 
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,diffuseFullPath);
        end 
      
        if normalFullPath then
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_BUMP,normalFullPath);
        end  
        
        if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_AMR,pbrtextureFullPath);
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,normalFullPath);
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_ALDEBO,diffuseFullPath);
        end
      
      
        self.nodes[meshpath] = modelnode;
        res = res and modelnode:CreateResource(meshFullPath,materialFullPath,skeletonPath,animationPath,frameCount, isHasScale and 0 or 1, memoryuseage);
        modelnode:SetBindBox(bindboxV);
        if(maxBone~=nil)  then
          local skinCom = apolloengine.SkinComponent();
          modelnode:AttachComponent(skinCom);
          skinCom:SetHasScale(isHasScale);
          skinCom:SetSkeletonComponent(modelnode.skeleton);  
          table.insert(self.skincoms,skinCom);
        end
        bind:Contains(bindboxV);
        self:AttachNode(modelnode);
      end
    end
  end
  self.bindbox:SetBindBox(bind);
  return res;
end
  
function modelnode3Old:CreateResource2(rootpath, defmaterial, memoryuseage)
  local res = true;
  memoryuseage = memoryuseage or apolloengine.VertexBufferEntity.MU_STATIC;
  local configFullPath = rootpath .. "/" .. "config.json";
  local modelconfig = venusjson.LaodJsonFile(configFullPath);
  if modelconfig.version ~=2 then
    return false; 
  end
  self.version = 2;
  local bind = mathfunction.Aabbox3d();
  
  local hasAnim = false;
  local isHasScale = false;
  
  if modelconfig.skeleton~=nil and modelconfig.skeleton.name~="" and modelconfig.skeleton.animation.name~="" then
    
    local skeletonPath = modelconfig.skeleton.name;
    skeletonPath = rootpath .. "/" .. skeletonPath;
    local animInfos =  modelconfig.skeleton.animation;
    animInfos.name = rootpath .. "/" .. animInfos.name;
   
    local skenode = skeletonnode();
    skenode:SetSkeletonAndAnims(skeletonPath,animInfos );
    self:AttachNode(skenode);
    self.skeletonNode = skenode;
    hasAnim = true;
    isHasScale = animInfos.hasscale;
  end
  
  for meshKey,meshValue in pairs(modelconfig.meshes) do

    local meshpath = meshValue.name;
    local submeshname = string.sub(meshpath,8,string.len(meshpath)-5);
    if self.submeshTexTable==nil or self.submeshTexTable[submeshname] ~=nil then
      local meshFullPath = rootpath .. "/" .. meshpath;
      local diffusetex;
      local normaltex;
      local pbrtex;

      local diffuseFullPath;
      if self.submeshTexTable~=nil and vc.IFileSystem:isFileExist(self.submeshTexTable[submeshname]) then
        diffuseFullPath = self.submeshTexTable[submeshname];
      end
      LOG(diffuseFullPath);
      local normalFullPath ;
      local pbrtextureFullPath ;
      local materialtype;
      local ispbr = false;
      local reflectiontex;
      local reflectionfullPath;
      
      local material = meshValue.material;
      if material then
        materialtype = material.alphamode;
        if material.normaltexture then
          normaltex = material.normaltexture.path;
        end
        
        if material.pbrmetallicroughness.basecolortexture then
          diffusetex = material.pbrmetallicroughness.basecolortexture.path;
        end
    
        if material.reflectiontexture then
          if self.submeshRefTable~=nil and self.submeshRefTable[submeshname]~=nil then
            reflectiontex = self.submeshRefTable[submeshname].tex;
            reflectionfullPath = self.submeshRefTable[submeshname].tex;
          else
            reflectiontex = material.reflectiontexture.path;
          end
        end
      end
      
      if diffusetex and diffuseFullPath==nil  then
        diffuseFullPath = rootpath .. "/" .. diffusetex;
      end
      if normaltex and normalFullPath==nil then
        normalFullPath = rootpath .. "/" .. normaltex;
      end
      if reflectiontex and reflectionfullPath==nil then
          reflectionfullPath = rootpath .. "/" .. reflectiontex; 
      end
    
      local materialFullPath = defmaterial or defiend.model_simple_material_path;
      if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
        ispbr = true;
        materialFullPath = defiend.model_pbr_material_path;
        if pbrtextureFullPath==nil then
          pbrtex = material.pbrmetallicroughness.metallicroughnesstexture.path;
          pbrtextureFullPath = rootpath .. "/" .. pbrtex;
        end
      end
    
      
      local maxBone = meshValue.maxbonecnt;
    
      local transList = meshValue.translation;
      local rotList = meshValue.rotation;
      local scaleList = meshValue.scale;
      
      local bindmin = meshValue.boundingbox.min;
      local bindmax = meshValue.boundingbox.max;
      
      local bindboxV = mathfunction.Aabbox3d(
        mathfunction.vector3(bindmin[1],bindmin[2],bindmin[3]),
        mathfunction.vector3(bindmax[1],bindmax[2],bindmax[3]));
      
      if hasAnim and maxBone~=nil then
        local suffix = materialtype == MaterialType.MT_TRANSPARENT and "_t" or "";
        local materialpath = 
          ispbr
            and (isHasScale and defiend.model_pbr_matrix_material_path or defiend.model_pbr_dual_material_path)
            or (isHasScale and defiend.model_matrix_material_path or defiend.model_dual_material_path)
        materialFullPath = string.format(materialpath, maxBone,suffix);
      
        self.isSkined = true;
      end
    
      local modelnode = modelnode();
      if self.keepsource then
        modelnode:SetKeepSource(self.keepsource);
      end
      
      if diffuseFullPath then 
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,diffuseFullPath);
      end 
    
      if normalFullPath then
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_BUMP,normalFullPath);
      end
    
      local UNIFORM_REFFACTOR 
      if reflectionfullPath then 
         UNIFORM_REFFACTOR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_REFFACTOR");
 
          materialFullPath = defiend.model_reflection_path;
    
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_REFLECTION,reflectionfullPath,apolloengine.TextureEntity.TW_MIRRORED_REPEAT);
      end
      
      if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_AMR,pbrtextureFullPath);
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,normalFullPath);
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_ALDEBO,diffuseFullPath);
      end
    
      self.nodes[meshpath] = modelnode;
      res = res and modelnode:CreateResource(meshFullPath,materialFullPath,nil,nil,nil, nil, memoryuseage);
      if reflectionfullPath then 
        modelnode:SetParameter(UNIFORM_REFFACTOR,mathfunction.vector1(self.submeshRefTable[submeshname].value));
      end
      modelnode:SetBindBox(bindboxV);
      bind:Contains(bindboxV);
    
      if(maxBone~=nil) and self.skeletonNode~=nil then
        local skinCom = apolloengine.SkinComponent();
        modelnode:AttachComponent(skinCom);
        skinCom:SetHasScale(isHasScale);
        skinCom:SetSkeletonComponent(self.skeletonNode.skeleton);
        table.insert(self.skincoms,skinCom);
      end
    
    
      self:AttachNode(modelnode);
    end
  end
  
  self.bindbox:SetBindBox(bind);
  return res;
end
return modelnode3Old