  
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local biugodefined = require "biugo.defined"
local Object = require "classic"
local likeapp = require "likeapp"





local Normalbase = Object:extend();

function Normalbase:new(rows,cols,location,alphamode)

    self.rows = rows;
    self.cols = cols;
    self.location = location;
    self.alphamode = alphamode;
    self.isShow = nil;
    self.quadnode = apollonode.QuadNode();
    self.quadnode:SetShow(false); --


    apolloengine.ShaderEntity.TEXTURE_LOCATION =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_LOCATION");
    apolloengine.ShaderEntity.TEXTURE_SPLIT_INFO =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_SPLIT_INFO");
    apolloengine.ShaderEntity.TEXTURE_SIZE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "TEXTURE_SIZE");
    


    local baseStrMaterial = self:AssemblyMaterial();
    --拼接材质（因为要指定AlphaMode和渲染队列） 把材质的代码拆分成若干个字符串顺序组合
    self.quadnode:CreateResourceByMaterialBuffer(baseStrMaterial, false);
end

function Normalbase:AssemblyMaterial()
    local alphamode_str = biugodefined.AlphaMode[self.alphamode];
    local shaderpart_str = biugodefined.Shaders["BaseVideo"];
    if alphamode_str == nil then
        alphamode_str = "{ ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA , ONE, ONE }"; --默认混合模式
    end
    
    local material_begin = "";
    if self.location[1] == 0 and self.location[2] == 0 then  --认定【0，0】位置的图片就是基础base视频
        alphamode_str = "{ ALPAH_OFF }";
        material_begin = string.format(biugodefined.base_material_begin, "OPAQUE",alphamode_str);
    else
        material_begin = string.format(biugodefined.base_material_begin,"OPAQUE + 10",alphamode_str);
    end
    local materialsrc = material_begin .. shaderpart_str;
    materialsrc = materialsrc .. biugodefined.material_end;

    --LOG(materialsrc);
    return materialsrc;
end

function Normalbase:SetSequence(s)
    self.quadnode:SetSequence(s);
end

function Normalbase:SetShow(isShow)
  if self.isShow ~= isShow then
    self.isShow = isShow;
    self.quadnode:SetShow(isShow);
  end
end

function Normalbase:Update()
    local diffuse_texture = videodecet:GetVideoTexture();
    local tex_size = diffuse_texture:GetSize();
    local textureLoc = mathfunction.vector2(self.location[1],self.location[2]);
    local textureSplitInfo = mathfunction.vector2(self.rows,self.cols);
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_LOCATION,textureLoc);
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_SPLIT_INFO,textureSplitInfo);
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_SIZE,mathfunction.vector2(tex_size:x(),tex_size:y()));
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,diffuse_texture); 
    self:SetShow(true);  --始终显示
end



return Normalbase;
