  

local Object = require "classic"
local FaceMorph = require "facemorph.facemorph"




local MorphBase = Object:extend();

function MorphBase:new(morphInfo,fboSize)
  self.DefaultMorphTime = morphInfo.DefaultMorphTime;
  self.DefaultShowTime = morphInfo.DefaultShowTime;
  
  FaceMorph:InitRenderer(self.DefaultMorphTime,self.DefaultShowTime);
  FaceMorph:SetFboSize(fboSize);
  self.MorphTex = nil;
end

function MorphBase:LoadTemplate(template)
  return FaceMorph:_LoadTemplate(template);
end

function MorphBase:SetFboSize(size)
  FaceMorph:SetFboSize(size);
end

function MorphBase:SetMorphTextureInfos(tslist, landmarklist)
  FaceMorph:SetMorphTextureInfos(tslist, landmarklist);
end

function MorphBase:DoMorph(indiceslist, showtimelist, transtimelist)
  return FaceMorph:DoMorph(indiceslist, showtimelist, transtimelist);
end

function MorphBase:Update(def)
  FaceMorph:Update(def);
end

function MorphBase:GetMorphResult()
  if self.MorphTex == nil then
    self.MorphTex = FaceMorph:GetMorphTex();
  end
  
 
  return self.MorphTex;
end



return MorphBase;
