
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local MaskSequenceBase = require "biugo.mask_sequence_base"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local biugodefined = require "biugo.defined"
local likeapp = require "likeapp"
local Object = require "classic"
local CustomeTextureManager = require "biugo.customtexturemanager"
local errno = require "errno"


local MaskSequence = MaskSequenceBase:extend();


function MaskSequence:new(customID,channel, isText, materialName, alphaMode, splitInfo)
  MaskSequence.super.new(self,customID,channel, isText, materialName, alphaMode, splitInfo);
  self.isNew = true;
end



function MaskSequence:Update(timespan)
  if self.maskID == nil then
    ERROR("Mask id is nil! Maybe the rect file load failed!");
    likeapp.AI:OnErrorReport(errno.SUPERME_MASK_ID_NIL);
    return;
  end
  
  --得到帧号
  local frameIndex = self:GetFrameIndex();
--  LOG("FrameIndex is " .. tostring(frameIndex));
--  frameIndex = 0;
  --得到custom 纹理
  if frameIndex == nil then
    ERROR("The frame index is null");
    likeapp.AI:OnErrorReport(errno.SUPERME_FRAME_IDX_NIL);
    return;
  end
  
  self:GetCustomTexture(self.maskID);
  
  
  --Update
  MaskSequence.super.Update(self,frameIndex + 1);
end

function MaskSequence:GetFrameIndex()
  return likeapp.AI:GetFrameIndex();
end

function MaskSequence:GetCustomTexture(id)
  local custom_texture, custom_texture_size = CustomeTextureManager:GetCustomTexture(self.maskID);
  if custom_texture ~= nil then
    if custom_texture_size == nil then
       ERROR("custom_texture_size is nil");
    end
    self.custom_texture = custom_texture;
    self.custom_texture_size = custom_texture_size;
    self:SetShow(true); --开启绘制
  else
    self:SetShow(false); --关闭绘制
  end
end

--[[
function MaskSequence:GetCustomTexture(id)
  local isCustomTextureChanged = likeapp.AI:IsCustomTextureChanged(id);
  if (self.isNew == true) or (isCustomTextureChanged == true)  then
    local ts = likeapp.AI:GetCustomTexture(id);
    if ts then
      LOG("Cutme change texture, Request id is: " .. tostring(id));
      self.custom_texture = apolloengine.TextureEntity();
      self.custom_texture:PushMetadata(
      apolloengine.TextureBufferMetadata(
          apolloengine.TextureEntity.TU_STATIC,
          1, false,
          apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
          apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
          apolloengine.TextureEntity.TF_LINEAR,
          apolloengine.TextureEntity.TF_LINEAR,
          ts));
      
      self.custom_texture:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
      self.custom_texture:CreateResource();
      self:SetShow(true); --开启绘制
      self.custom_texture_size = ts:GetSize();  --对于文字需要简单的缩放排版
      self.isNew = false;
    else
      self:SetShow(false); --关闭绘制
      LOG("Custom texture is null! Request id is: " .. tostring(id));
    end
  end
end
--]]

function MaskSequence:SetMaskTexture(texid,size)
  if self.maskID == nil then
    LOG("Internal mask id is nil");
  end
  
  --LOG("Texture id is: " .. tostring(texid));
  --LOG("Size is x: " .. tostring(size[1]) .. " y: " .. tostring(size[2]));
  --if id == self.maskID then
  if size and texid then
    local tex = apolloengine.TextureEntity();
    tex:PushMetadata(
      apolloengine.TextureResourceMetadata(
        mathfunction.vector2(size[1], size[2]),
        texid));
    tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
    tex:CreateResource();
    self.mask_texture = tex;
      --LOG("SetMaskTexture" .. tostring(id));
  else
    ERROR("empty size or texid");
  end
end


return MaskSequence;


