  
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local biugodefined = require "biugo.defined"
local Object = require "classic"
local likeapp = require "likeapp"
local defined = require "apolloutility.defiend"




local BlendBase = Object:extend();

function BlendBase:new(rows,cols,location,alphamode,maincamera)
    self.maincamera = maincamera;
    
    self.rows = rows;
    self.cols = cols;
    self.location = location;
    self.alphamode = alphamode;
    self.isShow = nil;
    
    if alphamode == nil or alphamode == "Add" or alphamode == "Blend" then -- add和normal 不走后处理 给opengl自己处理
      self.isblend = false;
    else
      self.isblend = true;
      self:_CreateCameraRendertarget();
      
      self.blend = apollonode.PostEffect();
      if self.blend:CreateResource(biugodefined.BlendMode[self.alphamode]) then
        self.blend:RegisterParameter("blendtex");
        self.blend["blendtex"](self.blend, self.tex)
        self.maincamera:AttachPostEffect(self.blend);
        self.blend:Disable();
      end
    end
    
    self.quadnode = apollonode.QuadNode();
    self.quadnode:SetShow(false); 


    apolloengine.ShaderEntity.TEXTURE_LOCATION =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_LOCATION");
    apolloengine.ShaderEntity.TEXTURE_SPLIT_INFO =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_SPLIT_INFO");
    apolloengine.ShaderEntity.TEXTURE_SIZE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "TEXTURE_SIZE");
    
    local baseStrMaterial = self:AssemblyMaterial();
    self.quadnode:CreateResourceByMaterialBuffer(baseStrMaterial, false);
    
    
end

function BlendBase:AssemblyMaterial()
    
    local alphamode_str = biugodefined.AlphaMode[self.alphamode];
    local shaderpart_str = biugodefined.Shaders["BaseVideo"];
    if alphamode_str == nil then
        alphamode_str = "{ ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA , ONE, ONE }"; --默认混合模式
    end
    
    local material_begin = "";
    if self.isblend == true then
      alphamode_str = "{ ALPAH_OFF }";
      material_begin = string.format(biugodefined.base_material_begin,"OPAQUE",alphamode_str);
    else
      material_begin = string.format(biugodefined.base_material_begin,"OPAQUE + 10",alphamode_str);
    end
    
    local materialsrc = material_begin .. shaderpart_str;
    materialsrc = materialsrc .. biugodefined.material_end;

    --LOG(materialsrc);
    return materialsrc;
    
end

function BlendBase:SetSequence(s)
    if self.isblend == true then
      self.quadnode:SetSequence(biugodefined.photomood_base_blend_camera_sequence);
    else
      self.quadnode:SetSequence(s);
    end
end

function BlendBase:SetShow(isShow)
  if self.isShow ~= isShow then
    self.isShow = isShow;
    self.quadnode:SetShow(isShow);
    if self.isblend == true then
      self.blend:Enable();
    end
    
  end
end

function BlendBase:Update()
    
    local diffuse_texture = videodecet:GetVideoTexture();
    local tex_size = diffuse_texture:GetSize();
    local textureLoc = mathfunction.vector2(self.location[1],self.location[2]);
    local textureSplitInfo = mathfunction.vector2(self.rows,self.cols);
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_LOCATION,textureLoc);
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_SPLIT_INFO,textureSplitInfo);
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_SIZE,mathfunction.vector2(tex_size:x(),tex_size:y()));
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,diffuse_texture); 
    
    self:SetShow(true);  --始终显示
end

function BlendBase:_CreateCameraRendertarget()
  local near = self.maincamera:GetNear();
  local far = self.maincamera:GetFar();
  local pos = self.maincamera:GetWorldPosition();
  local lookat = pos + self.maincamera:GetForward();
  local up = self.maincamera:GetUp();
  local color = mathfunction.Color(1.0,0.0,0.0,0.0); --清屏颜色
  
  self.historical_camera = apollonode.CameraNode();
  self.historical_camera:Activate();
  self.historical_camera:CreateRealCameraProjection(near, far);
  self.historical_camera:LookAt(pos, lookat, up);
  self.historical_camera:SetSequence(biugodefined.photomood_base_blend_camera_sequence);
  
  --self.rt = apolloengine.RenderTargetEntity();
  self.rt = self.historical_camera:CreateRenderTarget();
  self.rt:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      color,--清屏颜色
      apolloengine.Framework:GetViewport(),
      apolloengine.Framework:GetResolution()));--分辨率
  
  self.tex = self.rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.tex:PushMetadata(--创建纹理
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      apolloengine.Framework:GetResolution()));
  self.rt:CreateResource();
  self.historical_camera:AttachRenderTarget(self.rt);
end


return BlendBase;
