local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local renderqueue = require "apolloutility.renderqueue"
local defined = require "apolloutility.defiend"
local videodecet = require "videodecet"
local likeapp = require "likeapp"
local maskrender = require "apolloutility.maskrender"
require "venusdebug"
require "utility"

local beauty = {}
beauty.facemax = 3;
beauty.eyecount = 6;
beauty.eyerenderqueue = {}
function beauty:Initialize(maincamera)
  self: _CreatRenderTarget(maincamera);
  
  local indexstreamleft = apolloengine.IndicesStream(); 
  indexstreamleft:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  indexstreamleft:ReserveBuffer(18);
    
  indexstreamleft:PushIndicesData(0);
  indexstreamleft:PushIndicesData(5);
  indexstreamleft:PushIndicesData(1);
  indexstreamleft:PushIndicesData(1);
  indexstreamleft:PushIndicesData(5);
  indexstreamleft:PushIndicesData(12);
  indexstreamleft:PushIndicesData(12);
  indexstreamleft:PushIndicesData(5);
  indexstreamleft:PushIndicesData(13);
  indexstreamleft:PushIndicesData(12);
  indexstreamleft:PushIndicesData(13);
  indexstreamleft:PushIndicesData(4);
  indexstreamleft:PushIndicesData(12);
  indexstreamleft:PushIndicesData(4);
  indexstreamleft:PushIndicesData(2);
  indexstreamleft:PushIndicesData(2);
  indexstreamleft:PushIndicesData(4);
  indexstreamleft:PushIndicesData(3);
  
  local indexstreamright = apolloengine.IndicesStream(); 
  indexstreamright:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  indexstreamright:ReserveBuffer(18);
  
  indexstreamright:PushIndicesData(6);
  indexstreamright:PushIndicesData(7);
  indexstreamright:PushIndicesData(11);
  indexstreamright:PushIndicesData(7);
  indexstreamright:PushIndicesData(11);
  indexstreamright:PushIndicesData(14);
  indexstreamright:PushIndicesData(14);
  indexstreamright:PushIndicesData(11);
  indexstreamright:PushIndicesData(15);
  indexstreamright:PushIndicesData(14);
  indexstreamright:PushIndicesData(15);
  indexstreamright:PushIndicesData(10);
  indexstreamright:PushIndicesData(14);
  indexstreamright:PushIndicesData(10);
  indexstreamright:PushIndicesData(8);
  indexstreamright:PushIndicesData(8);
  indexstreamright:PushIndicesData(10);
  indexstreamright:PushIndicesData(9);
  
  for i=1, self.facemax, 1 do
    local eyemaskrenderleft = maskrender(12,18,indexstreamleft,mathfunction.vector4(1.0,1.0,1.0,1.0));
    local eyemaskrenderright = maskrender(12,18,indexstreamright,mathfunction.vector4(1.0,1.0,1.0,1.0));
    eyemaskrenderleft:SetSequence(-3000);
    eyemaskrenderright:SetSequence(-3000);
    table.insert(self.eyerenderqueue,eyemaskrenderleft);
    table.insert(self.eyerenderqueue,eyemaskrenderright);
  end
  
  self.post = apollonode.PostEffect();
  self.post:CreateResource("comm:script/apolloutility/posteffect/brighteyes.lua");
  maincamera:AttachPostEffect(self.post);
  self.post:RegisterParameter("eyesmask")
  self.post:RegisterParameter("strengh")
end

function beauty:Update(def)
  
  self.eyepoints  = {};
  local faces = videodecet:GetFaces();
  for k=1, #faces, 1 do
    local faceinfo = faces[k];
    self.keypoints = faceinfo:GetKeypointArray();
    for i=53, 64, 1 do
      table.insert(self.eyepoints,self.keypoints[i]);
    end
    table.insert(self.eyepoints,self.keypoints[73]);
    table.insert(self.eyepoints,self.keypoints[74]);
    table.insert(self.eyepoints,self.keypoints[76]);
    table.insert(self.eyepoints,self.keypoints[77]);
    
    local vertexstreamleft = apolloengine.VertexStream();--创建顶点流
    vertexstreamleft:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      apolloengine.VertexBufferEntity.DT_FLOAT,
      apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
      2);
    vertexstreamleft:ReserveBuffer(12); 
    for i=1, 16, 1 do
      vertexstreamleft:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector2(self.eyepoints[i][1],self.eyepoints[i][2]));
    end
    
    local vertexstreamright = apolloengine.VertexStream();--创建顶点流
    vertexstreamright:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      apolloengine.VertexBufferEntity.DT_FLOAT,
      apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
      2);
    vertexstreamright:ReserveBuffer(12); 
    for i=1, 16, 1 do
      vertexstreamright:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector2(self.eyepoints[i][1],self.eyepoints[i][2]));
    end
    self.eyerenderqueue[2*k-1]:SetShow(true);
    self.eyerenderqueue[2*k-1]:Update(vertexstreamleft);
    self.eyerenderqueue[2*k]:SetShow(true);
    self.eyerenderqueue[2*k]:Update(vertexstreamright);
  end
  
  self.post["eyesmask"](self.post, self.tex);
end

function beauty: _CreatRenderTarget(maincamera)
  
  local near = maincamera:GetNear();
  local far = maincamera:GetFar();
  local pos = maincamera:GetWorldPosition();
  local lookat = pos + maincamera:GetForward();
  local up = maincamera:GetUp();
  local color = mathfunction.Color(0.0,0.0,0.0,0.0); --清屏颜色
  
  self.eyemask_camera = apollonode.CameraNode();
  self.eyemask_camera:Activate();
  self.eyemask_camera:CreateRealCameraProjection(near, far);
  self.eyemask_camera:LookAt(pos, lookat, up);
  self.eyemask_camera:SetSequence(-3000);
  
  self.rt = self.eyemask_camera:CreateRenderTarget();
  self.rt:PushMetadata(--设置FBO格式
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        color,--清屏颜色
        apolloengine.Framework:GetViewport(),
        apolloengine.Framework:GetResolution()));--分辨率
    
  self.tex = self.rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        apolloengine.Framework:GetResolution()));
  self.rt:CreateResource();
  self.eyemask_camera:AttachRenderTarget(self.rt);
  
end

function beauty:SetStrength(strength)
  self.post["strengh"](self.post, strength/100);
end

function beauty:Release()
  self.eyemask_camera:Deactivate();
  self.eyemask_camera = nil;
  self.rt = nil;
  self.tex = nil;
  self.post = nil;
  self.eyerenderqueue = {};
  self.keypoints = {};
end

return beauty;