local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local ncnn = require "ncnnfunction"
local videodecet = require "videodecet"
local apollonode = require "apolloutility.apollonode"
local oneeurofilter = require "math.lowpassfilter.oneeurofilter"
local skeletonfit = require "avatar.skeletonfit_smpl"
local cameraestimate = require "avatar.cameraestimate"
local epnp = require "avatar.bodypnp"
require "utility"


local poseestimates14 = {}


local std3d = {
  110.7224395224947,
  22.388176174254347,
  72.46294421720373,
  158.56311079063173,
  189.33832206725427,
  208.80479145798353,
  191.79935232131172,
  243.2006168338775,
  247.56193295984693,
  110.72180724487369,
  22.38805433286514,
  72.46252568188349,
  158.80454092789694,
  199.77187809476604,
  214.7062978421496,
  180.01944122294572,
  250.52739312762094,
  248.53247137512838,
 -- 52.10694018270771,
 -- 52.1140552562803,
 -- 69.08241483855363,
  95.15366543888481,
  101.33031820020669,
  128.9973251543324,
 -- 117.42457701224566,
 -- 126.48468958404065,
 -- 164.65090647971442,
  123.6029657528179,
  130.85538909944856,
  164.33336500814266,	
  146.02231892533874,
  97.0795598515937,
  139.52731252584186,
  243.47531766057696,
  129.82248593326003,
  202.30181232857467,
  244.6877004789904,
  215.01816411816674,
  239.3823472541272,
  138.760844460741,
  100.89260001133229,
  142.44109658418054,
  236.87528986742385,
  144.91219013036826,
  209.80829096235226,
  244.00694913404305,
  239.7502834976899,
  255.20583985806599,
}

local mean3d = {
  -0.2556525886947795,
  -7.119605727416116,
  -0.9814330584948388,
  -5.654630512911183,
  319.63600940520956,
  71.93292692469369,
  -10.170583994141206,
  691.147891657268,
  155.35298624455555,
  0.2556513148981795,
  7.119546036952688,
  0.9814238602344578,
  -5.097297795487889,
  327.0404131275415,
  72.22580948277306,
  -9.996566061820296,
  708.2773832914069,
  158.01640791345199,
 -- 2.9058367556287306,
 -- -211.36330686630447,
 -- -47.421091522341754,
  5.6753780407515935,
  -435.08890570553115,
  -97.69740161233229,
 -- 5.93884963674382,
 -- -491.891970054098,
 -- -110.66661784332683,
  7.373520833615209,
  -583.9486185314574,
  -131.17140035921526,
  5.4192065289241445,
  -383.9317019573139,
  -86.81454166710293,
  2.959646625166301,
  -187.56748832018525,
  -43.453693436849946,
  1.26585821672136,
  -120.17057902524314,
  -28.252604914874993,
  4.671866390210052,
  -383.64408934471885,
  -85.51257837102308,
  1.6764857129649644,
  -197.00717718979865,
  -43.136836346611325,
  0.8705690141490188,
  -168.66456902427169,
  -37.39024980077856,
  -37.39024980077856,
}

local testinput = {
      -3.6432094938436173,
			-2.473685800253388,
			-3.5018250001633247,
			-2.2819855269614098,
			-3.355808821405587,
			-3.110499007315905,
			-3.1291815048255645,
			-3.2168022790605875,
			-3.6045638264489357,
			-2.3677907588904206,
			-3.380459394626892,
			-3.3190215190019026,
			-3.1542806114933217,
			-3.347422362827337,
			-3.65964250277779,
			-1.6848070235977601,
			-3.6916704592574328,
			-1.643562328039885,
			-3.5677230346766726,
			-0.8651148678037828,
			-3.5789365409813554,
			-1.651235022129677,
			-3.2181442159842892,
			-1.980565873738015,
			-3.2090677781771455,
			-1.5089156655093818,
			-3.4225364948009607,
			-1.553532718935693,
			-3.4220176026832583,
			-1.6834460612684448,
			-3.2643694516504516,
			-1.1807339111180348
    }
    
    local mean2d = {
      --534.2362067815909,425.88147731177776,
      533.393731182906,425.6983578158579,
      534.3978023429365,497.43802989193154,
      532.481293821069,569.0466234375722,
      535.2915655822208,425.73629461606714,
      532.7675617662295,496.4731547066457,
      530.8880341233735,569.6075068344198,
      --535.7534460606558,331.2267732306162,
      536.3380005282891,317.4499285783894,
      536.7162946417122,269.119694669409,
      536.3674026383682,330.27798906492825,
      535.8566970903066,374.59944401417664,
      534.7028848175864,387.35266055116455,
      534.9920256553606,331.7734652688376,
      534.611308079746,373.81679138734876,
      535.2152919182024,379.5077967523042}
      
      local std2d = {
      --107.37361012086936,61.634909589570334,
      114.89497052627252,61.911997024725586,
      117.27565510971122,50.22711629323473,
      118.89857526011964,55.0000570865409,
      102.91089763326161,61.338520877316505,
      106.6694471505881,47.96084756161423,
      108.13481259325421,53.60647265856601,
      --110.5622742770474,72.91669969652871,
      110.84492972268202,76.09916642663414,
      115.08215260502243,82.92943734420392,
      105.04274863959776,72.84070268738881,
      106.31581039747435,73.21929020828857,
      108.0876752788032,82.49487760274116,
      124.31763034139937,73.34214366385531,
      132.80917569040227,76.37108859015507,
      131.60933137204532,88.82878858279597}
      
      local gtmean2d = {
        --532.0835163565547,419.74137558120003,
        531.8095314362356,418.2607140959499,
        530.6845696830876,493.54259286466254,
        529.3696872290743,575.9644851654803,
        532.2976764528628,421.28483334982246,
        531.939466313509,494.7218679310468,
        529.7198444740386,578.9611036393283,
        --532.9369938236075,370.65225055228814,
        534.110185586839,317.903423113612,
        534.8695500439201,282.31030885794667,
        534.1130856750716,330.1129679287782,
        533.5363752584062,376.27425107952274,
        533.4938010568245,391.7232456145298,
        533.5257914249777,330.09494668526725,
        532.5080496257572,374.1904790365164,
        532.7278693355262,380.61615718919944
      }
      
      local gtstd2d = {
        --107.73640056632647,63.35908715293127,
        119.00836215445092,64.12154429274791,
        119.12412106402572,50.538062145059534,
        120.6168804143148,56.38444889286369,
        101.95735272862534,62.89636485952771,
        106.24832896571219,48.41178119137708,
        108.46734963957013,54.581770692384666,
       -- 109.07369806463174,68.70443671531466,
        111.20130350472374,74.87287863300989,
        113.2233078961136,79.90670556162974,
        105.71458330124277,73.27049437203256,
        107.05804267166643,73.93175782533872,
        107.97449418517449,83.30391805242135,
        121.60675105903508,74.25691527749441,
        134.3437897403436,77.48125087680438,
        131.79990652239553,89.8672112391702
      }
      

local datalike = 
{
  -1.6506496017232,
1.9650961361793,
-1.770257916872,
1.9592590776178,
-1.7428834838034,
3.117080606301,
-1.7450275864715,
3.3809669737222,
-1.4701219118831,
1.9769584210626,
-1.3759100256612,
3.2844883546101,
-1.2843970483936,
3.3837796849817,
-1.6077224100441,
1.0391752106821,
-1.5096585919351,
0.71682876413898,
-1.4486720214029,
0.38442688569404,
-1.1458896896477,
0.92972758961037,
-0.52538467121193,
0.29228029833319,
0.17853205865181,
-0.11337262170632,
-1.7374207106603,
0.88934589954326,
-2.1505389713851,
0.25118417148141,
-2.7370041938737,
-0.039489413379027,

}

local dataori = 
{
0.39777432193021633,
-0.4579492608399594,
0.19366492034483304,
-0.47803663454320233,
0.23852102368137107,
-0.529574438149443,
0.3192428341309829,
-0.5827572902117928,
0.6185432236199527,
-0.435223930669228,
0.5655383720184978,
-0.43355882222473163,
0.5785305598340772,
-0.5171784723359699,
0.392327344321698,
-0.326217012538484,
0.39996034932892377,
-0.237159167762415,
0.3415249141169309,
-0.1593820688651604,
0.6453336662323754,
-0.2591733485415933,
1.0610496519519266,
-0.762434322651417,
1.4450593330447539,
-0.8132206790598917,
0.18025947795443134,
-0.27728504350984057,
-0.1549482003630772,
-0.7027839897521204,
-0.48804531759533926,
-0.7051407561501395
}

local bonepair = {
  {0,1},
  {1,2},
  {3,4},
  {4,5},
  {6,7},
  {3,8},
  {8,9},
  {9,10},
  {0,11},
  {11,12},
  {12,13}
}

local namebonemapping = 
{
  ["Pelvis"] = 0,
  ["RightUpLeg"] = 4,
  ["RightLeg"] = 5,
  ["RightFoot"] = 6,
  ["LeftUpLeg"] = 1,
  ["LeftLeg"] = 2,
  ["LeftFoot"] = 3,
  ["Spine1"] = 7,
  ["Spine2"] = 8,
  ["Neck"] = 9,
  ["Head"] = 10,
  ["LeftArm"] = 14,
  ["LeftForeArm"] = 15,
  ["LeftHand"] = 16,
  ["RightArm"] = 11,
  ["RightForeArm"] = 12,
  ["RightHand"] = 13,
}

local namebonemapping14 = 
{
  ["RightUpLeg"] = 4,
  ["RightLeg"] = 5,
  ["RightFoot"] = 6,
  ["LeftUpLeg"] = 1,
  ["LeftLeg"] = 2,
  ["LeftFoot"] = 3,
  ["Neck"] = 7,
  ["Head"] = 8,
  ["LeftArm"] = 12,
  ["LeftForeArm"] = 13,
  ["LeftHand"] = 14,
  ["RightArm"] = 9,
  ["RightForeArm"] = 10,
  ["RightHand"] = 11,
}

local rotateDetermMap = 
{

  ["RightUpLeg"] = "RightLeg",
  ["RightLeg"] = "RightFoot",
  ["LeftUpLeg"] = "LeftLeg",
  ["LeftLeg"] = "LeftFoot",
  ["Neck"] = "Head",
  ["LeftArm"] = "LeftForeArm",
  ["LeftForeArm"] = "LeftHand",
  ["RightArm"] = "RightForeArm",
  ["RightForeArm"] = "RightHand",
}

local rotnamebonemapping = 
{
  ["Pelvis"] = 0,
  ["RightUpLeg"] = 5,
  ["RightLeg"] = 6,
  ["RightFoot"] = nil,
  ["LeftUpLeg"] = 2,
  ["LeftLeg"] = 3,
  ["LeftFoot"] = nil,
  ["Spine1"] = 7,
  ["Spine2"] = 8,
  ["Neck"] = 9,
  ["Head"] = 10,
  ["LeftShoulder"] = 14,
  ["LeftArm"] = 15,
  ["LeftForeArm"] = 16,
  ["RightShoulder"] = 11,
  ["RightArm"] = 12,
  ["RightForeArm"] = 13
}


local g_w = 800;
local g_h = 800;

function poseestimates14:Initialize()  
  self.inmat = ncnn.Mat();
  self.outmat = ncnn.Mat();
  self.net = ncnn.Net();
  self.net:LoadParam("docs:ncnn/prediect14/ncnn.proto");
  self.net:LoadModel("docs:ncnn/prediect14/ncnn.bin");

  --self.net:LoadParam("E:/workspace/algo_video_facecute/venussdk/documents/ncnn/ncnn.proto");
  --self.net:LoadModel("E:/workspace/algo_video_facecute/venussdk/documents/ncnn/ncnn.bin");
  
  epnp:Initialize(epnp.male);
  
  self.renders = {}
  self.nodes = {}
  self.trans = {}
  self.eurofilters = {}

  self.currentTime = 0;
  self.fit = skeletonfit;
  self.fit:Initialize();
  epnp:Initialize(epnp.male, maincamera);
  
  self.bonelength = nil;
  
  self.testModel = apollonode.ModelNode();
  self.testModel:CreateResource("docs:SMPL_M","comm:documents/material/simple.material");
  
end

function poseestimates14:redirect(points2d)
  local result = {}


  --rleg
  result[1] =   points2d[19];
  result[2] =    points2d[20];
  result[3] =    points2d[23];
  result[4] =    points2d[24];
  result[5] =    points2d[27];
  result[6] =    points2d[28];
  --lleg
  result[7] = points2d[17];
  result[8] =points2d[18];
  result[9] =points2d[21];
  result[10] =points2d[22];
  result[11] =points2d[25];
  result[12] =points2d[26];
  --xiong
  local chestx = (points2d[5]+points2d[7])/2;
  local chesty = (points2d[6]+points2d[8])/2;

  --bozi
  result[13] = points2d[3];
  result[14] = points2d[4];
  --head
  result[15] =  points2d[1];
  result[16] =  points2d[2];

  --LARM
  result[17] = points2d[5]; 
  result[18] = points2d[6]; 
  result[19] = points2d[9]; 
  result[20] = points2d[10];
  result[21] = points2d[13];
  result[22] = points2d[14];
  --RARM
  result[23] =   points2d[7];
  result[24] =   points2d[8];
  result[25] =   points2d[11];
  result[26] =   points2d[12];
  result[27] =   points2d[15];
  result[28] =   points2d[16];
  return result;
end

function poseestimates14:Estimates(timespan)

  self.currentTime=timespan+self.currentTime;
  local scenetimepoint2ds = videodecet:GetBodyPoints();--像素坐标
  local totalcount = table.getn(scenetimepoint2ds)
 
  --self:AttachBoneRender(1,mathfunction.vector3(0,0,0),mathfunction.vector3(3,3,3));
  if totalcount==0 then 
    return false;
  end
  for i = 1 ,totalcount do
    if scenetimepoint2ds[i]==-1 then 
      if self.lastpoints2ds~=nil and self.lastpoints2ds[i]~=nil and self.lastpoints2ds[i]~=-1 then
        LOG("no full bones,use last frame data!!! "..totalcount);
        return false;
      else
        LOG("no full bones,return!!! "..totalcount);
        return false;
      end
    end
  end
  local estimate2darray = self:redirect(scenetimepoint2ds);
  local inputpointsdata = self:redirect(scenetimepoint2ds);
  for i = 1 ,28 do
    inputpointsdata[i] = (inputpointsdata[i]-gtmean2d[i])/gtstd2d[i];
  end
  
  self.inmat:Fill(inputpointsdata);  
  --self.inmat:Fill(dataori);  
  
  self.extractor = self.net:CreateExtractor();  
  local count = venuscore.IServicesSystem:GetThreadCount();
  self.extractor:SetNumThreads(count/2); 
  self.extractor:Input("inputs/enc_in", self.inmat);
  self.extractor:Extract("linear_model/add_1", self.outmat);
  local outarray = self.outmat:AsFloatArray();
  local estimate3darray = {}
  for i = 1 ,42 do
    outarray[i] = outarray[i]*std3d[i]+mean3d[i];
    estimate3darray[i] = outarray[i];
    outarray[i] = outarray[i]/1000;
    --[[
    if self.eurofilters[i] ==nil then
      self.eurofilters[i] = oneeurofilter(self.currentTime,outarray[i],0,1,0,1);
    else
      local x = self.eurofilters[i]:filter(self.currentTime,outarray[i]);
      outarray[i] = x;
    end
    ]]
  end
  
  self.positions = {}
  for i = 1 ,42, 3 do
    local pos = mathfunction.vector3(
      outarray[i],
      -outarray[i+1],
      outarray[i+2]);
    table.insert(self.positions, pos);
  end
  LOG(self.positions);
  
  --reset model
  local skeleton = self.testModel.skeletonNode.skeleton;

  for i=1, #self.fit:GetBoneName() do
    local joint = skeleton:GetJoint(self.fit:GetBoneName()[i]);
    local transform = joint:GetComponent(apolloengine.Node.CT_TRANSFORM);
    local quaternion = mathfunction.Quaternion();
    transform:SetLocalRotation(quaternion);
  end
  local firstrotation = mathfunction.Quaternion();
  firstrotation:YawPitchRoll(0,0,0);
  self.testModel:SetLocalRotation(firstrotation);
  
  
  --update pnp
  
  --local posrot = epnp:Update();
  --self.testModel:SetLocalPosition(posrot.position);
 


 
 
  --****************************center2dpoints**********************************--
  local videosize = videodecet:GetVideoSize();
  local realres = apolloengine.Framework:GetResolution();
  local s_x = realres:x() / videosize[1];
  local s_y = realres:y() / videosize[2];
  
  --local centeredpoint2d = {}
  for i=1, #estimate2darray/2 do
    local idx1 = (i-1)*2+1;
    local idx2 = (i-1)*2+2;
    estimate2darray[idx1] = estimate2darray[idx1] *s_x ;                    --  -50and-250 is hack offset for pnp estimate.
    estimate2darray[idx2] = realres:y()-estimate2darray[idx2] *s_y ;
  end
  --********************************************************************************--
  local torso2d = {};
  local torso3d = {};
  
  
  local idxLeftShoulder = namebonemapping14["LeftArm"];
  local idxRightShoulder = namebonemapping14["RightArm"];
  local idxLeftHip = namebonemapping14["LeftUpLeg"];
  local idxRightHip = namebonemapping14["RightUpLeg"];
  
  table.insert(torso2d,mathfunction.vector2(estimate2darray[idxLeftShoulder*2-1],estimate2darray[idxLeftShoulder*2]  ))
  table.insert(torso2d,mathfunction.vector2(estimate2darray[idxRightShoulder*2-1],estimate2darray[idxRightShoulder*2]))
  table.insert(torso2d,mathfunction.vector2(estimate2darray[idxLeftHip*2-1],estimate2darray[idxLeftHip*2]            ))
  table.insert(torso2d,mathfunction.vector2(estimate2darray[idxRightHip*2-1],estimate2darray[idxRightHip*2]          ))
 
  --table.insert(torso3d,mathfunction.vector3(estimate3darray[idxLeftShoulder*3-2], estimate3darray[idxLeftShoulder*3-1], estimate3darray[idxLeftShoulder*3]  ))
  --table.insert(torso3d,mathfunction.vector3(estimate3darray[idxRightShoulder*3-2],estimate3darray[idxRightShoulder*3-1],estimate3darray[idxRightShoulder*3]))
  --table.insert(torso3d,mathfunction.vector3(estimate3darray[idxLeftHip*3-2],      estimate3darray[idxLeftHip*3-1],      estimate3darray[idxLeftHip*3]            ))
  --table.insert(torso3d,mathfunction.vector3(estimate3darray[idxRightHip*3-2],     estimate3darray[idxRightHip*3-1],     estimate3darray[idxRightHip*3]          ))


 -- table.insert(torso3d,skeleton:GetJoint("m_avg_L_Shoulder"):GetComponent(apolloengine.Node.CT_TRANSFORM):GetWorldPosition())
 -- table.insert(torso3d,skeleton:GetJoint("m_avg_R_Shoulder"):GetComponent(apolloengine.Node.CT_TRANSFORM):GetWorldPosition())
 -- table.insert(torso3d,skeleton:GetJoint("m_avg_L_Hip"):GetComponent(apolloengine.Node.CT_TRANSFORM):GetWorldPosition())
 -- table.insert(torso3d,skeleton:GetJoint("m_avg_L_Hip"):GetComponent(apolloengine.Node.CT_TRANSFORM):GetWorldPosition())
  
    
  table.insert(torso3d,mathfunction.vector3(0.16283901, 0.21808746, -0.01237748   ) )
  table.insert(torso3d, mathfunction.vector3(-0.16401207, 0.21695904, -0.01982267  )) 
  table.insert(torso3d, mathfunction.vector3(0.07048489, -0.30100253, 0.01977493   )) 
  table.insert(torso3d,mathfunction.vector3(-0.06988833, -0.30037916, 0.02302543  ) )

  local focalelength = math.max(realres:x(),realres:y());
  local zoffset,offset2d = cameraestimate:Estimate(focalelength,realres:x()/2,realres:y()/2,torso2d,torso3d);
  local cameraoffset = {0,0,zoffset};
  
  local centeredpoint2d = {}
  for i=1, #estimate2darray/2 do
    local idx1 = (i-1)*2+1;
    local idx2 = (i-1)*2+2;
    centeredpoint2d[idx1] = estimate2darray[idx1] - offset2d[1] ;                    --  -50and-250 is hack offset for pnp estimate.
    centeredpoint2d[idx2] = estimate2darray[idx2] - offset2d[2] ;
  end
  
  --***************************move3d points dependon camera estimate*******************************--
  local centeredpoint3d = {}
  for i = 1 ,42, 3 do
    local pos = mathfunction.vector3(
      estimate3darray[i],
      estimate3darray[i+1],
      estimate3darray[i+2]);
    table.insert(centeredpoint3d, pos);
  end
  --****************************proj**********************************--
  
  self.lastpoints2ds = estimate2darray;
  local vec3list = {};
  vec3list[1] = centeredpoint3d[namebonemapping14["LeftArm"]];     
  vec3list[2] = centeredpoint3d[namebonemapping14["LeftForeArm"]];
  vec3list[3] = centeredpoint3d[namebonemapping14["LeftHand"]]; 
  
  vec3list[4] = centeredpoint3d[namebonemapping14["RightArm"]];     
  vec3list[5] = centeredpoint3d[namebonemapping14["RightForeArm"]];
  vec3list[6] = centeredpoint3d[namebonemapping14["RightHand"]];   
  
  vec3list[7] = centeredpoint3d[namebonemapping14["LeftUpLeg"]] ; 
  vec3list[8] = centeredpoint3d[namebonemapping14["LeftLeg"]];
  vec3list[9] = centeredpoint3d[namebonemapping14["LeftFoot"]];
  
  vec3list[10] = centeredpoint3d[namebonemapping14["RightUpLeg"]];
  vec3list[11] = centeredpoint3d[namebonemapping14["RightLeg"]];
  vec3list[12] = centeredpoint3d[namebonemapping14["RightFoot"]];

  local vec2list = {};

  vec2list[1] = {centeredpoint2d[namebonemapping14["LeftArm"]*2-1],centeredpoint2d[namebonemapping14["LeftArm"]*2]};
  vec2list[2] = {centeredpoint2d[namebonemapping14["LeftForeArm"]*2-1],centeredpoint2d[namebonemapping14["LeftForeArm"]*2]};
  vec2list[3] = {centeredpoint2d[namebonemapping14["LeftHand"]*2-1],centeredpoint2d[namebonemapping14["LeftHand"]*2]};

  vec2list[4] = {centeredpoint2d[namebonemapping14["RightArm"]*2-1],centeredpoint2d[namebonemapping14["RightArm"]*2]};
  vec2list[5] = {centeredpoint2d[namebonemapping14["RightForeArm"]*2-1],centeredpoint2d[namebonemapping14["RightForeArm"]*2]};
  vec2list[6] = {centeredpoint2d[namebonemapping14["RightHand"]*2-1],centeredpoint2d[namebonemapping14["RightHand"]*2]};

  vec2list[7] = {centeredpoint2d[namebonemapping14["LeftUpLeg"]*2-1],  centeredpoint2d[namebonemapping14["LeftUpLeg"]*2]};
  vec2list[8] = {centeredpoint2d[namebonemapping14["LeftLeg"]*2-1],    centeredpoint2d[namebonemapping14["LeftLeg"]*2]};
  vec2list[9] = {centeredpoint2d[namebonemapping14["LeftFoot"]*2-1],   centeredpoint2d[namebonemapping14["LeftFoot"]*2]};

  vec2list[10] = {centeredpoint2d[namebonemapping14["RightUpLeg"]*2-1],  centeredpoint2d[namebonemapping14["RightUpLeg"]*2]};
  vec2list[11] = {centeredpoint2d[namebonemapping14["RightLeg"]*2-1],    centeredpoint2d[namebonemapping14["RightLeg"]*2]};
  vec2list[12] = {centeredpoint2d[namebonemapping14["RightFoot"]*2-1],   centeredpoint2d[namebonemapping14["RightFoot"]*2]};

  
  local point2d = vec2list;
  
  local bones = {}
  
  bones[1] = {};
  bones[1].children = {};
  bones[1].pos =  mathfunction.vector3(0,0,0);
  
  for i=2,13 do
    bones[i] = {};
    bones[i].name = i;
    bones[i].children = {};
    bones[i].pos =  vec3list[i-1];
  end
  
  local fatherlist = {0,1,2,3,1,5,6,1,8,9,1,11,12}
  for i=1,#fatherlist do
    if fatherlist[i] ~= 0 then
      bones[i].father = bones[fatherlist[i]];
      table.insert(bones[fatherlist[i]].children,bones[i]);
    end
  end

  local localrotatelist = {};
  self.fit:SetupBone( bones[1],localrotatelist);

  
  self.fit:SetCamera(math.max(realres:x(), realres:y()),math.max(realres:x(), realres:y()),realres:x()*0.5,realres:y()*0.5);
  
  local ret,rotate = self.fit:EstimateRotation(self.lastrotatecache,point2d,cameraoffset);
  self.lastrotatecache = rotate;
  --local rotate = self.fit:GetMeanPose();

  for i=1, #self.fit:GetBoneName() do
    local joint = skeleton:GetJoint(self.fit:GetBoneName()[i]);
    local transform = joint:GetComponent(apolloengine.Node.CT_TRANSFORM);
    local rotate = mathfunction.vector3( rotate[i][1],rotate[i][2],rotate[i][3]);
    local angle = rotate:Length();
    local dir = rotate:Normalize();
    local quaternion = mathfunction.Quaternion();
    if angle<0.0001 then
      dir =  mathfunction.vector3(0,0,1);
    end
    quaternion:RotateAxis(dir,angle)
    transform:SetLocalRotation(quaternion);
  end
 -- local fixrotation = mathfunction.Quaternion();
 --fixrotation:YawPitchRoll(3.14,0,3.14);
 -- self.testModel:SetLocalRotation(fixrotation);
  
  local diffarr = {};
  
  for i = 1,12 do
    diffarr[i] = {};
    diffarr[i][1] = vec3list[i]:x() - ret[i][1];
    diffarr[i][2] = vec3list[i]:y() - ret[i][2];
    diffarr[i][3] = vec3list[i]:z() - ret[i][3];
  end
  
  for i = 1,12 do
    ret[i][1] = (ret[i][1])/1000;
    ret[i][2] = (-ret[i][2])/1000;
    ret[i][3] = (ret[i][3]-1000)/1000;
  end
  
  
  self.oripositions = {}
  for i=1,#self.positions do
    self.oripositions[i] = mathfunction.vector3(self.positions[i]:x(),self.positions[i]:y(),self.positions[i]:z());
  end

  return true;
end

function poseestimates14:TPose()
  if self.tpose ==nil then
    self.tpose  = {
      mathfunction.vector3(0.086,0.005,-0.026),
      mathfunction.vector3(0.066,-0.359,0.042),
      mathfunction.vector3(0.036,-0.715,-0.085),
      mathfunction.vector3(-0.086,-0.005,0.026),
      mathfunction.vector3(-0.089,-0.384,0.080),
      mathfunction.vector3(-0.111,-0.741,0.046),
      mathfunction.vector3(-0.023,0.624,0.078),
      mathfunction.vector3(-0.003,0.704,0.035),
      mathfunction.vector3(-0.155,0.400,0.017),
      mathfunction.vector3(-0.411,0.400,0.017),
      mathfunction.vector3(-0.585,0.400,0.017),
      mathfunction.vector3(0.155,0.399,-0.008),
      mathfunction.vector3(0.411,0.4,-0.008),
      mathfunction.vector3(0.585,0.4,-0.008),
    }

  end
 
  return self.tpose;
end
function poseestimates14:Render()
  for i = 1 ,11 do
		local fidx =	bonepair[i][1]+1;
		local sidx = 	bonepair[i][2]+1;
		local fpos = mathfunction.vector3(0,1.5,-5);
		local spos = mathfunction.vector3(0,1.5,-5);
		if fidx~= 0 then
			fpos = self.positions[fidx] + fpos;
		end
		if sidx~= 0 then
			spos = self.positions[sidx] + spos;
		end		
		self:AttachBoneLineRender(i,fpos,spos,1);
	end
  
  
end

function poseestimates14:AttachBoneLineRender(index,pos1,pos2,scale)
	local dir = pos2 - pos1;
	local midpos = (pos2+pos1)/2;
	local length = dir:Length();
	local otherscale = length/4;
	dir:NormalizeSelf();

	local rotation = mathfunction.Quaternion();
	rotation:AxisToAxis(mathfunction.vector3(0,0,1),dir);

	if self.trans[index]==nil then
		local node = apolloengine.Node();
		local cube = apolloengine.RenderComponent();
		local trans = apolloengine.TransformComponent()
		cube:PushMetadata(
		apolloengine.RenderObjectMaterialMetadata(
			apolloengine.PathMetadata("comm:documents/material/lightingonly.material")));  
		cube:PushMetadata(
			apolloengine.RenderObjectMeshFileMetadate("comm:documents/model/cube.mesh"));  
		cube:CreateResource();
		node:AttachComponent(trans);
		node:AttachComponent(cube);
		
		table.insert(self.renders, cube);
		table.insert(self.nodes, node);
		table.insert(self.trans, trans);		
	end
	
	self.trans[index]:SetLocalScale(mathfunction.vector3(otherscale,otherscale,length));
	self.trans[index]:SetLocalPosition(midpos);
	self.trans[index]:SetLocalRotation(rotation);

end

function poseestimates14:VaildBone(name)
  return nil ~= namebonemapping[name];
end

function poseestimates14:GetDirection(j1, j2)
  local index1 = namebonemapping14[j1];
  local index2 = namebonemapping14[j2];
  if index1~=nil and index2 ~=nil then
    local pos1 = self.positions[index1];
    local pos2 = self.positions[index2];
    local dir = pos2 - pos1;
    dir:NormalizeSelf();
    return dir;
  else
    LOG("no direction form "..j1.." to "..j2.." is found");
    return false;
  end
end

function poseestimates14:GetRotatation(jointname)
  if rotateDetermMap[jointname] ==nil then
    return false
  end
  local index1 = namebonemapping14[jointname];
  local index2 = namebonemapping14[rotateDetermMap[jointname]];
  if index1==nil or index2==nil then
    return false
  end

  local pos1 = self.positions[index1];
  local pos2 = self.positions[index2];
  local dir = pos2 - pos1;
  dir:NormalizeSelf();

  pos1 = self:TPose()[index1];
  pos2 = self:TPose()[index2];
  local dir2 = pos2 - pos1;
  dir2:NormalizeSelf();
  --LOG("new direction form "..j1.." to "..j2.." is "..tostring(dir));

  local rotation = mathfunction.Quaternion();
	rotation:AxisToAxis(dir2,dir);


  return rotation;
end

function poseestimates14:GetRotated(j1, j2)
  local index1 = rotnamebonemapping[j1];
  local index2 = rotnamebonemapping[j2];
  
  if true then
    LOG(j1.." "..j2);
    return false;
  end
  local pos1 = self.positions[index1];
  local pos2 = self.positions[index2];


  local dir = pos2 - pos1;
  dir:NormalizeSelf();

  pos1 = self:TPose()[index1];
  pos2 = self:TPose()[index2];
  local dir2 = pos2 - pos1;
  dir2:NormalizeSelf();
  --LOG("new direction form "..j1.." to "..j2.." is "..tostring(dir));

  local rotation = mathfunction.Quaternion();
	rotation:AxisToAxis(dir2,dir);

  return rotation;
end

return poseestimates14;