#include "functions/lut.function"

#SHADER_DEFINE FacechangeLutVertex

 FUNCTION_INPUT = 
 {
    { ATTRIBUTE_POSITION,      HIGH, VEC4,  "in_Position" },
    { ATTRIBUTE_COORDNATE0,   HIGH, VEC2,  "in_TexCooridate"},
    { ATTRIBUTE_FACECOORDNATESTD,   HIGH, VEC2,  "in_TexCooridatestd"},
    { UNIFORM_FACETEXPARA,       HIGH, VEC4,  "in_facetexpara" },
 }

 FUNCTION_OUTPUT = 
 {
  
    { ATTRIBUTE_COORDNATE0,   HIGH, VEC2,  "out_TexCooridate" },
    { ATTRIBUTE_COORDNATE1,     HIGH,    VEC2,        "out_TexCooridateBag" },
    { ATTRIBUTE_FACECOORDNATESTD,   HIGH, VEC2,  "out_TexCooridatestd"},
 }

#SHADER_CODE
    gl_Position =in_Position;
    vec2 out_TexCooridateBag;
    out_TexCooridateBag=(vec2(1.0,1.0)+in_Position.xy)/2.0;
    vec2 out_TexCooridate = in_TexCooridate.xy;
    vec2 out_TexCooridatestd = in_TexCooridatestd.xy*vec2(in_facetexpara.x,in_facetexpara.y)+vec2(in_facetexpara.z,in_facetexpara.w);
#END_CODE
#END_DEFINE


#SHADER_DEFINE FacechangeLutFragment

 FUNCTION_INPUT = 
 {
    { TEXTURE_DIFFUSE,     NONE, TEXTURE2D, "in_Texture" },
    { TEXTURE_BACKG,     NONE, TEXTURE2D, "in_TextureFace" },
    { TEXTURE_LUT,       NONE, TEXTURE2D, "in_TextureLut"},
    { ATTRIBUTE_COORDNATE0, HIGH, VEC2,    "in_TexC" }, 
    { ATTRIBUTE_COORDNATE1,     HIGH,    VEC2,     "in_TexCooridateBag" },
    { ATTRIBUTE_FACECOORDNATESTD,   HIGH, VEC2,  "in_TexCooridatestd"},
    { UNIFORM_ALPHACOF, HIGH, FLOAT,   "in_alpha" },
 }
 
#SHADER_CODE
    vec4 baseColor = texture2D(in_Texture, in_TexCooridateBag);
    vec4 blendColor = texture2D(in_TextureFace, in_TexCooridatestd);
    vec4 newColor = LUT(baseColor, in_TextureLut);
    gl_FragColor = vec4(newColor.rgb,blendColor.a);
#END_CODE
#END_DEFINE