local Object = require "classic"
local mlseg = Object:extend();
local videodefined = require"videodecet.defined"
local apolloengine = require "apolloengine"
local vc = require "venuscore"
local maskOutW = 128;
local SegQue = 6;
local mlcnnseg =nil;
local CnnSegShell = nil;
local likeapp = require "likeapp"
local mathfunction = require "mathfunction"
local videodetect = require "videodecet.videodecet"
require "utility"

function mlseg:SetCnnSegShell()
  --if _PLATFORM_WINDOWS then
  --     mlcnnseg = require "mlcnnseg"
  --     CnnSegShell =mlcnnseg.CnnSegShell;
  --else
  -- 与 mldetection.lua 保持一致
      mlcnnseg = require "machinelearningservice"
      CnnSegShell =mlcnnseg.MachinelearningService;
  --end
 
end

function mlseg:ToRelativeCoordinates(pixel_x, pixel_y)
  return pixel_x / self.width * 2 - 1, 1 - pixel_y / self.height * 2;
end

function mlseg:new()
  self.cnnSegMark = false;
  self:initPara();
  self:SetCnnSegShell();
end

function mlseg:initPara()
  self.w = 0;
  self.h = 0;
  self.cnnsegInit = false;
  self.cnnsegtexture = nil;
  self.cnnsegts = nil;
  self.cnnsegbox = {};
  self.width = 0;
  self.height = 0;
 -- self.cnnSegMark = false;
end

function mlseg:InitCnnSeg( w, h)
  if( mlcnnseg==nil or CnnSegShell==nil)
  then 
    return;
  end
  self:initPara();
  self.cnnseg = CnnSegShell();
  if(self.cnnseg and CnnSegShell.SetType)
  then
    self.cnnseg:SetType(self.segType);
  end

  if _PLATFORM_WINDOWS then  --只有windows需要设置模型路径,所有的模型文件都统一到comm:documents/bvtmodel/
    self.cnnseg:SetModelAndParamsWin(
            videodefined.faceSegType.CNNSEG_FULL_HAIR + videodefined.cppTypeOffset ,
            vc.IFileSystem:PathAssembly(videodefined.bvt_model_path));
  end

  local r =self.cnnseg:Init(w,h);
  if(r~=videodefined.iris_detect_flag.SUCCESS)
  then
    self.cnnsegInit = false;
  else
    self.cnnsegInit = true;
    self.w = w;
    self.h = h;
  end
  
  self.cnnsegtexture = nil;
  self.ts = apolloengine.TextureStream();
  self.ts:SetStreamType(
     mathfunction.vector2(32,1),
     apolloengine.TextureEntity.PF_L8);
  for u=1, 32 do
    self.ts:SetPixel(u, 1, mathfunction.vector1(0.0));
  end   
  
  self.cnnsegtexture = apolloengine.TextureEntity();
  self.cnnsegtexture:PushMetadata(
  apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_WRITE,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,self.ts));
  self.cnnsegtexture:CreateResource();
    
end

function mlseg:SetType(segType)
    self.segType = segType + SegQue;
end

function mlseg:startNewUpdate()
  
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return;
  end
  self.newupd = true;
end


function mlseg:SetCnnSegMark(mark)
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return;
  end
  self.cnnSegMark = mark;
end

function mlseg:OnResizeView(w,h)
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return;
  end
  if(self.w~=w or self.h~=h)
  then
    self.cnnsegInit = false;
  end
end

function mlseg:Update(ts,def)
  if( mlcnnseg==nil or CnnSegShell==nil)then
    return nil;
  end
  self:_UpdateCnnSeg(ts,def);
  return self.cnnsegtexture,self.cnnsegbox;
end


function mlseg:_UpdateCnnSeg(ts,def)
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return;
  end
  
  if(not self.newupd)then
    return;
  end
   
  if(not (self.cnnSegMark and self.cnnsegInit==true))then
    return;
  end
  local cnnsegts = nil; 
  local boxarray = nil;
  local inputs = nil;
  inputs = videodetect:GetPixelFacekeypointArray();
  if(ts==nil)
  then
    boxarray = self.cnnseg:Run(inputs,self.tsPara);
    cnnsegts = self.cnnseg:GetMask(self.tsPara);
  else
    boxarray = self.cnnseg:Run(inputs,ts);
    cnnsegts = self.cnnseg:GetMask(ts);
  end
  
  if(cnnsegts==nil or boxarray==nil)
  then
    self.cnnsegbox = nil;
    return;
  end
  
  self.cnnsegts = cnnsegts;
  self.cnnsegtexture:ChangeTextureBuffer(self.cnnsegts);
  local sizevector = cnnsegts:GetSize();
  self.width = sizevector:x();
  self.height = sizevector:y();
  self.cnnsegbox = {};
  --LOG("SIZE"..self.w.." "..self.h);
  for i=1, boxarray:Size(), 2 do
    local boxpos = boxarray:Get(i);
    local boxsize = boxarray:Get(i+1);
    --LOG("KEY POS"..boxpos:x().." "..boxpos:y());
    --LOG("RECT SIZE.."..boxsize:x().." "..boxsize:y());
    local xmin,ymax = self:ToRelativeCoordinates(boxpos:x(), boxpos:y());
	  local xmax,ymin = self:ToRelativeCoordinates(boxpos:x() + boxsize:x(), boxpos:y()+boxsize:y());
	  --LOG("xymin"..xmin.." "..ymin);
	  --LOG("xymax"..xmax.." "..ymax);
    table.insert(self.cnnsegbox,{xmin,ymin,xmax,ymax});
  end
  self.newupd = false;
end

return mlseg;
