
local Object = require "classic"
local haircnnseg= Object:extend();
function haircnnseg:GetSegCls()
  local cnnsegcls=require"videodecet.mlseg" ;
  return cnnsegcls;
end
require "utility"
function haircnnseg:new()
  
local cnnsegcls = self:GetSegCls()
self.cnnsegment=cnnsegcls();
self.servicecallbacks = {};
self.serviceobjs={};
setmetatable(self.servicecallbacks, {__mode = "v"}) --弱引用 
setmetatable(self.serviceobjs, {__mode = "v"}) --弱引用 
self.cnnsegmark = false;
end

function haircnnseg:SetType(segType)
  self.segType = segType;
  self.cnnsegment:SetType(segType);
end


function haircnnseg:RegisterCnnSegJudgeFunc(obj,func)
  table.insert(self.servicecallbacks,func);
  table.insert(self.serviceobjs,obj);
end

function haircnnseg:Initialize(w,h)
  if(not self.cnnsegmark)
  then
    return;
  end
  if (self.cnnsegment.cnnsegInit == false) 
  then
     self.cnnsegment:InitCnnSeg(w, h);
  end
end


function haircnnseg:IsInitialize()
  return self.cnnsegment.cnnsegInit;
end

function haircnnseg:SetCnnSegMark(mark)
   self.cnnsegmark = mark;
   self.cnnsegment.cnnSegMark = mark;
end


function haircnnseg:GetSegmentMark(mark)
  
   if(self.cnnsegmark==nil)
   then
    return false;
   else
    return self.cnnsegmark;
   end
 
end

function haircnnseg:Update(ts,def)

  if(not self.cnnsegmark)
  then
    return;
  end
  self.ts = ts;
  self.def =def;
  self.cnnsegment:startNewUpdate();
end

function haircnnseg:OnResizeView(w,h)
  self.cnnsegment:OnResizeView(w,h);
end


function haircnnseg:RunSeg()
  
  if(not self.cnnsegmark)
  then
    return;
  end
  
  local len =#self.servicecallbacks;
  local res = false;
  for i=1,len do
    if(self.servicecallbacks[i] and self.serviceobjs[i] )
    then
     res =self.servicecallbacks[i](self.serviceobjs[i]);
    end
    if(res==true)
    then
      break;
    end
  end
  if(res==true)
  then
    self.cnnsegment:startNewUpdate();
    self:GetSegTextureAndBox();
  end
  
end

function haircnnseg:GetSegTextureAndBox()
  if(not self.cnnsegmark)
  then
    return nil;
  end
  
  if (self.cnnsegment.cnnsegInit == true) then
    local ts = self.ts;
    local def = self.def;
    local cnnsegtexture,boxarray = self.cnnsegment:Update(ts,def);
    return cnnsegtexture,boxarray;
  end
  
  return nil;
end

function haircnnseg:GetSegTexture()
  if(not self.cnnsegmark)
  then
    return nil;
  end
  if (self.cnnsegment.cnnsegInit == true) then
    local ts = self.ts;
    local def = self.def;
    local cnnsegtexture,boxarray = self.cnnsegment:Update(ts,def);
    return cnnsegtexture,boxarray;
  end
  
  return nil;
end

return haircnnseg;