local videodefined = require "videodecet.defined"
local facecnnseg= require "videodecet.facecnnseg"
local haircnnseg= require "videodecet.haircnnseg"
local facecnndetect = require "videodecet.facecnndetect"
local faceseg={};
local segobjs={};
--setmetatable(segobjs, {__mode = "kv"}) --弱引用 
function faceseg:RegisterAllSeg()


  local cnnseg = facecnnseg();  
  --self.cnnseg = cnnseg;
  cnnseg:SetType(videodefined.faceSegType.CNNSEG_FULL);
  faceseg:RegisterSeg(videodefined.faceSegType.CNNSEG_FULL,cnnseg);
  
  local cnnsegHair = haircnnseg();  
  cnnsegHair:SetType(videodefined.faceSegType.CNNSEG_FULL_HAIR);
  faceseg:RegisterSeg(videodefined.faceSegType.CNNSEG_FULL_HAIR,cnnsegHair);
 
  
  --注册瞳孔检测的库
  local detectService = facecnndetect();
  detectService:SetType(videodefined.detectType.IrisDetection);
  faceseg:RegisterSeg(videodefined.detectType.IrisDetection,detectService);
  
  local handService = facecnndetect();

  handService:SetType(videodefined.detectType.HandRecognition);
  faceseg:RegisterSeg(videodefined.detectType.HandRecognition,handService);



  --注册手势分类
  local handClassifyService = facecnndetect();
  handClassifyService:SetType(videodefined.detectType.HandClassify);
  faceseg:RegisterSeg(videodefined.detectType.HandClassify,handClassifyService);


  --注册人脸检测 FIXME(hhl) 需要保证人脸检测在最前
  local faceDetector = facecnndetect();
  faceDetector:SetType(videodefined.detectType.Face);
  faceseg:RegisterSeg(videodefined.detectType.Face, faceDetector);


end
function faceseg:Initialize(w,h)
  --local len =#segobjs;
  for _,value in pairs(segobjs) do
    if value ~= nil then
      local segMark = value:GetSegmentMark();
      local isInit = value:IsInitialize();
      if(segMark and (not isInit) )
      then
        value:Initialize(w,h);
      end
    end
  end
  --[[
  for i=1,len do
    local segMark = segobjs[i]:GetSegmentMark();
    local isInit = segobjs[i]:IsInitialize();
    if(segMark and (not isInit) )
    then
      segobjs[i]:Initialize(w,h);
    end
  end
  --]]
  
end

function faceseg:RegisterSeg(type,segobj)
  segobjs[type] = segobj;
end

function faceseg:UnRegisterSeg(type,obj)

end 


function faceseg:OnResizeView(w,h)
  for _,value in pairs(segobjs) do
    if value ~= nil then
      value:OnResizeView(w,h);
    end
  end
  
  --[[
  local len =#segobjs;
  for i=1,len do
      segobjs[i]:OnResizeView(w,h);
  end
  --]]
end


function faceseg:RunSegment()
   for _,value in pairs(segobjs) do
    if value ~= nil then
      local segMark = value:GetSegmentMark();
      local isInit = value:IsInitialize();
      if(segMark and  isInit )
      then
        value:RunSeg();
      end
    end
  end
  --[[
  local len =#segobjs;
  for i=1,len do
    local segMark = segobjs[i]:GetSegmentMark();
    local isInit = segobjs[i]:IsInitialize();
    if(segMark and  isInit )
    then
      segobjs[i]:RunSeg();
    end
  end
  ]]--
end

function faceseg:Update(ts,def)
  
  for _,value in pairs(segobjs) do
    if value ~= nil then
      local segMark = value:GetSegmentMark();
      local isInit = value:IsInitialize();
      -- 如果对应segobj需要检测并且已经初始化,那么标记新帧到来
      if(segMark and  isInit )
      then
        value:Update(ts,def);
      end
    end
  end
  --[[
  local len =#segobjs;
  for i=1,len do
    local segMark = segobjs[i]:GetSegmentMark();
    local isInit = segobjs[i]:IsInitialize();
    if(segMark and  isInit )
    then
      segobjs[i]:Update(ts,def);
    end
  end
  --]]
  
end

function faceseg:RegisterSegJudgeFunc(type,obj,func)
  
  local seg = segobjs[type];
  if(seg) then
    seg:RegisterCnnSegJudgeFunc(obj,func);
  else
    ERROR("[RegisterSegJudgeFunc] Seg No Found for "..tostring(type))
  end
  
end

function faceseg:GetSegmentMark()
  for _,value in pairs(segobjs) do
    if value ~= nil then
      local segMark = value:GetSegmentMark();
      if(segMark ) then
        return true;
      end
    end
  end
  return false;
  
  --[[
  local len =#segobjs;
  for i=1,len do
    local segMark = segobjs[i]:GetSegmentMark();
    if(segMark )
    then
      return true;
    end
  end
  return false;
  --]]
end

function faceseg:GetSegTexture(type)
  local seg = segobjs[type];
  if(seg)
  then
   return seg:GetSegTexture();
  end
  return nil;
end

function faceseg:GetSegKeypointArray(type)
  local seg = segobjs[type];
  if seg then
    return seg:GetSegKeypointArray();
  end
  return nil;
end

function faceseg:GetCount(type, datatype)
  local seg = segobjs[type];
  if seg then
    return seg:GetCount(datatype);
  else
    ERROR("[GetCount] seg is nil for type "..tostring(type))
  end
  return 0 ;
end

function faceseg:GetData(type, index, datatype)
  local seg = segobjs[type];
  if seg then
    return seg:GetData(index, datatype);
  else
    ERROR("[GetData] seg is nil for type "..tostring(type))
  end
  return nil;
end



--头发
function faceseg:GetSegTextureAndBox(type)
  local seg = segobjs[type];
  if seg then
    return seg:GetSegTextureAndBox();
  end
  return nil;
end

function faceseg:SetSegMark(type,mark)
  if( segobjs[type])
  then
    segobjs[type]:SetCnnSegMark(mark);
  else
    ERROR("[SetSegMark] Seg No Found for "..tostring(type))
  end
end


return faceseg;
