local AutoTensor = require "torchutility.autotensor"
local Operator = require "torchutility.operator"
local venusjson = require "venusjson"
local venuscore = require "venuscore"
local torch = require "torch"
local Multiply = require "torchutility.multiply"
local Sequencialdot = require "torchutility.sequencialdot"

local ToPoseList = Operator:extend();

function ToPoseList:new(matlist,parentpair)
  
  ToPoseList.super.new(self,matlist);
  self.parentpair = parentpair;
  
end

function ToPoseList:V(matlist)
  ToPoseList.super.V(self,matlist);
  
end


function ToPoseList:Caculate(matlist)
  
  self.autolist = {};
  local tensorlist = matlist:clone();
  for i=1,tensorlist:size()[1] do
    self.autolist[i] = AutoTensor();
    self.autolist[i]:VFromTorch(tensorlist[i]);
  end
  --[[
  for childidx,parentidx in ipairs(self.parentpair) do
    if parentidx~=0 then
      matlist[childidx] = matlist[parentidx]*matlist[childidx];
    end
  end
]]--
  self.autoretlist = {};
  for childidx,parentidx in ipairs(self.parentpair) do
    local parentlist = {};
    self:GetParentList(childidx,parentlist);
    
    local parentmatlist = {}
    for i=1,#parentlist do
      --parentmatlist[i] = ;
      table.insert(parentmatlist,self.autolist[parentlist[i]]);
    end
    self.autoretlist[childidx] = Sequencialdot(table.unpack(parentmatlist));
  end
    
  local points = torch.Tensor(#self.autoretlist,3);
  for i=1, #self.autoretlist do
    points[i][1] = self.autoretlist[i]:R()[1][4];
    points[i][2] = self.autoretlist[i]:R()[2][4];
    points[i][3] = self.autoretlist[i]:R()[3][4];
  end
  return points;
end

function ToPoseList:GetParentList(index,parentlist)
  table.insert(parentlist,index);
  if self.parentpair[index]~=nil and self.parentpair[index]~=0 then
    self:GetParentList(self.parentpair[index],parentlist);
  end
  
end

function ToPoseList:Derivative(pr)
  if self:HasParamForD(1,pr) then
    local matcount = pr:size()[1];
    local result = torch.Tensor(3*matcount,16*matcount):fill(0);
    for i=1,matcount do
      self:DerOne(pr[i],i,(i-1)*3,(i-1)*16,result);
    end
    local pcdr = self:GetPCMulDer(pr);
    result = result*pcdr;
    return result;
  else
    assert(false);
  end
end



function ToPoseList:GetPCMulDer(pr)
  local matcount = pr:size()[1];
  local result = torch.Tensor(matcount*16,matcount*16):fill(0);
  
  for i=1,#self.autoretlist do
    
    local parentlist = {};
    self:GetParentList(i,parentlist);
    for j = 1,#parentlist do
      local mat16 = self.autoretlist[i]:PartialD(j);
      --local xidx = parentlist[j]-1;
      --local yidx = i-1;
      local yidx = parentlist[j]-1;
      local xidx = i-1;
      local xb = xidx*16+1;
      local yb = yidx*16+1;
      --local p = result[{{xb, xb+15}, {yb, yb+15}}];
      result[{{xb, xb+15}, {yb, yb+15}}] = mat16;
      --local p1 = result[{{xb, xb+15}, {yb, yb+15}}];
      --self:MatCopy(mat16,result,xidx*16,yidx*16);
    end
    
  end
  
  return result;
end

function ToPoseList:MatCopy(from,to,starti,startj)
  
  for i=1,from:size()[1] do
    for j=1,from:size()[2] do
      to[starti+i][startj+j] = from[i][j];
    end
  end
  
end

function ToPoseList:DerOne(pr,index,starti,startj,fillmat)
  local result = torch.Tensor(3,16):fill(0);
  result[1][4] = 1;
  result[2][8] = 1;
  result[3][12] = 1;
  
  for i=1,3 do
    for j=1,16 do
      fillmat[i+starti][j+startj]=result[i][j];
    end
  end
  
  return result;
end


return ToPoseList;