local venusjson = require "venusjson"
local venuscore = require "venuscore"
local object = require "classic"
local torch = require "torch"
local AutoTensor = require "torchutility.autotensor"
local Operator = require "torchutility.operator"


local Substract = Operator:extend();

function Substract:new(...)
    Substract.super.new(self,...);
end

function Substract:Caculate( param1,param2 )
    return torch.csub(param1, param2);
end

function Substract:Derivative(param)
    if self:HasParamForD(1,param) then
        return 1;
    elseif self:HasParamForD(2,param) then
        return -1;
    else
        assert(false);
    end
end

function AutoTensor.__sub(no1, no2)
    return Substract(no1,no2);
end

return Substract;