--只能做一条链的情况，有树的情况就用不成了。

local venusjson = require "venusjson"
local venuscore = require "venuscore"
local object = require "classic"
local torch = require "torch"
local AutoTensor = require "torchutility.autotensor"
local Operator = AutoTensor:extend();


function Operator:new(...)
  self.resultcache = nil;
  self.paramcache = nil;
  self.isop = true;
  self:V(...);
end

function Operator:V(...)
  self.paramcache = {...}
  self.changed = true
  --self:R();
end

function Operator:R()
  if self:IsChanged() == true then
    local paramvalue = self:ValueOnlyList(self.paramcache);
    self.resultcache = self:Caculate(table.unpack(paramvalue));
    self.changed = false;
  end
  return self.resultcache;
end

function Operator:D2(...)
  self:R();
  local param = self:FindDParam(...);
  local usrparam = self:ValueOnlyList(param)
  local j = self:Derivative(table.unpack(usrparam));
 
  local nextj = {};
  for i=1,#param do
    table.insert( nextj, param[i]:D2(...) );
  end
  if #nextj == 1 then
    j = j*nextj[1];
  elseif #nextj ~= 1 then
    assert(false);
  end
  return j;
end

function Operator:Caculate(...)

end

function Operator:Derivative(...)

end

function Operator:HasParamForD(index,...)
  local testparam = {...};
  for i=1,#testparam do
    if self.paramcache[index]:R():equal(testparam[i]) then
      return true;
    end
  end
  return false;
end

function Operator:FindDParam(...)
  local paramcache = {}
  for i=1,#self.paramcache do
    local isparam = self.paramcache[i]:HaveParam(true,...);
    if isparam==true then
      table.insert(paramcache,self.paramcache[i]);
    end
  end
  return paramcache;
end

function Operator:HaveParam(r,...)
  local params = {...}
  local paramhave = true;
  
  for i=1,#params do
    local have = false;
    for j=1,#self.paramcache do
      if self.paramcache[j]== params[i] then
        have = true;
        break;
      end
    end
    if have== false then
      paramhave = false;
      break;
    end
  end
  
  if r==true and paramhave == false then 
    for i=1,#self.paramcache do
      local subhave = self.paramcache[i]:HaveParam(r,...);
      if subhave==true then
        paramhave = true;
        break;
      end
    end
  end
  
  return paramhave;
end


function Operator:IsChanged()
  if self.changed then
    return true;
  end
  for i=1,#self.paramcache do
    if self.paramcache[i]:IsChanged()==true then
      return true;
    end
  end
  return false;
end


function Operator:ValueOnlyList(list)
  local paramvalue = {};
  for i=1,#list do
      paramvalue[i] = list[i]:R();
  end
  return paramvalue;
end

--[[
function Operator:FindOperator(...)
  local paramcache = {}
  for i=1,#self.paramcache do
    local isparam = self.paramcache[i]:HaveParam(false,...);
    if isparam==true then
      return self.paramcache[i];
    end
  end
  
  for i=1,#self.paramcache do
    local isparam = self.paramcache[i]:FindOperator(...);
    if isparam~=nil then
      return isparam;
    end
  end
  return;
end]]


return Operator;