local textureloader = require "apolloutility.asynctexture.textureloader"
local asynctexture = require "apolloutility.asynctexture.asynctexture"
local GestureAnimation = require "gesturemagic.gestureanimation"
local renderqueue = require "apolloutility.renderqueue"
local pbrlighting = require "apolloutility.pbrlighting"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local facecute = require "facecute"
local likeapp = require "likeapp"
local faceinfo = require "videodecet.faceinfo";

--local facelifting = require "facecute.facechange.facelifting"
--local denoise=require "facecute.facechange.denoise"
local denoise = require "imageeffect.denoise"
require "utility"

--local verbo = require("jit.v")
--verbo.start()

--暂时关闭JIT防止JIT失败导致的效率下降
if _PLATFORM_ANDROID or _PROFILER then
  jit.off();
  jit.flush();
  LOG("turn off jit")
end


local main = {}

g_callbackhandle = main;

function main:Timespan()
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;

  self.cumtime = self.cumtime + def;
  self.fps = self.fps + 1;

  if self.cumtime > 5 then
    local fps = self.fps / self.cumtime;
    self.fps = 0;
    self.cumtime = 0;
    LOG("logic fps "..fps);
  end
  return def;
end

function main:OnResizeView(x,y,w,h)
  facecute:OnResizeView(w,h);
end

--size,video表示视屏纹理尺寸和id,size为table
function main:Initialize()
  _COROUTINES_ON();
  self.isloaded = false;
  if _PLATFORM_IOS then
    collectgarbage("setpause",100);
    collectgarbage("setstepmul",2000);  
  end  
  --初始化服务回掉注册体系
  self.servicecallbacks = {}
  textureloader:Initialize();
	--[[
  pbrlighting:Initialize();--对PBR材质中的贴图的slot进行初始化
  --对整个场景的cubemap进行声明
  apolloengine.ShaderEntity.SKY_BOX = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"SKY_BOX");
  local skybox = apolloengine.TextureEntity();

  skybox:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TT_TEXTURECUBE_FRONT,   "docs:skybox/front.jpg"));
  skybox:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TT_TEXTURECUBE_BACK,    "docs:skybox/back.jpg"));
  skybox:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TT_TEXTURECUBE_TOP,     "docs:skybox/top.jpg"));
  skybox:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TT_TEXTURECUBE_BOTTOM,  "docs:skybox/bottom.jpg"));
  skybox:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TT_TEXTURECUBE_LEFT,    "docs:skybox/left.jpg"));
  skybox:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TT_TEXTURECUBE_RIGHT,   "docs:skybox/right.jpg"));
  skybox:CreateResource();
  apolloengine.IMaterialSystem:SetGlobalParameter(apolloengine.ShaderEntity.SKY_BOX,skybox);
  ]]--
  self:_CreateCameras(
    0.1, 10,
    mathfunction.vector3(0,0,0),
		mathfunction.vector3(0,0,-1),
		mathfunction.vector3(0,1,0));
  renderqueue:Initialize(self.maincamera);
  --videodecet:Initialize("comm:documents/ffmpeg/","output%04d.jpg", "point.txt");  
  videodecet:Initialize("comm:documents/noise/","output%04d.png", "point.txt");  
  facecute:Initialize(self.maincamera);

  if _PLATFORM_WINDOWS then
    --self:FacecuteLoadResource("docs:facecute/chicaopeng_pot/chicaopeng.json");
    --self:FacecuteLoadResource("docs:facecute/chicaopeng/chicaopeng.json");
    --self:FacecuteLoadResource("docs:facecute/snake/snake.json");
    self:FacecuteLoadResource("docs:facecute/football/football.json");
    --self:FacecuteLoadResource("docs:facecute/zhai/zhai.json");
    --self:FacecuteLoadResource("docs:facecute/shemenB/shemenB.json");
    --self:FacecuteLoadResource("docs:facecute/koubikong/koubikong.json");
    --self:FacecuteLoadResource("docs:facecute/dedormationccq/dedormationccq.json");
    --self:FacecuteLoadResource("docs:facecute/Captain/Captain.json");
    --self:FacecuteLoadResource("docs:facecute/kenan/kenan.json");
    --self:FacecuteLoadResource("docs:facecute/mafazC/mafazC.json");
    --self:FacecuteLoadResource("docs:facecute/wushi3/wushi3.json");
    --self:FacecuteLoadResource("docs:facecute/Jianjiaoji/Jianjiaoji.json");
    --self:FacecuteLoadResource("docs:facecute/she/she.json");
  else
    asynctexture.SetMaxfps(15);
  end

  denoise:Initialize();
  --facelifting:initialize();
  
  if (_PROFILER or _DEBUG) and _PLATFORM_WINDOWS then
    --设置同步更新事件，这个事件会阻塞渲染线程，可以在这个线程中做资源读取等操作
    --但是这个事件也会大大降低帧率
    LOG("AddSynchronizeUpdateCallback");
    apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "Update");
  else
    LOG("AddAsynchronousUpdateCallback");
    apolloengine.Framework:AddAsynchronousUpdateCallback(self._Agent, "Update");
  end
  
   apolloengine.Framework:AddTouchCallback(self._Agent, "OnTouch");
 
  --设置定时器
  --venuscore.ITimerSystem:RegisterTimer(self._Agent, 1/30, "Ontime");
  self.running = false;
   
  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  self.cumtime = 0;
  self.fps = 0;  
  LOG("initialize done");
  _PROFILER_START();
  _COROUTINES_OFF();
  return true;
end

function main:_CreateCameras(near, far, pos, lookat, up)
  self.maincamera = apollonode.CameraNode();--新建摄像机
  --self.maincamera:CreatePerspectiveProjection(near, far);
  self.maincamera:CreateRealCameraProjection(near, far);--设置摄像机
  self.maincamera:LookAt(pos, lookat, up);
  self.maincamera:Recalculate();--手动更新矩阵
  self.maincamera:Activate();--激活主摄像机
end

--设置摄像机FBO
function main:AttachRenderTarget(fbo, texture)
  LOG("platform android, fbo:"..fbo);
  self.rendertarget = apolloengine.RenderTargetEntity();--创建一个FBO
  self.rendertarget:PushMetadata(--设置FBO格式
  apolloengine.RenderTargetResourceMetadata(
    apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
    mathfunction.vector4(0.0,1.0,1.0,1),--清屏颜色
    apolloengine.Framework:GetResolution(),--分辨率
    fbo));
  self.outputtexture = self.rendertarget:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
  self.outputtexture:PushMetadata(--创建纹理
		apolloengine.TextureResourceMetadata(
        apolloengine.Framework:GetResolution(),
				texture));
  self.rendertarget:CreateResource();
  self.maincamera:AttachRenderTarget(self.rendertarget);    
end


--设置摄像机采集图片尺寸和id
function main:SetVideoTexture(size, video)
  videodecet:SetTexture(size, video)
end

--加载换脸配置表
function main:FacecuteLoadResource(path)
  _COROUTINES_ON();
  self.isloaded = facecute:LoadConfig(path);
  collectgarbage();
  _COROUTINES_OFF();
  return self.isloaded;
end
--释放换脸资源
function main:FacecuteUnloadResource()
  _COROUTINES_ON();
  self.isloaded = false;
  facecute:ReleaseResource();
  renderqueue:Clear();
  collectgarbage();
  _COROUTINES_OFF();
  return true;
end


--以下为固定接口
function main:RegisterCallback(func)
  table.insert(self.servicecallbacks, func);
  return self._Agent, #self.servicecallbacks;
end

function main:CallbackFunction(index, ...)
  _COROUTINES_ON();
  local func = self.servicecallbacks[index];
  local res = func(...);
  _COROUTINES_OFF();
  return res;
end


function main:_Running()
  _COROUTINES_ON();
  if self.isloaded 
  then--and likeapp.AI:RefreshedRawarray() then
    local def = self:Timespan();
    
    videodecet:Update(def);
	
    
	
    local now = venuscore.ITimerSystem:GetTimevalue() * 2;
    local level = now % 5;
   
    --facelifting:Update(10);
    
    facecute:Update(def,self.maincamera);
    


    _PROFILER_UPDATE();
  end
  _COROUTINES_OFF();
end

function main:Ontime()
  self:_Running();
end

function main:Update()
  self:_Running();
end

function main:Abort()
  apolloengine.Framework:RemoveAsynchronousUpdateCallback(self._Agent, "Update");
  venuscore.IApplication:Abort();
end

function main:OnTouch(touchinfo)
  _COROUTINES_ON();
  local c = touchinfo:GetPointCount();
  for i=1, c do
    local tt = touchinfo:GetTouchType(i);
    if apolloengine.TouchInfo.TT_PRESS == tt 
      then
      denoise:Switch();
    end
  end
  _COROUTINES_OFF();
end


return main;
