local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"



local renderqueue = {}
local SEQ_INTERVAL = 10

function renderqueue:_CameraFunction(maincamera)
  self._cameras = {};
  self._rendertargets = {};
  self._textures = {};
  local near = maincamera:GetNear();
  local far = maincamera:GetFar();
  local pos = maincamera:GetWorldPosition();
  local lookat = pos + maincamera:GetForward();
  local up = maincamera:GetUp();
  local swaps = 
  {
    apolloengine.RenderTargetEntity.ST_SWAP_E,--标记作用，主要用于底层资源共享
    apolloengine.RenderTargetEntity.ST_SWAP_F
  }
  local index = 1;
  local sequence = maincamera:GetSequence() - defined.queue_camera_count;
  local color = mathfunction.Color(0.5,0.5,0.5,1);
  local reso = apolloengine.Framework:GetResolution()
  LOG("SUNTYLOG: renderqueue:_CameraFunction " .. string.format("reso=%dx%d", reso:x(), reso:y()))

  return function (inputswap)
    local camera = apollonode.CameraNode();--新建摄像机
    camera:CreateRealCameraProjection(near, far);--设置摄像机
    camera:LookAt(pos, lookat, up);
    camera:SetSequence(sequence * SEQ_INTERVAL);
    sequence = sequence + 1;
    local swap = inputswap;--apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE;
    if not swap then
      swap = swaps[index];
      index = index + 1 > #swaps and 1 or index + 1;
    end    
    local rt = apolloengine.RenderTargetEntity();--创建一个FBO
    rt:PushMetadata(--设置FBO格式
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        swap,--标记作用，主要用于底层资源共享
        color,--清屏颜色
        apolloengine.Framework:GetViewport(),
        apolloengine.Framework:GetResolution()));--分辨率
    rt:MakeBufferAttachment(apolloengine.RenderTargetEntity.TA_DEPTH_STENCIL);--增加color0纹理
    local tex = rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
    tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        swap,--此处的纹理swap和尺寸必须和rt的相同不然将导致未定义的错误
        apolloengine.Framework:GetResolution()));
    rt:CreateResource();
    camera:AttachRenderTarget(rt);
    table.insert(self._cameras, camera);
    table.insert(self._rendertargets, rt);
    table.insert(self._textures, tex);
    return camera, rt, tex;
  end  
end

function renderqueue:Initialize(maincamera)

  self.CAMERA_LAYER_FIRST = 1 - defined.camera_zero
  self.CAMERA_LAYER_LAST = defined.queue_camera_count + 1 - defined.camera_zero
  self.CAMERA_LAYER_ZERO = 0

  self.textures = {}
  self.sequences = {}

  self.objs = {};

  self.renders = {}
  self.cameras = {}
  self.activates = {}
  self.lastActivates = {}
  self.linksMap = {}
  self.lastLinksMap = {}

  local createCamera = self:_CameraFunction(maincamera);

  --创建queue摄像机
  for i = 1, defined.queue_camera_count do
    local camera, rt, tex = createCamera()
    table.insert(self.textures, tex)
    table.insert(self.cameras, camera)
    table.insert(self.sequences, camera:GetSequence())
    table.insert(self.activates, false)
    table.insert(self.lastActivates, false)
  end

  table.insert(self.cameras, maincamera)
  table.insert(self.sequences, maincamera:GetSequence())
  table.insert(self.activates, false)
  table.insert(self.lastActivates, false)


  for i = 1, defined.queue_camera_count do
    local render = apollonode.QuadNode()
    -- Since the first camera attaches input render
    -- all the sequence move afterward
    local seq = self:_GetSequence(i + 1 - defined.camera_zero);
    render:CreateResource(defined.blit_material_path, true)
    render:SetSequence(seq)
    render:SetCull(false)
    table.insert(self.renders, render)
  end

  for i = self.CAMERA_LAYER_FIRST + 1, self.CAMERA_LAYER_LAST do
    self.linksMap[i] = self.CAMERA_LAYER_FIRST - 1
    self.lastLinksMap[i] = self.CAMERA_LAYER_FIRST - 1
  end
  
  self.facemaxz = -2000;

  self:Update()

end

function renderqueue:Prev(node)
  node:SetSequence(self:_GetSequence(self.CAMERA_LAYER_FIRST))
end

function renderqueue:Before(node)
  node:SetSequence(self:_GetSequence(self.CAMERA_LAYER_ZERO))
end

function renderqueue:After(node)
  node:SetSequence(self:_GetSequence(self.CAMERA_LAYER_LAST))
end


function renderqueue:Queue(layer, node)
  --LOG("renderqueue:Queue " .. tostring(layer))
  if layer < self.CAMERA_LAYER_FIRST or layer > self.CAMERA_LAYER_LAST then
    error("out of range")
    return
  end
  node:SetSequence(self:_GetSequence(layer))
  self:_Activate(layer)
  self:Update()
end

function renderqueue:Activate(layer)
  if layer < self.CAMERA_LAYER_FIRST or layer > self.CAMERA_LAYER_LAST then
    error("out of range")
    return
  end
  self:_Activate(layer)
  self:Update()
end

function renderqueue:Deactivate(layer)
  if layer < self.CAMERA_LAYER_FIRST or layer > self.CAMERA_LAYER_LAST then
    error("out of range")
    return
  end
  self:_Deactivate(layer)
  self:Update()
end

function renderqueue:GetTexture(layer)
  if layer < self.CAMERA_LAYER_FIRST or layer >= self.CAMERA_LAYER_LAST then
    error("out of range")
    return nil
  end
  return self:_GetTexture(layer)
end

function renderqueue:GetLink(layer)
  if layer <= self.CAMERA_LAYER_FIRST or layer > self.CAMERA_LAYER_LAST then
    error("out of range")
    return nil
  end
  return self.linksMap[layer]
end

--得到对应layer的纹理,0代表before
function renderqueue:_GetSequence(layer)
  return self.sequences[layer + defined.camera_zero]
end

function renderqueue:_GetTexture(layer)
  return self.textures[layer + defined.camera_zero]
end

function renderqueue:_GetRender(layer)
  return self.renders[layer + defined.camera_zero - 1]
end

function renderqueue:GetCamera(layer)
  return self.cameras[layer + defined.camera_zero]
end


function renderqueue:Clear(from, to)--每次更换场景的时候需要将旧的队列清除

  LOG("renderqueue:Clear " .. tostring(from) .. " " .. tostring(to))

  local activatesLen = #self.activates

  if from == nil then
    from = self.CAMERA_LAYER_FIRST
  end

  if to == nil then
    to = self.CAMERA_LAYER_LAST
  end

  for i = from, to do
    self.activates[i + defined.camera_zero] = false
  end

  self:Update()

end



function renderqueue:_Activate(layer)
  self.activates[layer + defined.camera_zero] = true
end

function renderqueue:_Deactivate(layer)
  self.activates[layer + defined.camera_zero] = false
end

function renderqueue:_ConcatSwap()

  local concatActives = {}
  local activatesLen = #self.activates
  local lastActiveLayer = nil
  for i = 1, activatesLen do
    local layer = i - defined.camera_zero
    local active = self.activates[i]
    table.insert(concatActives, active)
    if active then
      if lastActiveLayer ~= nil then
        local diff = layer - lastActiveLayer
        if diff % 2 == 0 then
          concatActives[i - 1] = true
        end
      end
      lastActiveLayer = layer
    end
  end
  return concatActives
end

function renderqueue:Update()

  self:_Activate(self.CAMERA_LAYER_FIRST)
  self:_Activate(self.CAMERA_LAYER_ZERO)
  self:_Activate(self.CAMERA_LAYER_LAST)

  local activates = self:_ConcatSwap()

  local links = {}

  local activatesLen = #activates

  for i = 1, activatesLen do
    local layer = i - defined.camera_zero
    local camera = self:GetCamera(layer)
    local active = activates[i]
    if self.lastActivates[i] ~= active then
      if active then
        camera:Activate()
      else
        camera:Deactivate()
      end
    end
    if active then
      table.insert(links, layer)
    end
    self.lastActivates[i] = active
  end

  local linksLen = #links

  for i = 2, linksLen do
    local layer = links[i]
    local prevLayer = links[i - 1]
    self.linksMap[layer] = prevLayer
    if self.lastLinksMap[layer] ~= prevLayer and prevLayer >= self.CAMERA_LAYER_FIRST then
      local render = self:_GetRender(layer)
      local prevTex = self:_GetTexture(prevLayer)
      render:SetParameter(
              apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
              prevTex)
    end
    self.lastLinksMap[layer] = prevLayer
  end

  local strLinks = "Links: "
  local strSeqs = "Seqs: "
  for i = 1, linksLen do
    strLinks = strLinks .. " " .. tostring(links[i])
    strSeqs = strSeqs .. " " .. tostring(self:_GetSequence(links[i]))
  end
  LOG(strLinks)
  LOG(strSeqs)

end

function renderqueue:AddObjs(obj)
  table.insert(self.objs, obj);
end

local function cmp(a,b)
   return (a:GetRenderOrder()) < (b:GetRenderOrder());
end

function renderqueue:UpdateObjQueue()
  
  table.sort(self.objs, cmp);

  local layer = self.CAMERA_LAYER_ZERO
  local lastRenderOrder = nil
  local len = #self.objs;

  for i = 1, len do

    local obj = self.objs[i]

    local currRenderOrder = obj:GetRenderOrder()

    if lastRenderOrder ~= nil and currRenderOrder - lastRenderOrder > 0.000001 then
      layer = layer + 1
      layer = math.min(layer, self.CAMERA_LAYER_LAST)
    end

    lastRenderOrder = currRenderOrder

    self:Queue(layer, obj)

    obj.renderLayer = layer

  end

  self.objs = {}

end

function renderqueue:SetMaxFaceOrder(maxz)
  self.facemaxz = maxz;
end

function renderqueue:GetMaxFaceOrder()
  return self.facemaxz;
end


return renderqueue;
