require "utility"
local ae = require "apolloengine"
local mf = require "mathfunction"

local tunes = {}

local F = 1.0 / 255.0

tunes.renderObject = nil
tunes.queue = 100

tunes.colorDark   = mf.vector3(255.0, 0.0, 0.0)
tunes.colorMiddle = mf.vector3(0.0, 255.0, 0.0)
tunes.colorLight  = mf.vector3(0.0, 0.0, 255.0)
tunes.blendFactor = mf.vector1(100.0)

tunes.lastColorDark   = nil
tunes.lastColorMiddle = nil
tunes.lastColorLight  = nil
tunes.lastBlendFactor = nil

tunes.TUNES_COLOR_DARK = tunes.colorDark
tunes.TUNES_COLOR_MIDDLE = tunes.colorMiddle
tunes.TUNES_COLOR_LIGHT = tunes.colorLight
tunes.TUNES_ORIGIN_PERCENTAGE = tunes.blendFactor

tunes.lastTUNES_COLOR_DARK = nil
tunes.lastTUNES_COLOR_MIDDLE = nil
tunes.lastTUNES_COLOR_LIGHT = nil
tunes.lastTUNES_ORIGIN_PERCENTAGE = nil

function tunes:Initialize(host, size)

  self.COLOR_DARK = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "COLOR_DARK");

  self.COLOR_MIDDLE = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "COLOR_MIDDLE");

  self.COLOR_LIGHT = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "COLOR_LIGHT");

  self.BLEND_FACTOR = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "BLEND_FACTOR");

  self.renderObject = host:CreateRenderObject("comm:documents/material/tunes.material")

  self:UpdateParameters()

  return self.queue
end

function tunes:Resizeview(size)

end

function tunes:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget()
  Output:ClearBuffer(ae.RenderTargetEntity.CF_COLOR)

  self.renderObject:SetParameter(
          ae.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment(ae.RenderTargetEntity.TA_COLOR_0));

  self:UpdateParameters()

  self.renderObject:Draw(pipeline)
end

function tunes:UpdateParameters()
  if self.colorDark ~= self.lastColorDark then
    self.renderObject:SetParameter(self.COLOR_DARK,   self.colorDark * F)
    self.lastColorDark = self.colorDark
  end
  if self.colorMiddle ~= self.lastColorMiddle then
    self.renderObject:SetParameter(self.COLOR_MIDDLE, self.colorMiddle * F)
    self.lastColorMiddle = self.colorMiddle
  end
  if self.colorLight ~= self.lastColorLight then
    self.renderObject:SetParameter(self.COLOR_LIGHT,  self.colorLight * F)
    self.lastColorLight = self.colorLight
  end
  if self.blendFactor ~= self.lastBlendFactor then
    self.renderObject:SetParameter(self.BLEND_FACTOR, mf.vector1(self.blendFactor:x() * 0.01))
    self.lastBlendFactor = self.blendFactor
  end
  if self.TUNES_COLOR_DARK ~= self.lastTUNES_COLOR_DARK then
    self.renderObject:SetParameter(self.COLOR_DARK,   self.TUNES_COLOR_DARK * F)
    self.lastTUNES_COLOR_DARK = self.TUNES_COLOR_DARK
  end
  if self.TUNES_COLOR_MIDDLE ~= self.lastTUNES_COLOR_MIDDLE then
    self.renderObject:SetParameter(self.COLOR_MIDDLE, self.TUNES_COLOR_MIDDLE * F)
    self.lastTUNES_COLOR_MIDDLE = self.TUNES_COLOR_MIDDLE
  end
  if self.TUNES_COLOR_LIGHT ~= self.lastTUNES_COLOR_LIGHT then
    self.renderObject:SetParameter(self.COLOR_LIGHT,  self.TUNES_COLOR_LIGHT * F)
    self.lastTUNES_COLOR_LIGHT = self.TUNES_COLOR_LIGHT
  end
  if self.TUNES_ORIGIN_PERCENTAGE ~= self.lastTUNES_ORIGIN_PERCENTAGE then
    self.renderObject:SetParameter(self.BLEND_FACTOR, mf.vector1(self.TUNES_ORIGIN_PERCENTAGE:x() * 0.01))
    self.lastTUNES_ORIGIN_PERCENTAGE = self.TUNES_ORIGIN_PERCENTAGE
  end
end

return tunes;