local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
require "utility"
local shine= {}
shine.Motion = 0;
shine.SeperateBlurs = {};
shine.VolumnLight = 0;
shine.Rt1 = 0;
shine.Rt2 = 0;
shine.BlurCount = 3;
shine.Queue = 100;

function shine:Initialize(host, size)  
  self.CUR_FRAME_TEXTURE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "CUR_FRAME_TEXTURE");
  self.PRE_FRAME_TEXTURE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "PRE_FRAME_TEXTURE");
  self.MOTION_TEXTURE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "MOTION_TEXTURE");
  self.RADIUS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "RADIUS");      
  self.UNIFORM_OFFSET = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_OFFSET");      
  self.FRAME_TEXTURE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "FRAME_TEXTURE");      
  self.BRIGHT_TEXTURE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "BRIGHT_TEXTURE");    
  self.UNIFORM_LIGHT_COLOR = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_LIGHT_COLOR");  
  self.SAMPLES = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "SAMPLES");      
  self.STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "STEP");      
  
  self.Motion = host:CreateRenderObject( "comm:documents/material/shinemotion.material" );
  
  local blur_radius = 3.0;
  local blur1 = host:CreateRenderObject( "comm:documents/material/shineseperateblur.material" );
  blur1:SetParameter(self.RADIUS, mathfunction.vector1(blur_radius));
  local m = 1.0 / size:x();
  local n = 1.0 / size:y();

  blur1:SetParameter(self.UNIFORM_OFFSET, mathfunction.vector2(1.0 / size:x(), 0.0));
  table.insert(self.SeperateBlurs, blur1);
  
  local blur2 = host:CreateRenderObject( "comm:documents/material/shineseperateblur.material" );
  blur2:SetParameter(self.RADIUS, mathfunction.vector1(blur_radius));
  blur2:SetParameter(self.UNIFORM_OFFSET, mathfunction.vector2(0.0, 1.0 / size:y()));
  table.insert(self.SeperateBlurs, blur2);

  self.VolumnLight = host:CreateRenderObject( "comm:documents/material/shinevolumnlight.material" );
  
  self.Rt1 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size);
  self.Rt2 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, size);
  
  return self.Queue;
end

function shine:Resizeview(size)
    self.SeperateBlurs[1]:SetParameter(self.UNIFORM_OFFSET, mathfunction.vector2(1.0 / size:x(), 0.0));
    self.SeperateBlurs[2]:SetParameter(self.UNIFORM_OFFSET, mathfunction.vector2(0.0, 1.0 / size:y()));
end

function shine:Process(pipeline, Original, Scene, Output)

  self.Rt1:PushRenderTarget();
  self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Motion:Draw(pipeline);

  for i = 1,self.BlurCount do
    self.Rt2:PushRenderTarget();
    self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    self.SeperateBlurs[1]:SetParameter(self.MOTION_TEXTURE,
        self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );      
    self.SeperateBlurs[1]:Draw(pipeline);
    
    self.Rt1:PushRenderTarget();
    self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    self.SeperateBlurs[2]:SetParameter(self.MOTION_TEXTURE,
        self.Rt2:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
    self.SeperateBlurs[2]:Draw(pipeline);
  end

  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.VolumnLight:SetParameter(self.BRIGHT_TEXTURE,
        self.Rt1:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
  self.VolumnLight:Draw(pipeline);

end

return shine;