require "utility"
local ae = require "apolloengine"
local vc = require "venuscore"
local mf = require "mathfunction"

local obj = {}

function obj:Initialize(host, size)

    self.order = 100

    self.renderObject = host:CreateRenderObject("comm:documents/material/identity.material")

    return self.order
end

function obj:Resizeview(size)
end

function obj:Process(pipeline, Original, Scene, Output)

    local colorClear = ae.RenderTargetEntity.CF_COLOR
    local color0 = ae.RenderTargetEntity.TA_COLOR_0

    Output:PushRenderTarget()
    Output:ClearBuffer(colorClear)
    self.renderObject:SetParameter(
            ae.ShaderEntity.TEXTURE_DIFFUSE,
            Original:GetAttachment(color0))
    self.renderObject:Draw(pipeline)

    Original:PushRenderTarget()
    Original:ClearBuffer(colorClear)
    self.renderObject:SetParameter(
            ae.ShaderEntity.TEXTURE_DIFFUSE,
            Scene:GetAttachment(color0))
    self.renderObject:Draw(pipeline)
end

return obj