local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local displace = {}
displace.Dn = 0;
displace.Queue = 100;


function displace:Initialize(host, size)  
  apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"FRAME_SIZE");
  apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"CUR_FRAME_ID");
  apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"INTERVAL"); 
  apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"DIRECTION"); 
  apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"ROW_FRAME_NUM_PER_TEX"); 
  apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"COL_FRAME_NUM_PER_TEX"); 
  apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"TOTAL_PERIOD");  
  apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"HISTORICAL_FRAME1");  
  apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"HISTORICAL_FRAME2");  
  apolloengine.IMaterialSystem:NewParameterSlot(
     apolloengine.ShaderEntity.UNIFORM,"HISTORICAL_FRAME3");  
  apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"HISTORICAL_FRAME4");  
  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/displace.material");  
  self.Do = host:CreateRenderObject(pathout);
  return self.Queue;
end

function displace:Resizeview(size)
end

function displace:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  --[[self.Do:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );]]--
	self.Do:Draw(pipeline);
end

return displace;