require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"

local normal = {}

normal.renderObject = nil;
normal.queue = 100;
normal.blendtex = nil;

function normal:Initialize(host, size)

  self.TEXTURE_BLEND = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_BLEND");
  self.renderObject = host:CreateRenderObject("comm:documents/material/blend_normal.material");

  return self.queue;
end

function normal:Resizeview(size)

end

function normal:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.renderObject:SetParameter(
          apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
        
  self:UpdateParameters();
  
  self.renderObject:Draw(pipeline);
end

function normal:UpdateParameters()
  if self.blendtex ~= nil then
    self.renderObject:SetParameter(self.TEXTURE_BLEND, self.blendtex);
  end
end

return normal;