require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"

local add = {}

add.renderObject = nil;
add.queue = 100;
add.blendtex = nil;

function add:Initialize(host, size)

  self.TEXTURE_BLEND = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_BLEND");
  self.renderObject = host:CreateRenderObject("comm:documents/material/blend_add.material");


  return self.queue;
end

function add:Resizeview(size)

end

function add:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.renderObject:SetParameter(
          apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
        
  self:UpdateParameters();
  
  self.renderObject:Draw(pipeline);
end

function add:UpdateParameters()
  if self.blendtex ~= nil then
    self.renderObject:SetParameter(self.TEXTURE_BLEND, self.blendtex);
  end
end

return add;