local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local NodeUtility = {}


function NodeUtility.CreateQuadNode(materialpath, diffuseimage)
  local node = apolloengine.Node();
  local trans = apolloengine.TransformComponent();
  local render = apolloengine.RenderComponent();
  node:AttachComponent(trans);
  node:AttachComponent(render);
  
  if diffuseimage then
    render:PushMetadata(--传入纹理原始数据
      apolloengine.RenderObjectTextureMetadata(
        apolloengine.ShaderEntity.TEXTURE_DIFFUSE,--此纹理为diffuse
        apolloengine.TextureFileMetadata(diffuseimage)));
  end
  
  render:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.PathMetadata(materialpath)));
  
  render:PushMetadata(
		apolloengine.RenderObjectMeshMetadate( 
			apolloengine.RenderObjectEntity.RM_TRIANGLES,
      apolloengine.QuadVertexMetadata(),
      apolloengine.QuadIndicesMetadata()));
  render:CreateResource();
  return node, render, trans;
end

function NodeUtility.CreateMeshNode(meshpath, materialpath, diffuseimage)
  local node = apolloengine.Node();
  local trans = apolloengine.TransformComponent();
  local render = apolloengine.RenderComponent();
  node:AttachComponent(trans);
  node:AttachComponent(render);
  
  if diffuseimage then
    render:PushMetadata(--传入纹理原始数据
      apolloengine.RenderObjectTextureMetadata(
        apolloengine.ShaderEntity.TEXTURE_DIFFUSE,--此纹理为diffuse
        apolloengine.TextureFileMetadata(diffuseimage)));
  end
  
  render:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.PathMetadata(materialpath)));
  
  render:PushMetadata(
		apolloengine.RenderObjectMeshFileMetadate(meshpath));
  
  render:CreateResource();
  return node, render, trans;
end


function NodeUtility.Tesslate(splitw, splith,flat,flip)
  local t1,t2,t3,t4;
  local p1 = {-1,-1,};
  local p2 = {1,-1};
  local p3 = {-1,1}; 
  local p4 = {1,1};
  local vertexArray = {};
  local texcoordArray = {};
  
  if flip == true then
    t1 = {0,0};
    t2 = {1,0};
    t3 = {0,1};
    t4 = {1,1};
  else
    t1 = {0,1};
    t2 = {1,1};
    t3 = {0,0};
    t4 = {1,0};
  end

  --tesslate
  local vectorLeftEdge = { (p3[1] - p1[1]), (p3[2] - p1[2]) };
  local vectorRightEdge = { (p4[1] - p2[1]), (p4[2] - p2[2]) };
  for i = 0, splith do
	local pointLeft = { (p1[1] + (i / splith) * vectorLeftEdge[1]), (p1[2] + (i / splith) * vectorLeftEdge[2]) };
	local pointRight = { (p2[1] + (i / splith) * vectorRightEdge[1]), (p2[2] + (i / splith) * vectorRightEdge[2]) };
    for j = 0, splitw do
      local vectorX = { (pointRight[1] - pointLeft[1]), (pointRight[2] - pointLeft[2]) };
      local point = { (pointLeft[1] + (j / splitw) * vectorX[1]), (pointLeft[2] + (j / splitw) * vectorX[2]) };
      local texcoord = { j / splitw, t1[2] + (t3[2] - t1[2]) * i / splith }; --(t3[2] - t1[2]) + i / splith };
      --分割信息
      table.insert(vertexArray,point);
      table.insert(texcoordArray,texcoord);
    end
  end
  
  
  local vertexstream = apolloengine.VertexStream();
  vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,4);
    vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);

  vertexstream:ReserveBuffer((splitw + 1) * (splith + 1));

  local indexstream = apolloengine.IndicesStream();
  indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  indexstream:ReserveBuffer(splitw * splith * 6);
  
  --vertex data
  local newpoint =  mathfunction.vector4(0, 0, 0, 1);
  local index_vertex = vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  for i = 1, #vertexArray do
    local point = vertexArray[i];
    if flat == true then
      newpoint:Set(point[1],0,point[2],1);
    else
      newpoint:Set(point[1],point[2],0,1);
    end
    vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,newpoint);
  end

  --texcoord data
  local newtexcoord = mathfunction.vector2(0,0);
  local index_texcoord = vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0);
  for i = 1, #texcoordArray do
	local texcoord = texcoordArray[i];
    newtexcoord:Set(texcoord[1],texcoord[2]);
    vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,newtexcoord);
  end

  --index data
  for i = 1, splith do
    for j = 1, splitw do
		indexstream:PushIndicesData((i - 1) * (splitw + 1) + (j - 1));  --0
		indexstream:PushIndicesData(i * (splitw + 1) + (j - 1));  --2
		indexstream:PushIndicesData(i * (splitw + 1) + j); --3
		indexstream:PushIndicesData((i - 1) * (splitw + 1) + (j - 1)); --0
		indexstream:PushIndicesData(i * (splitw + 1) + j); --3
		indexstream:PushIndicesData((i - 1) * (splitw + 1) + j); --1
    end
  end
  
  return vertexstream,indexstream;
end

function NodeUtility.TesslateGivenPart(splitw, splith,flat,flip,xrange,yrange)
  local t1,t2,t3,t4;
  local p1 = {xrange[1],yrange[1]};
  local p2 = {xrange[2],yrange[1]};
  local p3 = {xrange[1],yrange[2]}; 
  local p4 = {xrange[2],yrange[2]};
  local vertexArray = {};
  local texcoordArray = {};
  
  local texrangex = {(xrange[1]+1)*0.5,(xrange[2]+1)*0.5};
  local texrangey = {(yrange[1]+1)*0.5,(xrange[2]+1)*0.5};
  if flip == true then
    t1 = {texrangex[1],texrangey[1]};
    t2 = {texrangex[2],texrangey[1]};
    t3 = {texrangex[1],texrangey[2]};
    t4 = {texrangex[2],texrangey[2]};
  else
    t1 = {texrangex[1],texrangey[2]};
    t2 = {texrangex[2],texrangey[2]};
    t3 = {texrangex[1],texrangey[1]};
    t4 = {texrangex[2],texrangey[1]};
  end

  --tesslate
  local vectorLeftEdge = { (p3[1] - p1[1]), (p3[2] - p1[2]) };
  local vectorRightEdge = { (p4[1] - p2[1]), (p4[2] - p2[2]) };
  for i = 0, splith do
	local pointLeft = { (p1[1] + (i / splith) * vectorLeftEdge[1]), (p1[2] + (i / splith) * vectorLeftEdge[2]) };
	local pointRight = { (p2[1] + (i / splith) * vectorRightEdge[1]), (p2[2] + (i / splith) * vectorRightEdge[2]) };
    for j = 0, splitw do
      local vectorX = { (pointRight[1] - pointLeft[1]), (pointRight[2] - pointLeft[2]) };
      local point = { (pointLeft[1] + (j / splitw) * vectorX[1]), (pointLeft[2] + (j / splitw) * vectorX[2]) };
      local texcoord = { j / splitw, t1[2] + (t3[2] - t1[2]) * i / splith }; --(t3[2] - t1[2]) + i / splith };
      --分割信息
      table.insert(vertexArray,point);
      table.insert(texcoordArray,texcoord);
    end
  end
  
  
  local vertexstream = apolloengine.VertexStream();
  vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,4);
    vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);

  vertexstream:ReserveBuffer((splitw + 1) * (splith + 1));

  local indexstream = apolloengine.IndicesStream();
  indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  indexstream:ReserveBuffer(splitw * splith * 6);
  
  --vertex data
  local newpoint =  mathfunction.vector4(0, 0, 0, 1);
  local index_vertex = vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  for i = 1, #vertexArray do
    local point = vertexArray[i];
    if flat == true then
      newpoint:Set(point[1],0,point[2],1);
    else
      newpoint:Set(point[1],point[2],0,1);
    end
    vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,newpoint);
  end

  --texcoord data
  local newtexcoord = mathfunction.vector2(0,0);
  local index_texcoord = vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0);
  for i = 1, #texcoordArray do
	local texcoord = texcoordArray[i];
    newtexcoord:Set(texcoord[1],texcoord[2]);
    vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,newtexcoord);
  end

  --index data
  for i = 1, splith do
    for j = 1, splitw do
		indexstream:PushIndicesData((i - 1) * (splitw + 1) + (j - 1));  --0
		indexstream:PushIndicesData(i * (splitw + 1) + (j - 1));  --2
		indexstream:PushIndicesData(i * (splitw + 1) + j); --3
		indexstream:PushIndicesData((i - 1) * (splitw + 1) + (j - 1)); --0
		indexstream:PushIndicesData(i * (splitw + 1) + j); --3
		indexstream:PushIndicesData((i - 1) * (splitw + 1) + j); --1
    end
  end
  
  return vertexstream,indexstream;
end
return NodeUtility;