local posture = require "facecute.estimates.transposture";
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local b3 = require 'behavior3.b3';
require 'behavior3.core.Decorator'




local targetscope = b3.Class("TargetScope", b3.Decorator)

function targetscope:ctor(properties, target)
  b3.Decorator.ctor(self)
	self.name = "TargetScope"  
  self.targets = {}
  self.defaultposition = mathfunction.vector3(0,0,-1);
  self.defaultrotation = mathfunction.Quaternion();
  if properties.pepole_1 == "true" then
    local nodestage = b3.Blackboard.new()  
    table.insert(self.targets, {index = 1, nodestage = nodestage});
  end
  if properties.pepole_2 == "true" then
    local nodestage = b3.Blackboard.new()  
    table.insert(self.targets, {index = 2, nodestage = nodestage});
  end
  if properties.pepole_3 == "true" then
    local nodestage = b3.Blackboard.new()  
    table.insert(self.targets, {index = 3, nodestage = nodestage});
  end
end

--TODO:
--新增的这种初始化接口，需要解决一个问题，同一个节点会调用多次初始化，那么被调用多次产生的多个数据如何储存的问题
--
function targetscope:init(tick)
  local target = tick.target;
  local board = tick.blackboard;
  local oldscope = board:get("targetscope");
  for _, pair in ipairs(self.targets) do
    local targetscope = target:CreateTarget(pair.index);
    board:set("targetscope", targetscope);
    tick.nodestage = pair.nodestage;
    self.child:init(tick);
  end  
  board:set("targetscope", oldscope);
end

function targetscope:tick(tick)
	if not self.child then
		return b3.ERROR
	end
  
  local status = b3.ERROR;
  local target = tick.target;
  local board = tick.blackboard;
  local maincamera = board:get("maincamera");
  local faces = videodecet:GetFaces();
  local actions = videodecet:GetActions();--返回当前识别出来的动作
  if faces then
    posture:Update(faces,maincamera);
    local postures = posture:GetPostures();
    local oldface = board:get("facescope");
    local oldaction = board:get("actionscope");
    local oldtarget = board:get("targetscope");
    for _, pair in ipairs(self.targets) do
      local face = faces[pair.index];
      local action = actions[pair.index];
      local targetscope = target:GetTarget(pair.index);
      if face then
        targetscope:SetPosture(postures[pair.index].position, postures[pair.index].rotation);
      else
        targetscope:SetPosture(self.defaultposition, self.defaultrotation);
      end    
      targetscope:UpdateIndex(pair.index,table.getn(faces));  
      tick.nodestage = pair.nodestage;
      board:set("facescope", face);
      board:set("actionscope", action);
      board:set("targetscope", targetscope);
      local ns = self.child:_execute(tick);
      status = status > ns and ns or status;
    end  
    board:set("facescope", oldface);
    board:set("actionscope", oldaction);
    board:set("targetscope", oldtarget);
  end
	return status;
end

function targetscope:reset(tick)
  
  local status = b3.ERROR;
  local target = tick.target;
  local board = tick.blackboard;

  local oldtarget = board:get("targetscope");
  for _, pair in ipairs(self.targets) do   
    local targetscope = target:GetTarget(pair.index);
    tick.nodestage = pair.nodestage;
    board:set("targetscope", targetscope);
    local ns = self.child:reset(tick);
  end  
  board:set("targetscope", oldtarget);
end


return targetscope;