local VirtualNode = require "apolloutility.apollonode.virtualnode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"


--虚拟节点，不包含可渲染的组件
local TransNode = VirtualNode:extend();

function TransNode:new()
  TransNode.super.new(self)
  self.position = mathfunction.vector3();
  self.scale = mathfunction.vector3();
  self.trans = apolloengine.TransformComponent();
  self.node:AttachComponent(self.trans);
end

function TransNode:SetLocalPosition(pos_x,y,z)
  if y and z then
    self.position:Set(pos_x, y, z);
  else
    self.position:Set(pos_x:x(), pos_x:y(), pos_x:z());
  end
  self.trans:SetLocalPosition(self.position);
end

function TransNode:SetLocalScale(s_x,y,z)
  if y and z then
    self.scale:Set(s_x, y, z);
  else
    self.scale:Set(s_x:x(), s_x:y(), s_x:z());
  end     
  self.trans:SetLocalScale(self.scale);
end

function TransNode:SetLocalRotation(r)
  self.trans:SetLocalRotation(r);
end

function TransNode:GetLocalPosition()
  --return self.trans:GetLocalPosition();
  return self.position;
end

function TransNode:GetLocalScale()
  return self.trans:GetLocalScale();
end

function TransNode:GetLocalRotation()
  return self.trans:GetLocalRotation();
end

function TransNode:GetWorldTransform()
  return self.trans:GetWorldTransform();
end

function TransNode:GetWorldScale()
  return self.trans:GetWorldScale();
end

function TransNode:GetWorldPosition()
  return self.trans:GetWorldPosition();
end

function TransNode:GetWorldRotation()
  return self.trans:GetWorldRotation();
end

function TransNode:GetWorldScale()
  return self.trans:GetWorldScale();
end

function TransNode:GetWorldRotation()
  return self.trans:GetWorldRotation();
end

function TransNode:SetWorldPosition(wpos)
  self.trans:SetWorldPosition(wpos);
  self.position = self.trans:GetLocalPosition();
end

function TransNode:RigidBodyComponent(shape , mass)
  if not self.rigid then
    self.rigid = apolloengine.RigidBodyComponent();
    self.rigid:Initialize(shape,mass);
    self.node:AttachComponent(self.rigid);
  end
end

function TransNode:SpringJointComponent(node, anchor)
  if not self.rigid then
    error("sprint need rigid component");
  elseif not self.spring then
    self.spring = apolloengine.SpringJointComponent();
    self.node:AttachComponent(self.spring);
    if anchor then
      self.spring:ConnectBody(node.node, anchor);
    else
      self.spring:ConnectBody(node.node);
    end    
  end
end

return TransNode;