local TransNode = require "apolloutility.apollonode.trasnnode"
local spinefunction = require "spinefunction"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"


--虚拟节点，不包含可渲染的组件
local SpineNode = TransNode:extend();

function SpineNode:new()
  self.isshow = true;
  self.node = spinefunction.SpineNode();
  self.render = self.node:GetRenderComponent();
  self.spine = self.node:GetSpineComponent();
  self.trans = apolloengine.TransformComponent();
  self.node:AttachComponent(self.trans);
end

function SpineNode:CreateResource(atlas, skel, material)
  self.spine:PushMetadata(
    apolloengine.PathMetadata(atlas));
  self.spine:PushMetadata(
    apolloengine.PathMetadata(skel));
  self.render:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.PathMetadata(material)));
  
  return self.node:CreateResource();
end

function SpineNode:PushAnimation(name, loop, delay)
  self.spine:PushAnimation(name, loop, delay);
end

function SpineNode:ClearAnimation()  
  self.spine:ClearAnimation();
end

function SpineNode:UpdateAnimation(diff)  
  return self.node:UpdateAnimation(diff);
end

function SpineNode:SetSkin(name)
  return self.spine:SetSkin(name);
end

function SpineNode:FindBone(name)
  return self.spine:FindBone(name);
end

function SpineNode:SetShow(isshow)
  if self.isshow ~= isshow then
    self.isshow = isshow;
    if isshow then
      self.render:SetRenderProperty(apolloengine.RenderObjectEntity.RP_SHOW);
    else
      self.render:EraseRenderProperty(apolloengine.RenderObjectEntity.RP_SHOW);
    end  
  end
end

function SpineNode:BindPose()
  self.node:BindPose();
end

return SpineNode;