local TransNode = require "apolloutility.apollonode.trasnnode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

--骨骼与动画节点
local SkeletonNode = TransNode:extend();

function SkeletonNode:new()
    SkeletonNode.super.new(self);
    self.skeleton = apolloengine.SkeletonComponent();
    self.node:AttachComponent(self.skeleton);
    self.animations = nil;
end

function SkeletonNode:SetSkeletonAndAnims(skeletonpath,aniInfo)

    if aniInfo~=nil then
        self.skeleton:PushMetadata(apolloengine.SkeletonFileMetaData(aniInfo.hasscale and 0 or 1,0,skeletonpath));
		self.skeleton:PushMetadata(apolloengine.KeyFrameFileMetaData(aniInfo.hasscale and 0 or 1,1,aniInfo.name));
        self.skeleton:CreateResource();
        --set default interval
        self.skeleton:SetAnimationInterval(0,aniInfo.framecount-1);
        self.framecount = aniInfo.framecount;
    else 
        self.skeleton:PushMetadata(apolloengine.SkeletonFileMetaData(0,0,skeletonpath));
        self.skeleton:CreateResource();
    end
end

function SkeletonNode:SetSkeletonAndAnims2(skeletonpath,aniInfo,hasScale,originalName)
    if aniInfo~=nil then
      local name = {}
	    self.skeleton:PushMetadata(apolloengine.SkeletonFileMetaData(hasScale and 0 or 1,0,skeletonpath));
      for i = 1, table.getn(aniInfo), 1 do
        self.skeleton:PushMetadata(apolloengine.KeyFrameFileMetaData(hasScale and 0 or 1,1,aniInfo[i].name));
        self.skeleton:SetAnimationInterval(0,aniInfo[i].framecount-1);
      end
   
      self.skeleton:CreateResource();
      self.skeleton:SetDefaultAnimation(originalName);
    --self.skeleton:SetAnimation(originalName);
   
       --set default interval 
    else 
        self.skeleton:PushMetadata(apolloengine.SkeletonFileMetaData(0,0,skeletonpath));
        self.skeleton:CreateResource();
    end
end

function SkeletonNode:SetRetargetSkeletonAndAnims(skeletonpath,aniInfo,retarget_skeletonpath,retarget_aniInfo)
    self.skeleton:PushMetadata(apolloengine.SkeletonRetargetFileMetadata(aniInfo.hasscale and 0 or 1,skeletonpath,aniInfo.name,
      retarget_aniInfo.hasscale and 0 or 1, retarget_skeletonpath,retarget_aniInfo.name));
    self.skeleton:CreateResource();
    --set default interval
    self.skeleton:SetAnimationInterval(0,retarget_aniInfo.framecount-1);
    self.framecount = retarget_aniInfo.framecount;
end

function SkeletonNode:CreateResource(skeletonPath,skeletonType,defaultAnimation,animationList)
  self.skeleton:PushMetadata(apolloengine.SkeletonFileMetaData(skeletonType,0,skeletonPath));
  local animationListCnt = #animationList;
  for i = 1, animationListCnt, 1 do
    local animationInfo = animationList[i];
    self.skeleton:PushMetadata(apolloengine.KeyFrameFileMetaData(skeletonType,1,animationInfo[1]));
    self.skeleton:SetAnimationInterval(0,animationInfo[2] - 1);
  end
  self.skeleton:CreateResource();
  if animationListCnt > 0 then
    self.skeleton:SetDefaultAnimation(animationList[1][1]); --设置默认动画
  end
  
end



function SkeletonNode:UpdateAnimation(def)
    return self.skeleton:UpdateAnimation(def);
end

--test retarget
function SkeletonNode:GetSkeletonComponent()
  return self.skeleton;
end

function SkeletonNode:AddRetarget(target)
  self.skeleton:AddRetargetComponent(target:GetSkeletonComponent());
end

function SkeletonNode:SetLoop(loop)
    self.skeleton:Loop(loop);
end

function SkeletonNode:Reset(frame)
if frame then
    self.skeleton:Reset(frame)
else
    self.skeleton:Reset()
end  
end

function SkeletonNode:Play()
    self.skeleton:Play()
end

function SkeletonNode:Stop()
    self.skeleton:Stop()
end

function SkeletonNode:SetAnimationInterval(from,to)
    if from < 0 then
        from = 0;
    end

    if to > self.framecount-1 then
        to = self.framecount-1;
    end
    self.skeleton:SetAnimationInterval(from,to);
end

function SkeletonNode:GetFrameCount()
    return self.framecount;
end

function SkeletonNode:AttachNodeToJoint(jointName,node)
    self.skeleton:AttachNodeToJoint(jointName,node);
end

local function _TransNodeCast(rawnode)
  local transnode = {}
  transnode = TransNode:cast(transnode);
  transnode.node = rawnode;
  transnode.position = mathfunction.vector3();
  transnode.trans = rawnode:GetComponent(apolloengine.Node.CT_TRANSFORM);
  return transnode;
end

function SkeletonNode:GetJoint(name)
    local rawnode = self.skeleton:GetJoint(name);
    if rawnode then
      return _TransNodeCast(rawnode);
    end
    ERROR("unkown joint with name '"..name.."'");
    return nil;      
end

function SkeletonNode:GetJointNames()
    return self.skeleton:GetJointNames();
end

function SkeletonNode:GetBoneRoots()
  return self.skeleton:GetBoneRoots();
end

function SkeletonNode:_CreateKinematicsComponent()
  if not self.ik then
    self.ik = apolloengine.KinematicsComponent();
    self.node:AttachComponent(self.ik);
  end  
end

function SkeletonNode:CreateJoint(name, rotlimlow, rotlimup)
  self:_CreateKinematicsComponent();
  return self.ik:CreateJoint(name, rotlimlow, rotlimup);
end

function SkeletonNode:SetTarget(name, t)
  return self.ik:SetTarget(name, t);
end

function SkeletonNode:CreateEffector(name)
  return self.ik:CreateEffector(name);
end

function SkeletonNode:SetRootJoint(name)
  return self.ik:SetRootJoint(name);
end

function SkeletonNode:LinkJoints(j1, j2)
  return self.ik:LinkJoints(j1, j2);
end

function SkeletonNode:BuildKinematics()
  self.ik:BuildKinematics();
end

function SkeletonNode:UpdateKinematics()
  return self.ik:UpdateKinematics();
end

return SkeletonNode;