local MeshNode = require "apolloutility.apollonode.meshnode"
local apolloengine = require "apolloengine"

local BlendshapeNode = MeshNode:extend();

function BlendshapeNode:new()
  BlendshapeNode.super.new(self); 
end

function BlendshapeNode:AttachBlendshape(dir, names)
  self.blendshape = apolloengine.BlendshapeComponent();
  self.nameMap = {};
  for i=1, #names do
    local path = dir .. names[i] .. ".mesh";
    self.nameMap[names[i]] = i;
    self.blendshape:PushMetadata(
      apolloengine.FileVertexMetadata(apolloengine.VertexBufferEntity.MU_STATIC, path));
  end
  local res = self.blendshape:CreateResource();
  self.node:AttachComponent(self.blendshape);
  return res;
end

function BlendshapeNode:UpdateBlendshape(weights)
  self.blendshape:SetBlendShapeWeights(weights);
  self.blendshape:Update();
end

function BlendshapeNode:GetNameIndexMap()
  return self.nameMap;
end

return BlendshapeNode;