local mathfunction = require "mathfunction"
local apologine = require "apolloengine"
local venuscore = require "venuscore"
require "utility"


local ParticleUpdateService = {}


function ParticleUpdateService:Initialize()
  self.agent, self.callbackindex = g_callbackhandle:RegisterCallback(ParticleUpdateService.OnAsyncUpdateDone);
  local count = venuscore.IServicesSystem:GetThreadCount();
  LOG(count);
  self.index = 1;
  self.workercount = count;
  self.workers = {}
  self.scheduled = {}--记录哪些粒子在哪些服务中，以免同一个粒子放到多个服务中的多线程问题
  self.needupdate = false;
  for i=1,count do
    local w = venuscore.IServicesSystem:Create("apolloutility.apollonode.asyncparticle.particleupdateagent");
    w:Initialize(self.agent, self.callbackindex);
    table.insert(self.workers, w);
  end
end

function ParticleUpdateService:Scheduled(emitter, timespan)
  self.needupdate = true;
  local ssid = tostring(emitter:GetUUID());
  local index = self.scheduled[ssid];
  if not index then  
    index = self.index;
    self.scheduled[ssid] = index;
    self.index = self.index + 1 > self.workercount and 1 or self.index + 1;
  end
  local worker = self.workers[index];
  worker:Scheduled(emitter, timespan or 0.0333);
end

local resumer = nil;
function ParticleUpdateService:AsyncUpdate()
  if self.needupdate then
    self.donecount = 0;
    for _, w in ipairs(self.workers) do
      w:AsyncUpdate();
    end 
    self.scheduled = {};
    self.resumer = venuscore.Context:GetServiceContext();
    self.resumer:Pasue();
    self.needupdate = false;    
  end  
end

function ParticleUpdateService.OnAsyncUpdateDone()
  ParticleUpdateService.donecount = ParticleUpdateService.donecount + 1;
  if ParticleUpdateService.donecount == ParticleUpdateService.workercount then
    ParticleUpdateService.resumer:Resume();
    ParticleUpdateService.resumer = nil;
  end  
end

function ParticleUpdateService:Clear()
  for _, w in ipairs(self.workers) do
    w:Clear();
  end  
  return true;
end

return ParticleUpdateService;
