//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////





#SHADER_DEFINE SDFFontVertex

FUNCTION_INPUT =
	{
		{ CAMERA_RESOLUTION_INV,        HIGH, VEC2,   "in_ResolutionInv"},
		{ CAMERA_RESOLUTION_HALF_INV,   HIGH, VEC2,   "in_ResolutionHalfInv"},
		{ WORLD_POSITION,           	HIGH, VEC3,   "in_WorldPosition"},
		{ WORLD_SCALE,             		HIGH, VEC3,   "in_WorldScale"},
		{ ATTRIBUTE_POSITION, 			HIGH, VEC2,		"in_Position" },
		{ ATTRIBUTE_COLOR0, 			HIGH,  VEC4,		"in_Color" },
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"in_Coordinate" },
        { SHADOW_OFFSET,                HIGH,  VEC2,    "shadow_offset"},
        { SHADOW_COLOR,                HIGH,  VEC4,    "shadow_color"},
	}

	FUNCTION_OUTPUT =
	{
		{ SCREENSPACE_POSITION, 		HIGH,	VEC4,		"out_Position" },
		{ ATTRIBUTE_COLOR0, 			  HIGH,	VEC4,		"out_Color" },
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"Out_Coordinate" },
		{ SMOOTH_DELTA,                 HIGH,   FLOAT,      "out_smooth_delta"},
	}

#SHADER_CODE
	vec4 out_Position = vec4(in_Position * in_WorldScale.xy *in_ResolutionInv + in_WorldPosition.xy * in_ResolutionHalfInv, 0.0, 1.0);
    vec4 out_Color = in_Color;
	highp vec2 Out_Coordinate = in_Coordinate / 512.0;
	float out_smooth_delta = 0.1;
	if(shadow_color.a != 0.0){
	    out_Color = shadow_color;
	    out_Position = out_Position + vec4(shadow_offset,0.0,0.0) * 0.01;
	    out_smooth_delta = 0.3;
	}
#END_CODE
#END_DEFINE


#SHADER_DEFINE SDFFontSampling

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	HIGH,	VEC2,		"in_Coordinate" },
		{ OUTLINE_COLOR,        HIGH,   VEC4,       "outline_color"},
		{ OUTLINE_STRENGTH,        HIGH,   FLOAT,       "outline_strength"},
		{ ATTRIBUTE_COLOR0, 			  HIGH,	VEC4,		"in_Color" },
		{ SMOOTH_DELTA,                 HIGH,   FLOAT,      "in_smooth_delta"},
	}

    FUNCTION_OUTPUT =
    {
        { SURFACE_COLOR,	HIGH,	VEC4,		"out_TextureColor" },
    }
	
#SHADER_CODE
    float distance_mark = 0.5;
    float smooth_delta = in_smooth_delta;
    float outline_distance_mark = distance_mark - outline_strength * 0.05;
    vec4 outlineColor = outline_color;

    vec4 col = texture2D(in_DiffuseTexture, in_Coordinate);
    float distance = col.r;

    outlineColor.a = smoothstep(outline_distance_mark - smooth_delta, outline_distance_mark + smooth_delta, distance);

    col.a = smoothstep(distance_mark - smooth_delta, distance_mark + smooth_delta, distance) * in_Color.a;
    col.rgb = in_Color.rgb;
    vec4 out_TextureColor = col;
    if(outline_strength != 0.0){
        out_TextureColor = mix(outlineColor, col, col.a);
    }
#END_CODE
#END_DEFINE