//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////





#SHADER_DEFINE EmitterSoftoutVertex
	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_EMITTER_LIFE,				HIGH,	FLOAT,	"in_Life" },
		{ EMITTER_AGE,				HIGH,	FLOAT,	"in_Age" },
	}
	FUNCTION_OUTPUT = 
	{
		{ COLOR_ALPHA,				LOW,	FLOAT,	"out_Alpha" },
	}
#SHADER_CODE
	float out_Alpha = 1.0 - (in_Age / in_Life);
	out_Alpha = clamp ( out_Alpha, 0.0, 1.0 );
#END_CODE
#END_DEFINE


#SHADER_DEFINE EmitterSoftinoutVertex
	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_EMITTER_LIFE,				HIGH,	FLOAT,	"in_Life" },
		{ EMITTER_AGE,				HIGH,	FLOAT,	"in_Age" },
	}
	FUNCTION_OUTPUT = 
	{
		{ COLOR_ALPHA,				LOW,	FLOAT,	"out_Alpha" },
	}
#SHADER_CODE
	float div = in_Age / in_Life;
	float out_Alpha = div * (1.0 - div) * 4.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE EmitterSoftinoutFragment

	FUNCTION_INPUT = 
	{
		{ SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" },
		{ COLOR_ALPHA,		LOW,	FLOAT,	"in_Alpha" },
    { PARTICLE_COLOR, LOW,  VEC4, "in_ParticleColor"},
	}
	FUNCTION_OUTPUT =
	{
		{ SURFACE_COLOR,	LOW,	VEC4,	"out_SurfaceColor" },
	}

#SHADER_CODE
	vec4 out_SurfaceColor = in_SurfaceColor * in_ParticleColor;
  //out_SurfaceColor = in_ParticleColor;
	out_SurfaceColor.a *= in_Alpha;
  
#END_CODE
#END_DEFINE