#include "functions/toonhair.function"
#SHADER_DEFINE CharaHairVertex

  FUNCTION_INPUT = 
	{
		{ ANIMATION_MATRIX_ARRAY,	HIGH,	VEC4_ARRAY,	"in_BoneMatrixArray", "300" },
		{ ATTRIBUTE_BONE_INEX,		HIGH,	VEC4,		"in_BoneIndex" },
		{ ATTRIBUTE_BONE_WEIGHT,	HIGH,	VEC4,		"in_Boneweight" },
		{ ATTRIBUTE_POSITION,		HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_NORMAL, 		HIGH,	VEC3,		"in_Normal" },
		{ ATTRIBUTE_TANGENT,		HIGH,	VEC4,		"in_Tangent" },
	}

	FUNCTION_OUTPUT = 
	{
		{ ATTRIBUTE_POSITION,	HIGH,	VEC4,		"out_Position" },
		{ ATTRIBUTE_NORMAL, 	HIGH,	VEC3,		"out_Normal" },
		{ ATTRIBUTE_TANGENT, 	HIGH,	VEC3,		"out_Tangent" },
	}
	#SHADER_CODE
		vec3 blendPos = vec3(0.0, 0.0, 0.0);
		vec3 blendNorm = vec3(0.0, 0.0, 0.0);
		vec3 blendTangent = vec3(0.0, 0.0, 0.0);
		for (int bone = 0; bone < 4; ++bone)
		{
      int idx = int(in_BoneIndex[bone]) * 3;
			float weight = in_Boneweight[bone]; 
      mat4 worldMatrix;
      worldMatrix[0] = vec4(in_BoneMatrixArray[idx]);
      worldMatrix[1] = vec4(in_BoneMatrixArray[idx + 1]);
      worldMatrix[2] = vec4(in_BoneMatrixArray[idx + 2]);
      worldMatrix[3] = vec4(0.0);
      blendPos += (in_Position * worldMatrix).xyz * weight;
      mat3 worldRotMtrix = mat3(worldMatrix[0].xyz,worldMatrix[1].xyz,worldMatrix[2].xyz);
      blendNorm += (in_Normal * worldRotMtrix) * weight;
      blendTangent += (worldRotMtrix * in_Tangent.xyz) * weight;
		}
		blendNorm = normalize(blendNorm);
		vec4 out_Position = vec4(blendPos,1.0);
		vec3 out_Normal	= blendNorm;
		vec3 out_Tangent = blendTangent;
	
	#END_CODE
#END_DEFINE



#SHADER_DEFINE CharaHairFragmentOutput
	FUNCTION_INPUT = 
	{
		{ SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" }
	}
	FUNCTION_OUTPUT = { }

#SHADER_CODE
    gl_FragColor = in_SurfaceColor;
#END_CODE
#END_DEFINE



#SHADER_DEFINE CharaHairVertexDir

	FUNCTION_INPUT = 
	{
    {CAMERA_WORLDPOSITION,HIGH,VEC3,"in_CameraPos"},
    { WORLDSPACE_POSITION,		HIGH,	VEC4,		"in_PositionWS" },
    {LIGHT_POSITION,HIGH,VEC4,"in_LightPos"},
    {LIGHT_GIVEN_DIRECTION,HIGH,VEC3,"in_LightDirection"},
	}
	
	FUNCTION_OUTPUT =
	{
		{ INTERNAL_EYETOOBJDIR,			HIGH,	VEC4,		"Out_EyeToObjDir" },
    { INTERNAL_LightTOOBJDIR,			HIGH,	VEC4,		"Out_LightToObjDir" },
	}
#SHADER_CODE
	// Eye direction vector
  vec4 Out_EyeToObjDir= normalize( vec4(in_CameraPos.xyz,1.0) - vec4(in_PositionWS.xyz/in_PositionWS.w,1.0) );
  vec4 Out_LightToObjDir= normalize( vec4(in_LightDirection.xyz,0.0));
#END_CODE
#END_DEFINE




#SHADER_DEFINE CharaHairFragment
	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
    { INTERNAL_EYETOOBJDIR,			MEDIUM,	VEC4,		"In_EyeToObjDir" },
    { INTERNAL_LightTOOBJDIR,			MEDIUM,	VEC4,		"In_LightToObjDir" },
    { WORLDSPACE_NORMAL, 		MEDIUM,	VEC3,		"In_Normal" },
    { TEXTURE_SKIN,		NONE,	TEXTURE2D,	"in_SkinTexture" },
    { TEXTURE_RIM,		NONE,	TEXTURE2D,	"in_RimTexture" },
    { TEXTURE_SPECSAMPLER,		NONE,	TEXTURE2D,	"In_SpecularReflectionSampler" },
  
    { TEXTURE_ENVSAMPLER,		NONE,	TEXTURE2D,	"In_EnvMapSampler" },
 
    { TEXTURE_NORMALSAMPLER,		NONE,	TEXTURE2D,	"In_NormalMapSampler" },
 
    { WORLDSPACE_TANGENT,   HIGH, VEC3,    "In_Tangent"},
    { WORLDSPACE_BINORMAL,  HIGH, VEC3,    "In_Binormal"},
    {LIGHT_COLOR,MEDIUM,VEC3,"in_LightColorIn"},
    {Main_Color,MEDIUM ,VEC4,"in_MainColor"},
    {Shadow_Color,MEDIUM,VEC4,"in_ShadowColor"},
    {Specular_Power,MEDIUM,FLOAT,"in_SpecularPower"},
    {Gamma_Value,MEDIUM,FLOAT,"in_GammaValue"},
    {FallofPower_Value,MEDIUM,FLOAT,"in_FallofPowerValue"},
	}
  FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,	LOW,	VEC4,		"out_TextureColor" },
	}
#SHADER_CODE


float gamma = in_GammaValue;
vec4 diffSamplerColor = texture2D( in_DiffuseTexture, in_Coordinate  );
diffSamplerColor = vec4(pow(diffSamplerColor.rgb,vec3(gamma,gamma,gamma)),diffSamplerColor.a);


#define ENABLE_NORMAL_MAP
#ifdef ENABLE_NORMAL_MAP
  vec3 normalVec = normalize(pow( texture2D( In_NormalMapSampler, in_Coordinate ).xyz,vec3(gamma,gamma,gamma)) * 2.0 - 1.0 );
	mat3 localToWorldTranspose = mat3(
		In_Tangent,
		In_Binormal,
		In_Normal
	);
	normalVec =localToWorldTranspose*normalVec;
  normalVec = normalize(normalVec);
#else
	vec3 normalVec = In_Normal;
#endif

	// Falloff.
  float FALLOFF_POWER = 0.3;
  float normalDotEye = dot( normalVec, In_EyeToObjDir.xyz );
	float falloffU = clamp( 1.0 - abs( normalDotEye ), 0.02, 0.98 );
  vec4 skintexcolor = texture2D( in_SkinTexture, vec2( falloffU, 0.25));
  skintexcolor = vec4(pow(skintexcolor.rgb,vec3(gamma,gamma,gamma)),skintexcolor.a);
  vec4 falloffSamplerColor = FALLOFF_POWER * skintexcolor;
  vec3 shadowColor = diffSamplerColor.rgb * diffSamplerColor.rgb;
  vec3 combinedColor = (1.0-falloffSamplerColor.r)*diffSamplerColor.rgb+falloffSamplerColor.r*shadowColor;
	combinedColor =combinedColor* ( vec3(1.0,1.0,1.0) + falloffSamplerColor.rgb * falloffSamplerColor.a );

	// Specular
	vec4 reflectionMaskColor = texture2D( In_SpecularReflectionSampler, in_Coordinate);
  reflectionMaskColor = vec4(pow(reflectionMaskColor.rgb,vec3(gamma,gamma,gamma)),reflectionMaskColor.a);
	float specularDot = dot( normalVec, In_EyeToObjDir.xyz );
  float _SpecularPower =  in_SpecularPower;
	vec4 lighting = litcal( normalDotEye, specularDot, _SpecularPower );
	vec3 specularColor = clamp( lighting.z,0.0,1.0 ) * reflectionMaskColor.rgb * diffSamplerColor.rgb;
	combinedColor = combinedColor+specularColor;
	

  vec4 _Color = in_MainColor;
  vec4 _LightColor0 = vec4(in_LightColorIn.rgb,1.0);
  
  #define ENABLE_ENV_MAP
  #ifdef ENABLE_ENV_MAP
    // Reflection
    vec3 reflectVector = reflect( -1.0*In_EyeToObjDir.xyz, normalVec ).xzy;
    vec2 sphereMapCoords = 0.5 * ( vec2( 1.0, 1.0 ) + reflectVector.xy );
    vec3 reflectColor = texture2D( In_EnvMapSampler, sphereMapCoords ).rgb;
    reflectColor = pow(reflectColor.rgb,vec3(gamma,gamma,gamma));
    reflectColor = GetOverlayColor( reflectColor, combinedColor );
    combinedColor =  combinedColor*(1.0-reflectionMaskColor.a)+ reflectColor*reflectionMaskColor.a;

    combinedColor =combinedColor* _Color.rgb * _LightColor0.rgb;
  #endif

	// Rimlight
	float rimlightDot = clamp( 0.5 * ( dot( normalVec, In_LightToObjDir.xyz ) + 1.0 ),0.0,1.0 );
	falloffU = clamp( rimlightDot * falloffU,0.0,1.0 );
	falloffU = pow(texture2D( in_RimTexture, vec2( falloffU, 0.25f ) ).r,gamma);
	vec3 lightColor = diffSamplerColor.rgb; // * 2.0;
	combinedColor =combinedColor+ falloffU * lightColor;
  float opacity = diffSamplerColor.a * _Color.a * _LightColor0.a;
  float outgamma = 1.0/gamma;
  vec4 out_TextureColor =  vec4( pow(combinedColor.rgb,vec3(outgamma,outgamma,outgamma)), opacity );

#END_CODE
#END_DEFINE



#SHADER_DEFINE CharaHairSimpleFragment
	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
    { INTERNAL_EYETOOBJDIR,			MEDIUM,	VEC4,		"In_EyeToObjDir" },
    { INTERNAL_LightTOOBJDIR,			MEDIUM,	VEC4,		"In_LightToObjDir" },
    { WORLDSPACE_NORMAL, 		MEDIUM,	VEC3,		"In_Normal" },
    { TEXTURE_SKIN,		NONE,	TEXTURE2D,	"in_SkinTexture" },
    { TEXTURE_RIM,		NONE,	TEXTURE2D,	"in_RimTexture" },
    { TEXTURE_SPECSAMPLER,		NONE,	TEXTURE2D,	"In_SpecularReflectionSampler" },
  
    //{ TEXTURE_ENVSAMPLER,		NONE,	TEXTURE2D,	"In_EnvMapSampler" },
 
   // { TEXTURE_NORMALSAMPLER,		NONE,	TEXTURE2D,	"In_NormalMapSampler" },
 
    { WORLDSPACE_TANGENT,   HIGH, VEC3,    "In_Tangent"},
    { WORLDSPACE_BINORMAL,  HIGH, VEC3,    "In_Binormal"},
    {LIGHT_COLOR,MEDIUM,VEC3,"in_LightColorIn"},
    {Main_Color,MEDIUM ,VEC4,"in_MainColor"},
    {Shadow_Color,MEDIUM,VEC4,"in_ShadowColor"},
    {Specular_Power,MEDIUM,FLOAT,"in_SpecularPower"},
    {Gamma_Value,MEDIUM,FLOAT,"in_GammaValue"},
    {FallofPower_Value,MEDIUM,FLOAT,"in_FallofPowerValue"},
	}
  FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,	LOW,	VEC4,		"out_TextureColor" },
	}
#SHADER_CODE


float gamma = in_GammaValue;
vec4 diffSamplerColor = texture2D( in_DiffuseTexture, in_Coordinate  );
diffSamplerColor = vec4(pow(diffSamplerColor.rgb,vec3(gamma,gamma,gamma)),diffSamplerColor.a);


//#define ENABLE_NORMAL_MAP
#ifdef ENABLE_NORMAL_MAP
  vec3 normalVec = normalize(pow( texture2D( In_NormalMapSampler, in_Coordinate ).xyz,vec3(gamma,gamma,gamma)) * 2.0 - 1.0 );
	mat3 localToWorldTranspose = mat3(
		In_Tangent,
		In_Binormal,
		In_Normal
	);
	normalVec =localToWorldTranspose*normalVec;
  normalVec = normalize(normalVec);
#else
	vec3 normalVec = In_Normal;
#endif

	// Falloff.
  float FALLOFF_POWER = 0.3;
  float normalDotEye = dot( normalVec, In_EyeToObjDir.xyz );
	float falloffU = clamp( 1.0 - abs( normalDotEye ), 0.02, 0.98 );
  vec4 skintexcolor = texture2D( in_SkinTexture, vec2( falloffU, 0.25));
  skintexcolor = vec4(pow(skintexcolor.rgb,vec3(gamma,gamma,gamma)),skintexcolor.a);
  vec4 falloffSamplerColor = FALLOFF_POWER * skintexcolor;
  vec3 shadowColor = diffSamplerColor.rgb * diffSamplerColor.rgb;
  vec3 combinedColor = (1.0-falloffSamplerColor.r)*diffSamplerColor.rgb+falloffSamplerColor.r*shadowColor;
	combinedColor =combinedColor* ( vec3(1.0,1.0,1.0) + falloffSamplerColor.rgb * falloffSamplerColor.a );

	// Specular
	vec4 reflectionMaskColor = texture2D( In_SpecularReflectionSampler, in_Coordinate);
  reflectionMaskColor = vec4(pow(reflectionMaskColor.rgb,vec3(gamma,gamma,gamma)),reflectionMaskColor.a);
	float specularDot = dot( normalVec, In_EyeToObjDir.xyz );
  float _SpecularPower =  in_SpecularPower;
	vec4 lighting = litcal( normalDotEye, specularDot, _SpecularPower );
	vec3 specularColor = clamp( lighting.z,0.0,1.0 ) * reflectionMaskColor.rgb * diffSamplerColor.rgb;
	combinedColor = combinedColor+specularColor;
	

  vec4 _Color = in_MainColor;
  vec4 _LightColor0 = vec4(in_LightColorIn.rgb,1.0);
  
  //#define ENABLE_ENV_MAP
  #ifdef ENABLE_ENV_MAP
    // Reflection
    vec3 reflectVector = reflect( -1.0*In_EyeToObjDir.xyz, normalVec ).xzy;
    vec2 sphereMapCoords = 0.5 * ( vec2( 1.0, 1.0 ) + reflectVector.xy );
    vec3 reflectColor = texture2D( In_EnvMapSampler, sphereMapCoords ).rgb;
    reflectColor = pow(reflectColor.rgb,vec3(gamma,gamma,gamma));
    reflectColor = GetOverlayColor( reflectColor, combinedColor );
    combinedColor =  combinedColor*(1.0-reflectionMaskColor.a)+ reflectColor*reflectionMaskColor.a;

    combinedColor =combinedColor* _Color.rgb * _LightColor0.rgb;
  #endif

	// Rimlight
	float rimlightDot = clamp( 0.5 * ( dot( normalVec, In_LightToObjDir.xyz ) + 1.0 ),0.0,1.0 );
	falloffU = clamp( rimlightDot * falloffU,0.0,1.0 );
	falloffU = pow(texture2D( in_RimTexture, vec2( falloffU, 0.25f ) ).r,gamma);
	vec3 lightColor = diffSamplerColor.rgb; // * 2.0;
	combinedColor =combinedColor+ falloffU * lightColor;
  float opacity = diffSamplerColor.a * _Color.a * _LightColor0.a;
  float outgamma = 1.0/gamma;
  vec4 out_TextureColor =  vec4( pow(combinedColor.rgb,vec3(outgamma,outgamma,outgamma)), opacity );

#END_CODE
#END_DEFINE

