//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////



#SHADER_DEFINE BillboardTransform

	FUNCTION_INPUT = 
	{
    { LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
    { LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
		{ CAMERA_PROJECTION,		HIGH,	MAT4,		"in_Porjection" },
		{ CAMERA_VIEW,				HIGH,	MAT4,		"in_View" },
		{ LOCALSPACE_POSITION, 		HIGH,	VEC3,		"in_Center" },
    { PARTICLE_OFFEET,		HIGH,	VEC3,	"in_Offset" },
    { ATTRIBUTE_EMITTER_SPEED_BORNTIME, HIGH, VEC4, "in_Speed_Borntime"},
    { ATTRIBUTE_EMITTER_SIZE_DISTRUBANCE_STRETCH, HIGH, VEC4, "in_Size_Distrubance_Stretch"},
	}

	FUNCTION_OUTPUT = 
	{
		{ SCREENSPACE_POSITION, 	HIGH,	VEC4,		"out_Position" },
	}

#SHADER_CODE
	vec4 out_Position;
  //out_Position  = in_Transfrom * vec4( in_Center, 1.0);
  out_Position = in_View * vec4( in_Center, 1.0);	
	out_Position.xyz += in_Offset;// * out_Position.w;
  out_Position = in_Porjection * out_Position;
#END_CODE
#END_DEFINE


