local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local GetParamNameCommand = CommandBase:extend("GetParamNameCommand");

function GetParamNameCommand:new(comuid, smsId, paramIndex)
    GetParamNameCommand.super.new(self);
    self._comUid = comuid;
    self._smsId  = smsId;
    self._index  = paramIndex;
    self._name   = nil;
end

function GetParamNameCommand:DoIt()
    self:BeginCmd();
    local ani = self:GetContent(self._comUid);
    if ani and self._index >= 0 then
        self._name = ani:GetParameterName(self._smsId, self._index);
    else 
        self._name = "";
    end
    self:EndCmd();
end

function GetParamNameCommand:Undo()
    self:BeginCmd();
    
    self:EndCmd();
end

return GetParamNameCommand;