local libvenuscore = require "libvenuscore"


local VenusBehavior = libvenuscore.Object:extend("VenusBehavior");

function VenusBehavior:new()
  self.hasStarted = false;
end

function VenusBehavior:_OnAwake()
end

function VenusBehavior:_OnStart()
end

function VenusBehavior:_OnDisable()
end

function VenusBehavior:_OnUpdate()
end

function VenusBehavior:_OnDestroy()
end

function VenusBehavior:_OnPackage()
end



function VenusBehavior:Awake()
  self.hasStarted = false;
  self:_OnAwake();
end

function VenusBehavior:Start()
  self.hasStarted = true;
  self:_OnStart();
end

function VenusBehavior:Update(def)
  if self.hasStarted == false then
    self:Start();
  end
  self:_OnUpdate(def);
end

function VenusBehavior:LateUpdate(def)
  if self._OnLateUpdate then
    self:_OnLateUpdate(def);
  end
end

--给脚本提供一个打包时候的特殊操作机会
--eg: 自定义礼物脚本需要在打包时导出一个json配置
function VenusBehavior:Package()
  return self:_OnPackage();
end



function VenusBehavior:Disable()
  self:_OnDisable();
end

function VenusBehavior:Destroy()
  self:_OnDestroy();
end

function VenusBehavior:GetResourceDependencies()
  return {};
end

function VenusBehavior:SetUniqueKey(hostID, path)
  self._hostID = hostID;
  self._path = path;
end

return VenusBehavior;