
local BlueSelf = require "bluecore.blueself"
local BlueprintSelf = require "bluecore.core.blueprint_self"
local Types = require "venuscore.rtti.types"
local mf = require "mathfunction"
local vc = require "venuscore"
local AE = require "apolloengine"
local cv = require "computervisionfunction"
local BU = require "bluecore.blueutility"
local BD = require "bluecore.bluedefined"

local args = {...}
--for k,v in pairs( args) do
--  print(k,v)
--end
local BlueRtti = args[1] -- func = loadFile()  func(BlueRtti)

---- 一些默认函数
--
local function _DefaultFtn(rtti) return nil end
local function _LiteralFtn(rtti, default) return default ; end
local function _DupFtn(rtti, rhs) return rhs end
local function _CreateFtn(rtti, metadata) return metadata end -- metadata is object directly

local function _CreateInvalidFtn(rtti)
  -- error
  ERROR(rtti:GetTypeName()..": create invalid operation ");
  return nil;
end


local function _NoneTypeFtn() return Types.NoneType() end
local function _NotNullTypeFtn() return Types.NotNullType() end
local function _BlueSelfFtn() return BlueSelf() end
local function _AnyTypeFtn() return Types.AnyType() end
local function _AnyArrayTypeFtn() return {} end
local function _NilFtn() return nil end


local NO_TYPE_INFO = nil -- 没有typeinfo的 不会在变量类型选择上看到

---- 给定类型的(参数1) 生成默认值 字面值 创建实例 和 右侧反射面板TypeInfo
--
BlueRtti.Register(Types.BoolType, function(rtti) return false end, _LiteralFtn, _DupFtn, _CreateFtn, Types.BaseType);

BlueRtti.Register(Types.IntType, function(rtti) return 0 end, _LiteralFtn, _DupFtn, _CreateFtn, Types.BaseType);

BlueRtti.Register(Types.FloatType, function(rtti) return 0.0 end, _LiteralFtn, _DupFtn, _CreateFtn, Types.BaseType);

local function stringFtn(rtti, default)
  if default == "" then return BD.EMPTY_STRING end -- 由于序列化对"" 保存为nil,所以蓝图统一把BD.EMPTY_STRING=" "作为""
  return default
end
BlueRtti.Register(Types.StringType, function(rtti) return BD.EMPTY_STRING end, stringFtn, _DupFtn, _CreateFtn, Types.BaseType);

local function vector1Ftn(rtti, obj) return mf.vector1(obj:x()) end
BlueRtti.Register(mf.vector1:RTTI(), function() return mf.vector1(0) end, vector1Ftn, vector1Ftn, vector1Ftn,Types.BaseType);

local function vector2Ftn(rtti, obj) return mf.vector2(obj:x(), obj:y()) end
BlueRtti.Register(mf.vector2:RTTI(), function() return mf.vector2(0,0) end, vector2Ftn, vector2Ftn, vector2Ftn, Types.BaseType);

local function vector3Ftn(rtti, obj) return mf.vector3(obj:x(), obj:y(), obj:z()) end
BlueRtti.Register(mf.vector3:RTTI(), function() return mf.vector3(0,0,0) end, vector3Ftn, vector3Ftn, vector3Ftn, Types.BaseType);

local function vector4Ftn(rtti, obj) return mf.vector4(obj:x(), obj:y(), obj:z(), obj:w()) end
BlueRtti.Register(mf.vector4:RTTI(), function() return mf.vector4(0,0,0,0) end, vector4Ftn, vector4Ftn, vector4Ftn, Types.BaseType);

local function colorFtn(rtti, obj) return mf.Color(obj.r, obj.g, obj.b, obj.a) end
BlueRtti.Register(mf.Color:RTTI(), function() return mf.Color(0,0,0,0) end, colorFtn, colorFtn, colorFtn, Types.BaseType);


local function quaternionFtn(rtti, obj) return mf.Quaternion(obj:x(), obj:y(), obj:z(), obj:w()) end
BlueRtti.Register(mf.Quaternion:RTTI(), function() return  mf.Quaternion()  end, quaternionFtn, quaternionFtn, quaternionFtn, Types.BaseType);


local function directoryFileFtn(rtti, obj) local collection = {} for _, file in ipairs(obj) do table.insert(collection, file) end return collection end

-- 把蓝图节点的路径/目录转换成绝对路径 避免加载其他素材修改了proj
local function CreateDirectoryFilePath(rtti, literal)
  local newLiteral = {}
  if literal ~= nil and  type(literal) == 'table' then
    for idx, path in pairs(literal) do
      newLiteral[idx] = vc.IFileSystem:PathAssembly(path) ;
    end
  else
    ERROR("[input] directory file filter with non-input");
  end
  return newLiteral
end
BlueRtti.Register(Types.DirectoryFileFilterType, function(rtti) return {} end, directoryFileFtn, directoryFileFtn, CreateDirectoryFilePath, NO_TYPE_INFO);

---- 作为基类 没有typeInfo 右侧反射面板没有显示
BlueRtti.Register(Types.CheckBoxType, function(rtti) return 0 end, _LiteralFtn, _DupFtn, _CreateFtn, NO_TYPE_INFO);
BlueRtti.Register(Types.ComboType, function(rtti) local key, _ = next(rtti:GetComboData()) return key end, _LiteralFtn, _DupFtn, _CreateFtn, NO_TYPE_INFO);

local function CreateFilePath(rtti, literal)
  return vc.IFileSystem:PathAssembly(literal)
end
BlueRtti.Register(Types.PathType, function(rtti) return BD.EMPTY_STRING end, stringFtn, _DupFtn, CreateFilePath, NO_TYPE_INFO);
BlueRtti.Register(Types.FilePathType, function(rtti) return BD.EMPTY_STRING end, stringFtn, _DupFtn, CreateFilePath, NO_TYPE_INFO);

BlueRtti.Register(Types.BaseType, _DefaultFtn, _LiteralFtn, _DupFtn, CreateFilePath, NO_TYPE_INFO);
---- 作为具体类
--

local TexFilterReflectType = Types.ComboType:extend();
function TexFilterReflectType:new(set, get)
  -- 反射面板不支持继承, TexFilterType是有自己的类名的
  -- ComboType:SetData和new定义的table不一样
  -- new 是 { {key="a" value=1}   {key = "b" value = 2 }  }
  -- SetData 是 {   1= “a”, 2 = "b"  }
  local tbl = {}
  if _KRATOSEDITOR then
    local defined = require "window.editor.system.defined"
    for index, _key in pairs(defined.TextureFilterName) do
      table.insert(tbl,{key=_key, value=defined.TextureFilter[index]})
    end
  end
  TexFilterReflectType.super.new(self, tbl, set, get)
end
BlueRtti.Register(Types.TexFilterType, function(rtti) local key, _ = next(rtti:GetComboData()) return key end, _LiteralFtn, _DupFtn, _CreateFtn,
                  TexFilterReflectType);

---- 默认的资源依赖 应该是venusroot下的
--
BlueRtti.Register(AE.MaterialEntity:RTTI(), function(rtti) return "comm:documents/material/unlit.mat" end, _LiteralFtn, _DupFtn,
        function(rtti, matFilePath)
          local meta = AE.MaterialMetadata(vc.IFileSystem:PathAssembly(matFilePath));
          local material = AE.MaterialEntity();
          material:PushMetadata(meta);
          material:CreateResource();
          return material;
        end,
        Types.BlueMaterialEntity);

BlueRtti.Register(AE.TextureEntity:RTTI(), function(rtti) return "DEVICE_CAPTURE" end, _LiteralFtn, _DupFtn,
        function(rtti, metadata, ... )
          local filepath = vc.IFileSystem:PathAssembly(metadata)
          local devresourceType = BU:GetDevResourceType(filepath) --DEVICE_CAPTURE 或者 LAST_QUEUE
          local extension = filepath:match(".+%.(%w+)$"); --得到后缀
          if extension ~= nil then
            extension = string.lower(extension);
          end
          extension = extension or devresourceType;
          local entity = BU:CreateEntity(filepath, extension, ...);
          return entity
        end,
        Types.BlueTextureEntity);

---- 特殊类型/特殊值
--
BlueRtti.Register(Types.AnyType, _AnyTypeFtn, _AnyTypeFtn, _AnyTypeFtn, _CreateInvalidFtn, NO_TYPE_INFO)
BlueRtti.Register(Types.AnyArrayType, _AnyArrayTypeFtn, _AnyArrayTypeFtn, _AnyArrayTypeFtn, _CreateInvalidFtn, NO_TYPE_INFO)


---- NotNullType NoneType BlueSelf 只是作为特殊值,类似nullptr的类型是nullptr_t,都不会作为引脚的RTTI 这里只是为了补齐全
--
BlueRtti.Register(Types.NoneType, _NoneTypeFtn, _NoneTypeFtn, _NoneTypeFtn, _CreateInvalidFtn, NO_TYPE_INFO); -- deprecated
BlueRtti.Register(Types.NotNullType, _NotNullTypeFtn, _NotNullTypeFtn, _NotNullTypeFtn, _CreateInvalidFtn, NO_TYPE_INFO)  -- deprecated
BlueRtti.Register(BlueSelf, _BlueSelfFtn, _BlueSelfFtn, _BlueSelfFtn, _CreateInvalidFtn, NO_TYPE_INFO);


---- 其他
-- 目前C++还是要保证 字面值和拷贝 都是原来给的默认值 目前除了指定的Node以外 其他C++类型的自动生成的默认值都是NotNil(必须链接)
local function _SelfOrNil(rtti, default) -- default maybe Node/CameraComponent c++ obj from BlueVariableInfo:GetDefault()
  if default ~= nil and type(default) == 'table' and default:isType(BlueSelf) then
    return BlueSelf();
  end
  return nil;
end
-- 蓝图自定义变量 支持的 C++类型
BlueRtti.Register(AE.Node:RTTI(),                   _NilFtn, _SelfOrNil, _DupFtn, _CreateFtn, Types.ReferenceType)
BlueRtti.Register(AE.CameraComponent:RTTI(),        _NilFtn, _SelfOrNil, _DupFtn, _CreateFtn, Types.ReferenceType)
BlueRtti.Register(AE.FrameAnimationComponent:RTTI(),_NilFtn, _SelfOrNil, _DupFtn, _CreateFtn, Types.ReferenceType)
BlueRtti.Register(AE.TransformComponent:RTTI(),     _NilFtn, _SelfOrNil, _DupFtn, _CreateFtn, Types.ReferenceType)
BlueRtti.Register(AE.AnimationComponent:RTTI(),     _NilFtn, _SelfOrNil, _DupFtn, _CreateFtn, Types.ReferenceType)
BlueRtti.Register(cv.ClassifyComponent:RTTI(),      _NilFtn, _SelfOrNil, _DupFtn, _CreateFtn, Types.ReferenceType)
BlueRtti.Register(cv.RecognitionComponent:RTTI(),   _NilFtn, _SelfOrNil, _DupFtn, _CreateFtn, Types.ReferenceType)

BlueRtti.RegisterDefaultCpp(_NilFtn, _SelfOrNil, _DupFtn, _CreateInvalidFtn, NO_TYPE_INFO)

---- 蓝图类 -- 抽象 兜底 端内反序列化和运行 实际不需要类型
---  Case.1 当前场景中 没有了类的定义 但是依旧还有这个类的引用 --> 没有具体类的定义 和 抽象类BlueprintType没有typeinfo 所以变量类型列表不能选择
---                   因为 GetDefault GetLiteral  CreateFtn 都支持集成 所以使用没有问题
local function _BluePrintClassCreateFtn(rtti, metaData) -- BlueSelfNode return self.graph[BD.THIS] is Node
  local node = metaData;
  if node == nil then
    return nil
  end ;
  if vc.isNil(node) then
    return nil
  end
  local blueComp = node:GetComponent(AE.Node.CT_BLUEPRINT)
  local blueprint = BU.GetIns(blueComp);
  -- if _KRATOSEDITOR then
  local insId = blueprint:GetClassId()
  if not rtti:IsSameClassId(insId) then
    ERROR(string.format("Class ID not matched actual:%s wanted:%s", tostring(insId), tostring(rtti:GetClassId()) ));
    return nil
  end
  return blueprint
end

local function _BluePrintClassLiteralFtn(rtti, default)
  if default ~= nil and default:RTTI():isType(BlueprintSelf) then
    return default
  end
  return nil
end
BlueRtti.RegisterWithName(Types.BlueprintType:GetTypeName(), Types.BlueprintType,  _NilFtn,  _BluePrintClassLiteralFtn, _DupFtn, _BluePrintClassCreateFtn, nil)

-- 事件类型
BlueRtti.Register(Types.EventDelegateType, _NilFtn,  _NilFtn, _NilFtn,  _CreateInvalidFtn, nil )