local BD = require "bluecore.bluedefined"
local TN = require "bluecore.base.transaction_node"
local Types = require "venuscore.rtti.types"
local VC = require "venuscore"
local GetPhoto = TN:extend();

function GetPhoto:new(...)
  GetPhoto.super.new(self, ...)
end

-- override, like _OnUpdate()
function GetPhoto:_OnJsonToResult(jsonTbl)
  return jsonTbl["path"] -- number should match RegisterOutput
end

-- override
function GetPhoto:_OnCheckReady(outputResults)
  local result = outputResults ~= nil and outputResults[1] ~= nil and type(outputResults[1]) == "string" and VC.IFileSystem:isFileExist(outputResults[1])
  if not result then
    WARNING("[GetPhoto] _OnCheckReady not ready "..tostring(outputResults));
  end
  return result
end

-- override
function GetPhoto:_OnRequestJson()
  return "{}" -- do need extra info
end

-- override
function GetPhoto:_OnRequestType()
  return BD.RequestType.PHOTO
end

-- add
GetPhoto:RegisterOutput(1, Types.Tex2DPathType, "path", "图片路径")

-- overwrite
GetPhoto:SetFunctionName("Get Photo");

return GetPhoto;

