
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Types = require "venuscore.rtti.types"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local BlueDefined = require "bluecore.bluedefined"

local RotateAxis = BlueNode:extend();

---- 游戏运行模式
function RotateAxis:new(...)
  RotateAxis.super.new(self,...)
end

function RotateAxis:_OnUpdate(args)
  local theta, axis = unpack(args);
  return mathfunction.Mathutility:RotateAxis(axis, theta);
end


---- 编辑器模式

RotateAxis:RegisterInput(1, Types.FloatType, "theta", "旋转弧度", 0);
RotateAxis:RegisterInput(2, mathfunction.vector3:RTTI(), "axis", "设置旋转轴", mathfunction.vector3(0, 1, 0));

RotateAxis:RegisterOutput(1, mathfunction.Quaternion:RTTI(), "quaternion", "四元数");

RotateAxis:SetFunctionName("RotateAxis");

RotateAxis:SetFunctionType(BlueDefined.STATIC_FUNCTION_NODE); 

return RotateAxis ;
