local mf = require "mathfunction"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Vec3PlusVec3Exec = BlueNode:extend();

---- 游戏运行模式
function Vec3PlusVec3Exec:new(...)
  Vec3PlusVec3Exec.super.new(self, ...)
end

function Vec3PlusVec3Exec:_OnUpdate(args)
  local one = args[1] ;
  local two = args[2] ;
  return one + two ;
end

---- 编辑器模式

Vec3PlusVec3Exec:RegisterInput(1, mf.vector3:RTTI(), "1", "向量(x,y,z)", mf.vector3(0.0,0.0,0.0));
Vec3PlusVec3Exec:RegisterInput(2, mf.vector3:RTTI(), "2", "向量(x,y,z)", mf.vector3(0.0,0.0,0.0));
Vec3PlusVec3Exec:RegisterOutput(1, mf.vector3:RTTI(), "+", "相加的和(x,y,z)");
Vec3PlusVec3Exec:SetFunctionName("vec3+vec3(exec)");
Vec3PlusVec3Exec:SetFunctionType(BD.STATIC_FUNCTION_NODE);
Vec3PlusVec3Exec:RegisterExecInput(1, "Exec", "执行");
Vec3PlusVec3Exec:RegisterExecOutput(1, "Next", "执行");

return Vec3PlusVec3Exec;