local mf = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local MakeVector2f = BlueNode:extend();
local BD = require "bluecore.bluedefined"

---- 游戏运行模式
function MakeVector2f:new(...)
  MakeVector2f.super.new(self, ...)
end

function MakeVector2f:_OnUpdate(args)
  return mf.vector2(args[1], args[2])
end


---- 编辑器模式
MakeVector2f:RegisterInput(1, Types.FloatType, "x", "x 浮点");
MakeVector2f:RegisterInput(2, Types.FloatType, "y", "y 浮点");
MakeVector2f:RegisterOutput(1, mf.vector2():RTTI(), "vector2f", "合成向量(x,y)", mf.vector2(0.0,0.0));

MakeVector2f:SetFunctionName("Make Vector2f");
MakeVector2f:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return MakeVector2f ;