local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local IntToFloat = BlueNode:extend();

function IntToFloat:new(...)
  IntToFloat.super.new(self, ...)
end

function IntToFloat:_OnUpdate(args)
  if args[1] == nil then
    return ""
  else
    return args[1]
  end
end

IntToFloat:RegisterInput(1, Types.PathType, "path", "路径", "DEVICE_CAPTURE");
IntToFloat:RegisterOutput(1, Types.StringType, "string", "字符串");
IntToFloat:SetFunctionName("path->string");
IntToFloat:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return IntToFloat ;

