local BlueNode = require "bluecore.bluenode"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"

local OnRecordStop = BlueNode:extend();

function OnRecordStop:new(...)
  OnRecordStop.super.new(self, ...)
end

function OnRecordStop:_OnUpdate(eventParam)
end

function OnRecordStop:RegisterTriggerFunc(func, bluePrintSelf)
  EventDispatcher:RegisterCallback(BlueDefined.Event.RecordComponent, BlueDefined.Event.RecordEvent.Stop, func, bluePrintSelf);
end


--OnRecordStop节点只允许一个存在
function OnRecordStop:IsAllowDuplicate()
    return false;
end


OnRecordStop:RegisterExecOutput(1, "OnTrigger", "执行");

OnRecordStop:SetFunctionName("_OnRecordStop");

OnRecordStop:SetFunctionType(BlueDefined.EVENT_FUNCTION_NODE);

OnRecordStop:SetEventType(BlueDefined.EventType.RegisterCallback);

return OnRecordStop;

