local BlueNode = require "bluecore.bluenode"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"
local apolloengine = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local OnAniTrigger = BlueNode:extend();

---- 游戏运行模式
function OnAniTrigger:new(...)
  OnAniTrigger.super.new(self, ...)
  self.edge = true;
end

function OnAniTrigger:_OnUpdate(eventParam)
  self.output = eventParam
end

function OnAniTrigger:_OnNextBranch() --Update函数调用
  if self.edge and not self.output.isEdge then 
    return 0
  else
    return 1
  end
end

--编译的时候会调用
function OnAniTrigger:RegisterTriggerFunc(func, bluePrintSelf)
  self:_GetInput()
  self.edge = self.inputArgs[2];
  EventDispatcher:RegisterCallback(self.inputArgs[1]:GetContentPath(),
          BlueDefined.Event.AnimationEvent.Trigger .. self.inputArgs[3],
          func,
          bluePrintSelf);
end

---- 编辑器模式
OnAniTrigger:RegisterInput(1, apolloengine.AnimationComponent:RTTI(), "component", "监听组件", BlueSelf());
OnAniTrigger:RegisterInput(2, Types.BoolType, "edge", "边缘触发", true);
OnAniTrigger:RegisterInput(3, Types.IntType, "frame", "帧数", 0);

OnAniTrigger:RegisterExecOutput(1, "OnTrigger", "执行");

OnAniTrigger:SetFunctionName("_OnAniTrigger");

OnAniTrigger:SetFunctionType(BlueDefined.EVENT_FUNCTION_NODE);

OnAniTrigger:SetEventType(BlueDefined.EventType.RegisterCallback);

return OnAniTrigger;

