local BlueNode = require "bluecore.bluenode"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"
local apolloengine = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local OnAniStop = BlueNode:extend();

function OnAniStop:new(...)
  OnAniStop.super.new(self, ...)
  self.edge = true;
end

function OnAniStop:_OnUpdate(eventParam)
  self.output = eventParam
end

function OnAniStop:_OnNextBranch()
  if self.edge and not self.output.isEdge then 
    return 0
  else
    return 1
  end
end

function OnAniStop:RegisterTriggerFunc(func, bluePrintSelf)
  self:_GetInput()
  self.edge = self.inputArgs[2];
  EventDispatcher:RegisterCallback(self.inputArgs[1]:GetContentPath(), BlueDefined.Event.AnimationEvent.Stop, func, bluePrintSelf);
end


OnAniStop:RegisterInput(1, apolloengine.AnimationComponent:RTTI(), "component", "监听组件", BlueSelf());
OnAniStop:RegisterInput(2, Types.BoolType, "edge", "边缘触发", true);

OnAniStop:RegisterExecOutput(1, "OnTrigger", "执行");

OnAniStop:SetFunctionName("_OnAnimationStop");

OnAniStop:SetFunctionType(BlueDefined.EVENT_FUNCTION_NODE);

OnAniStop:SetEventType(BlueDefined.EventType.RegisterCallback);

return OnAniStop;

