local Types = require "venuscore.rtti.types"
local BlueDebug = require "bluecore.debug.bluedebug"
local BlueDynamicAnyTypePinsNode = require "bluecore.base.blue_dynamic_anytype_pins_node"
local BD = require "bluecore.bluedefined"

local SwitchOnInt = BlueDynamicAnyTypePinsNode:extend();

--Unreal里头不允许删除任意引脚 只能从最后一个开始删除


---- 游戏运行模式
function SwitchOnInt:new(...)
  SwitchOnInt.super.new(self, ...)

  self.startVal = 0.0;
  self.nextBranch = 1.0;
end


function SwitchOnInt:_GetstartVal()
  return self.startVal;
end

function SwitchOnInt:_SetstartVal(val)
  self.startVal = val;
  for i=2, #self.infoTable[BD.PIN_EXEC_OUTPUT], 1 do --self[BD.EXEC_OUTPUTS_INFO]指向同一内容~ blue_dynamic_node
    self.infoTable[BD.PIN_EXEC_OUTPUT][i].name = "Case   "..tostring(self.startVal+i-2);
    --self.execOutputs[i].name = "then";
    self.infoTable[BD.PIN_EXEC_OUTPUT][i].tips = "exec it case "..tostring(self.startVal+i-2);
  end
end

SwitchOnInt:MemberRegister("startVal", Types.IntType(nil, nil, SwitchOnInt._GetstartVal, SwitchOnInt._SetstartVal));


function SwitchOnInt.ReflectFilterFtn(obj, member, value)
 

  if obj:GetTypeID() == SwitchOnInt:GetTypeID() and member == "startVal" then 
    return true ;
  end 

end 

function SwitchOnInt:_OnUpdate(args)
  if args[1] >= self.startVal and args[1] <= self.startVal + #self.infoTable[BD.PIN_EXEC_OUTPUT] - 1  then
    self.nextBranch = args[1] - self.startVal + 2.0;
  else
    self.nextBranch = 1.0;
  end

end

function SwitchOnInt:_OnNextBranch()
  return self.nextBranch
end



---- 编辑器模式


function SwitchOnInt:_OnCreateWithEditor()
  SwitchOnInt.super._OnCreateWithEditor(self);
end


SwitchOnInt._OnAdd = function(thisNode)
  local inputInfo = thisNode.infoTable[BD.PIN_EXEC_OUTPUT][1]
  local pinUid = thisNode.graph:_NextID();
  local nodeUid = thisNode.uid;
  local newArgId = 1
  for _ , __ in pairs(thisNode[BD.EXEC_OUTPUTS_INFO]) do
    newArgId = newArgId + 1
  end
  local inputPin = thisNode:AppendExecOutput(Types.ExecPinType, "Case   "..tostring(thisNode.startVal+newArgId-2), "exec it case  "..tostring(newArgId-2), nil, pinUid, nodeUid, true);
  
  if newArgId > 2 then --只允许从后往前删
    thisNode.execOutputs[newArgId-1].delAble = false;
  end

  return inputPin
end

-- 之前已经删除连接信息,索引表在执行完所有删除操作之后才会移除对应pin/node
SwitchOnInt._OnDel = function(thisNode, execOutputPin)
  if #thisNode.execOutputs > 2 then
    thisNode.execOutputs[#thisNode.execOutputs-1].delAble = true;
  end
  thisNode:RemoveExecOutput(execOutputPin);
  return true
end

SwitchOnInt:RegisterExecInput(1, "exec", "Execute");
SwitchOnInt:RegisterExecOutput(1, "Default", "Default Execute");
SwitchOnInt:RegisterMoreExecOutput("exec", BD.OP_ADD, "增加输出执行节点引脚", SwitchOnInt._OnAdd, BD.OP_DEL, "删除输出执行节点引脚", SwitchOnInt._OnDel);

SwitchOnInt:RegisterInput(1, Types.IntType, "Selection", "整值", 0);

SwitchOnInt:SetFunctionName("SwitchOnInt");

return SwitchOnInt ;

